program iniqMenu;

uses Dos, Crt, Global, Strings;

type
   tMenuFlag = (
      mnuClearBefore,
      mnuNoCenter,
      mnuNoPrompt,
      mnuPauseBefore,
      mnuGlobalUse);

   tOldMenuRec = record
      mType         : Byte;
      MenuName      : String[255];
      PromptName    : String[60];
      HelpFile      : String[8];
      Prompt        : String[255];
      Acs           : tACString;
      Password      : String[20];
      Fallback      : String[8];
      Expert        : Byte;
      GenColumns    : Byte;
      Flag          : set of tMenuFlag;
      HotKey        : Byte;
      Reserved      : array[1..100] of Byte;
   end;

procedure conv(fn : String);
var nf, olf : file; M : tOldMenuRec;
begin
   Assign(olf,Fn+'.MNU');
   {$I-}
   Reset(olf,1);
   {$I+}
   if ioResult <> 0 then Exit;
   FillChar(Cmd^,SizeOf(Cmd^),0);
   FillChar(M,SizeOf(M),0);
   BlockRead(olf,M,SizeOf(M));
   numCmds := 0;
   while (numCmds < maxMenuCmd) and (not Eof(olf)) do
   begin
      Inc(numCmds);
      BlockRead(olf,Cmd^[numCmds],SizeOf(Cmd^[1]));
   end;
   Close(olf);
   Assign(nf,Fn+'.NEW');
   {$I-}
   Rewrite(nf,1);
   {$I+}
   if ioResult <> 0 then Exit;
   Fillchar(Menu^,SizeOf(Menu^),0);
   with Menu^ do
   begin
      mType := M.mType;
      MenuName := M.MenuName;
      PromptName := M.PromptName;
      HelpFile := M.HelpFile;
      Prompt := M.Prompt;
      Acs := M.Acs;
      Password := M.Password;
      Fallback := M.Fallback;
      Expert := M.Expert;
      GenColumns := M.Gencolumns;
      HotKey := M.HotKey;
      ClearBefore := mnuClearBefore in M.Flag;
      CenterTtl   := not (mnuNoCenter    in M.Flag);
      ShowPrompt  := not (mnuNoPrompt    in M.Flag);
      PauseBefore := mnuPauseBefore in M.Flag;
      GlobalUse   := mnuGlobalUse   in M.Flag;
      InputUp := True;
   end;
   BlockWrite(nf,Menu^,SizeOf(Menu^));
   BlockWrite(nf,Cmd^,SizeOf(Cmd^[1])*numCmds);
   Close(nf);
end;

var s : SearchRec; z : string;

begin
   TextMode(Co80);
   New(Menu);
   New(Cmd);
   FindFirst('*.MNU',0,s);
   while dosError = 0 do
   begin
      z := s.name;
      WriteLn(s.name,' ...');
      Delete(z,Pos('.',z),255);
      conv(z);
      FindNext(s);
   end;

   Dispose(Menu);
   Dispose(Cmd);
   WriteLn('done');
end.