{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
unit Nodes;

interface

procedure nodeDone;
procedure nodeInit;
procedure nodeList;
procedure nodeUpdate(stat : String);

implementation

uses Global, Output, Showfile, Misc, Strings, DateTime;

procedure nodeInit;
begin
   if not MultiNode then Exit;
   Assign(nodeFile,Cfg^.pathData+fileNode);
   {$I-}
   Reset(nodeFile,SizeOf(tNodeRec));
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(nodeFile,SizeOf(tNodeRec));
      {$I+}
      if ioResult <> 0 then Exit;
   end;
   FillChar(nodeInfo^,SizeOf(nodeInfo^),0);
   if FileSize(nodeFile) < Node then
   begin
      Seek(nodeFile,FileSize(nodeFile));
      while FileSize(nodeFile) < Node do BlockWrite(nodeFile,nodeInfo^,1);
   end;

   Seek(nodeFile,Node-1);
   BlockWrite(nodeFile,nodeInfo^,1);
end; { leaves nodeFile open ... }

procedure nodeUpdate(stat : String);
begin
   if not MultiNode then Exit;
   with nodeInfo^ do
   begin
      NodeNum  := Node;
      if UserOn then
      begin
         Username := User^.Username;
         Realname := User^.Realname;
         Usernum  := User^.Number;
         Baudrate := User^.Baudrate;
         Login    := TimeOn;
         Status   := stat;
      end else
      begin
         Username := '---';
         Realname := '---';
         Usernum  := 0;
         Baudrate := 0;
         Login    := TimeOn;
         Status   := 'Waiting for call';
      end;
   end;
   Seek(nodeFile,Node-1);
   BlockWrite(nodeFile,nodeInfo^,1);
end;

procedure nodeDone;
begin
   if not MultiNode then Exit;
   FillChar(nodeInfo^,SizeOf(tNodeRec),0);
   Seek(nodeFile,Node-1);
   BlockWrite(nodeFile,nodeInfo^,1);
   {$I-}
   Close(nodeFile);
   {$I+}
end;

procedure nodeList;
var ni : tNodeRec; ti, ton : tDateTimeRec; Ans : boolean;
begin
   if not MultiNode then
   begin
      oStringLn(strNodeNotMulti);
      Exit;
   end;
   PausePos := 1;
   PauseAbort := False;
   Ans := (sfGetTextFile(txNodeTop,ftTopLine) <> '') and
          (sfGetTextFile(txNodeMid,ftNodeList) <> '') and
          (sfGetTextFile(txNodeBot,ftNormal) <> '');
   if Ans then
   begin
      sfShowTextFile(txNodeTop,ftTopLine);
      oUpPause(ansiRows-1);
      sfGotoPos(1);
      sfLoadRepeat(txNodeMid);
   end else
   begin
      oClrScr;
      oDnLn(1);
      oSetCol(colInfo);
      oWriteLn(' '+Resize('Node',4)+
               ' '+Resize('Username',16)+
               ' '+Resize('Activity',39)+
               ' '+Resize('Baud',6)+
               ' Time on');
      oSetCol(colBorder);
      oWriteLn(sRepeat('',79));
      oUpPause(3);
      oSetCol(colText);
   end;
   Seek(nodefile,0);
   dtGetDateTime(ti);
   while (not HangUp) and (not Eof(nodeFile)) and (not PauseAbort) do
   begin
      BlockRead(nodeFile,ni,1);
      dtTimeDiff(ton,ni.Login,ti);
      sfStr[1] := st(ni.NodeNum);
      sfStr[2] := ni.Username;
      sfStr[3] := ni.Realname;
      if (ni.Realname = '---') and (ni.Username = '---') then
      begin
         sfStr[4] := '--';
         sfStr[5] := '---';
         sfStr[6] := '--:--';
      end else
      begin
         sfStr[4] := st(ni.Usernum);
         sfStr[5] := mBaudString(ni.Baudrate);
         sfStr[6] := dtTimeRecLen(ton);
      end;
      sfStr[7] := ni.Status;
      if ni.NodeNum = 0 then begin { do nothing } end else
      if Ans then
      begin
         sfShowRepeat(ftNodeList);
         if oWhereX <> 1 then oDnLn(1);
         oUpPause(1);
      end else
      begin
         dtTimeDiff(ton,ni.Login,ti);
         oWriteLn(' '+Resize(sfStr[1],4)+
                  ' '+Resize(sfStr[2],16)+
                  ' '+Resize(sfStr[7],39)+
                  ' '+Resize(sfStr[5],6)+
                  ' '+sfStr[6]);
         oUpPause(1);
      end;
   end;
   sfKillRepeat;
   if Ans then
   begin
      sfShowTextFile(txNodeBot,ftNormal);
      oUpPause(ansiRows);
   end else
   begin
      oSetCol(colBorder);
      oWriteLn(sRepeat('',79));
      oUpPause(1);
   end;
   PausePos := 0;
end;

end.