{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
unit Fossil;

interface

function SetBaud(Port, Baud : Word; Parms : Byte) : Boolean;
Function OutBufferEmpty(Port : Word) : Boolean;
function OutBufferFull(Port : Word) : Boolean;
function CharWaiting(Port : Word) : Boolean;
function ComReadChar(Port : Word) : Char;
function CarrierDetected(Port : Word) : Boolean;
function ModemRinging(Port : Word) : Boolean;
function FossilPresent : Boolean;
function LocalAnsiDetected : Boolean;
function StatusReq(P : Byte) : Byte;

procedure ActivatePort(Port : Word);
procedure DTR(Port : Word; Action : Byte);
procedure ReBoot(Action : Byte);
procedure DeActivatePort(Port : Word);
procedure ComWriteChar(Port : Word; Ch : Char);
procedure ClearOutBuffer(Port : Word);
procedure ClearInBuffer(Port : Word);
procedure FlowControl(Port : Word; XON_XOFFR, XON_XOFFT, RTS_CTS : Boolean);
procedure WatchDog(Port : Word; Action : Byte);
procedure ComWrite(Port : Word; Msg : String);
procedure ComWriteln(Port : Word; Msg : String);
procedure Wait(Seconds : Word);
procedure GetCursor(VAR x, y : Byte);
procedure SetCursor(Port : Word; x, y : Byte);
procedure SendBreak(Port : Word);
procedure ComReadln(Port : Word; VAR Msg : String; Count : Byte);
procedure PurgeInput(P : Byte);

CONST
  N81=$03; E81 =$1b; O81 =$0b; LOWER=$00; CTS =$10; RDA =$01; XONR=$01;
  N82=$07; E82 =$1f; O82 =$0f; RAISE=$01; DSR =$20; THRE=$20; XONT=$08;
  N71=$02; E71 =$1a; O71 =$0a; COLD =$00; RI  =$40; TSRE=$40; RTS =$02;
  N72=$06; E72 =$1e; O72 =$0e; WARM =$01; DCD =$80; ON  =$01; OFF =$00;
  Esc=#27; COM1=$00; COM2=$01; COM3 =$02; COM4=$03;

IMPLEMENTATION

Uses Crt, Dos,
     Global, Comm;

Function SetBaud(Port, Baud : Word; Parms : Byte) : Boolean;
VAR Dummy : Word;
Begin
  Case Baud of
    300:   Baud := $40;    { 01000000 }
    600:   Baud := $60;    { 01100000 }
    1200:  Baud := $80;    { 10000000 }
    2400:  Baud := $a0;    { 10100000 }
    4800:  Baud := $c0;    { 11000000 }
    9600:  Baud := $e0;    { 11100000 }
    19200: Baud := $00;    { 00000000 }
    38400,
    14400,
    16800: Baud := $20;    { 00100000 }
      else Baud := $23;
  End;
  Parms := Parms OR Baud;  { merge baud bits with parm bits }
  Asm
    mov ah,00h
    mov al,parms
    mov dx,port
    int 14h
    mov dummy,ax
  End;
  SetBaud := ((Dummy AND CTS) = CTS) or     { clear to send }
             ((Dummy AND DSR) = DSR) or     { data set ready }
             ((Dummy AND RI)  = RI)  or     { ring indicator }
             ((Dummy AND DCD) = DCD)        { data carrier detect }
End;

Function OutBufferFull(Port : Word) : Boolean;
VAR Dummy : Byte;
Begin
  Asm
    mov ah,03h
    mov dx,port
    int 14h
    mov dummy,ah
  End;
  OutBufferFull := ((Dummy AND THRE) <> THRE) or  { room in out buffer }
                   ((Dummy AND TSRE) <> TSRE)     { out buffer empty }
End;

Function OutBufferEmpty(Port : Word) : Boolean;
VAR Dummy : Byte;
Begin
  Asm
    mov ah,03h
    mov dx,port
    int 14h
    mov dummy,ah
  End;
  OutBufferEmpty := (dummy and (1 shl 6)) <> 0;
End;

Function CharWaiting(Port : Word) : Boolean;
VAR Dummy : Byte;
Begin
  Asm
    mov ah,03h
    mov dx,port
    int 14h
    mov dummy,ah
  End;
  CharWaiting := (Dummy AND RDA) = RDA        { character waiting }
End;

Function ComReadChar(Port : Word) : Char;
VAR Dummy : Byte;
Begin
  Asm
    mov ah,02h
    mov dx,port
    int 14h
    mov dummy,al
  End;
  ComReadChar := Char(Dummy)
End;

Function CarrierDetected(Port : Word) : Boolean;
VAR Dummy : Byte;
Begin
  Asm
    mov ah,03h
    mov dx,port
    int 14h
    mov dummy,al
  End;
  CarrierDetected := (Dummy AND DCD) = DCD       { carrier detected }
End;

Function ModemRinging(Port : Word) : Boolean;
VAR Dummy : Byte;
Begin
  Asm
    mov ah,03h
    mov dx,port
    int 14h
    mov dummy,al
  End;
  ModemRinging := (Dummy AND RI) = RI       { ring indicated }
End;

Function FossilPresent : Boolean;
VAR Dummy : Word;
Begin
  Asm
    mov ah,04h
    mov dx,00ffh
    int 14h
    mov dummy,ax
  End;
  FossilPresent := Dummy = $1954;
End;

Function LocalAnsiDetected : Boolean;
VAR Dummy : Byte;
Begin
  Asm
    mov ah,1ah                { detect ANSI.SYS device driver }
    mov al,00h
    int 2fh
    mov dummy,al
  End;
  LocalAnsiDetected := Dummy = $FF
End;

function StatusReq(P : Byte) : Byte;
var R : Registers;
begin
   R.AH := $03;
   R.DX := P;
   Intr($14,R);
   StatusReq := R.AX;
end;

procedure PurgeInput(P : Byte);
var R : Registers;
begin
   R.AH := $0A;
   R.DX := P;
   Intr($14,R);
end;

Procedure ActivatePort(Port : Word); Assembler;
Asm
  mov ah,04h
  mov dx,port
  int 14h
End;

Procedure DTR(Port : Word; Action : Byte); Assembler;
Asm
  mov ah,06h
  mov al,action
  mov dx,port
  int 14h
End;

Procedure ReBoot(Action : Byte); Assembler;
Asm
  mov ah,17h
  mov al,action
  int 14h
End;

Procedure DeActivatePort(Port : Word); Assembler;
Asm
  mov ax,05h
  mov dx,port
  int 14h
End;

Procedure ComWriteChar(Port : Word; Ch : Char);
VAR Dummy : Byte; I : Integer;
label Send;
Begin
{ while (OutBufferFull(Port)) and (CarrierDetected(Port)) do cCheckIt;}
  Dummy := Ord(Ch);
Send:
  Asm
    mov ah,0Bh
    mov al,dummy
    mov dx,port
    int 14h
    mov I,ax
  End;
  if I <> $0001 then
  begin
     cCheckIt;
     if HangUp then Exit else goto Send;
  end;
End;
{
Procedure ComWriteChar(Port : Word; Ch : Char);
VAR Dummy : Byte;
Begin
  while (OutBufferFull(Port)) and (CarrierDetected(Port)) do cCheckIt;
  Dummy := Ord(Ch);
  Asm
    mov ah,01h
    mov al,dummy
    mov dx,port
    int 14h
  End;
End;
}
Procedure ClearOutBuffer(Port : Word); Assembler;
Asm
  mov ah,09h
  mov dx,port
  int 14h
End;

Procedure ClearInBuffer(Port : Word); Assembler;
Asm
  mov ah,0ah
  mov dx,port
  int 14h
End;

Procedure FlowControl(Port : Word; XON_XOFFR, XON_XOFFT, RTS_CTS : Boolean);
VAR Dummy : Byte;
Begin
  Dummy := $00;
  If XON_XOFFR then                 { Xon/Xoff receive enable }
     Dummy := Dummy OR XONR else    { set bit 0 on }
     Dummy := Dummy AND XONR;       { set bit 0 off }
  If XON_XOFFT then                 { Xon/Xoff transmit enable }
     Dummy := Dummy OR XONT else    { set bit 3 on }
     Dummy := Dummy AND XONT;       { set bit 3 off }
  If RTS_CTS then                   { RTS_CTS enabled }
     Dummy := Dummy OR RTS else     { set bit 1 on }
     Dummy := Dummy AND RTS;        { set bit 1 off }
  Asm
    mov ah,0fh
    mov al,dummy
    mov dx,port
    int 14h
  End
End;

Procedure WatchDog(Port : Word; Action : Byte); Assembler;
Asm
  mov ah,14h
  mov al,action
  mov dx,port
  int 14h
End;

Procedure ComWrite(Port : Word; Msg : String);
VAR Dummy,
    SegMsg,
    OfsMsg : Word; L : Byte;
label Send;
Begin
Send:
  L := Ord(Msg[0]);
  if L = 0 then Exit;
  Dummy := L;             { length (msg) }
  SegMsg := Seg(Msg);
  OfsMsg := Ofs(Msg) + 1;           { don't include length of msg }
{ while (OutBufferFull(Port)) and (CarrierDetected(Port)) do cCheckIt;}
  Asm                               { use fossil driver }
    mov ah,19h
    mov dx,port
    mov cx,dummy
    mov es,SegMsg
    mov di,OfsMsg
    int 14h
    mov dummy,ax
  End;
  if dummy <> L then
  begin
     if dummy > 0 then Delete(Msg,1,dummy);
     cCheckIt;
     if HangUp then Exit;
     goto Send;
  end;
End;

Procedure ComWriteln(Port : Word; Msg : String);
Begin
   Msg := Msg + #13 + #10;
   ComWrite(Port, Msg)
End;

Procedure Wait(Seconds : Word);
VAR Delay : Word;
Begin
   Delay := ((976 SHL 10) * Seconds) SHR 16;  { (976*1024*seconds)/65536 }
   Asm
     mov ah,86h
     mov cx,delay
     mov dx,0
     int 15h
   End
End;

Procedure GetCursor(VAR x, y : Byte);
VAR x1, y1 : Byte;
Begin
  Asm
    mov ah,12h
    int 14h
    mov x1,dl
    mov y1,dh
  End;
  x := x1; y := y1
End;

Procedure SetCursor(Port : Word; x, y : Byte);
VAR x1,y1 : String;
Begin
    Str(x,x1);
    Str(y,y1);
    ComWrite(Port,' ['+y1+';'+x1+'H')     { ESC[y;xH }
End;

Procedure SendBreak(Port : Word); Assembler;
Asm
  mov ah,1ah             {; start sending break }
  mov al,01h
  mov dx,port
  int 14h
  mov ah,86h             {; wait 1 second }
  mov cx,0fh
  mov dx,00h
  int 15h
  mov ah,1ah             {; stop sending break }
  mov al,00h
  mov dx,port
  int 14h
  mov ah,0ah             {; purge input buffer }
  mov dx,port
  int 14h
End;

Procedure ComReadln(Port : Word; VAR Msg : String; Count : Byte);
VAR WLength,
    SegMsg,
    OfsMsg : Word;
Begin
   SegMsg := Seg(Msg);
   OfsMsg := Ofs(Msg);
   WLength := Count;
   Asm
     mov ah,18h
     mov di,ofsmsg
     mov es,segmsg
     mov cx,wlength
     mov dx,port
     int 14h
   End;
End;

End.
