unit Emulate;

interface

procedure emuANSiInit;
procedure emuANSitoScreen;
procedure emuANSiWriteChar(Ch : Char);
procedure emuANSiWriteLn(S : String);
procedure emuScreenToANSi;

implementation

uses Crt, Global, Output, ShowFile;

Type CmdType=(Up,Down,Right,Left,Loc,Cls,Cleol,Color,SavePos,LoadPos,Unsup);
     AnsRecord=Record
       Cmd: CmdType;
       Def: Byte;
     end;
     AnsParams=Record
       Num: Byte;
       Dat: Array[1..40] of Byte;
     end;
var AnsRec: AnsRecord;
    Param: AnsParams;
    oX,oY: Byte;
    oS: Boolean;
    InANSI : Boolean;
    Buf : String;

Procedure emuGetColors(Color : Byte; Var BackGr : Byte; Var ForeGr : Byte; var Bl : Boolean);
begin
  BackGr := Color shr 4;
  ForeGr := Color xor (BackGr shl 4);
  if BackGr > 7 then
  begin
     Dec(BackGr,8);
     Bl := True;
  end else Bl := False;
end;

procedure emuANSiInit;
begin
   oS := False;
   oX := 1;
   oY := 1;
   InANSI := False;
   Buf := '';
end;

procedure emuANSiWriteChar(Ch : Char);
Var I,B: Integer;
    T: String;
begin
  If (Ch=#27) Or (InANSI) Then
  begin
    InANSI:=True;
    Buf:=Buf+Ch;
    If Not (Ch In ['A'..'Z','a'..'z',#14]) Then Exit;
    With AnsRec Do Case Buf[Length(Buf)] Of
      'A': Cmd:=Up;
      'B': Cmd:=Down;
      'C': Cmd:=Right;
      'D': Cmd:=Left;
      'H': Cmd:=Loc;
      'J': Cmd:=Cls;
      'K': Cmd:=Cleol;
      'f': Cmd:=Loc;
      'm': Cmd:=Color;
      's': Cmd:=SavePos;
      'u': Cmd:=LoadPos;
      else Cmd:=UnSup;
    end;
    With AnsRec Do Case Cmd Of
      Up,Down,Left,Right,Loc,Cls,Cleol,SavePos,LoadPos: Def:=1;
      Color: Def:=0;
    end;
    Delete(Buf,1,2);
    Delete(Buf,Length(Buf),1);
    For I:=1 to 40 Do Param.Dat[I]:=AnsRec.Def;
    Param.Num:=0;
    If Not(Buf='') Then
    begin
    While Pos(';',Buf)<>0 Do
    begin
      Inc(Param.Num);
      T:=Buf;
      Delete(T,Pos(';',T),Length(T)-(Pos(';',T)-1));
      Val(T,Param.Dat[Param.Num],I);
      Delete(Buf,1,Pos(';',Buf));
    end;
    Inc(Param.Num);
    Val(Buf,Param.Dat[Param.Num],I);
    end;
    Case AnsRec.Cmd Of
      Up: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do GotoXY(WhereX,WhereY-Param.Dat[Param.Num]);
      end;
      Down: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do GotoXY(WhereX,WhereY+Param.Dat[Param.Num]);
      end;
      Right: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do GotoXY(WhereX+Param.Dat[Param.Num],WhereY);
      end;
      Left: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do GotoXY(WhereX-Param.Dat[Param.Num],WhereY);
      end;
      Loc: begin posX := Param.Dat[2]; PosY := Param.Dat[1]; GotoXY(posX,posY); end;
      Cls: ClrScr;
      Cleol: ClrEol;
      SavePos: begin
        oS:=True;
        oX:=WhereX;
        oY:=WhereY;
      end;
      LoadPos: If oS Then GotoXY(oX,oY);
      Color:
      begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do
          Case Param.Dat[I] of
              0: TextAttr:=7;
              1: If (TextAttr mod 16)<8 Then TextAttr:=TextAttr+8;
              2: If (TextAttr mod 16)>7 Then TextAttr:=TextAttr-8;
              4: {Underline};
           5,6: If (TextAttr<128) Then TextAttr:=TextAttr+128;
              7: TextAttr:=TextAttr XOR 255;
              8: TextAttr:=(TextAttr DIV 16)*16+(TextAttr DIV 16);
             30: TextAttr:=(TextAttr DIV 16)*16+((TextAttr MOD 16) DIV 8)*8;
             31: TextAttr:=(TextAttr DIV 16)*16+4+((TextAttr MOD 16) DIV 8)*8;
             32: TextAttr:=(TextAttr DIV 16)*16+2+((TextAttr MOD 16) DIV 8)*8;
             33: TextAttr:=(TextAttr DIV 16)*16+6+((TextAttr MOD 16) DIV 8)*8;
             34: TextAttr:=(TextAttr DIV 16)*16+1+((TextAttr MOD 16) DIV 8)*8;
             35: TextAttr:=(TextAttr DIV 16)*16+5+((TextAttr MOD 16) DIV 8)*8;
             36: TextAttr:=(TextAttr DIV 16)*16+3+((TextAttr MOD 16) DIV 8)*8;
             37: TextAttr:=(TextAttr DIV 16)*16+7+((TextAttr MOD 16) DIV 8)*8;
             40: TextAttr:=TextAttr MOD 16;
             41: TextAttr:=64+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             42: TextAttr:=32+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             43: TextAttr:=96+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             44: TextAttr:=16+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             45: TextAttr:=80+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             46: TextAttr:=48+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             47: TextAttr:=112+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
          end;
        emuGetColors(TextAttr,Col.Back,Col.Fore,Col.Blink);
      end;
    end;
    Buf:='';
    InANSI:=False;
  end else
  begin
    If (Ch=#9) Then
    begin
      B:=WhereX;
      For I:=1 to 9-(B MOD 9) Do emuANSiWriteChar(' ');
    end
    else
    begin
      If (Ch=#10) Then Write(#13);
      Write(ch);
    end;
  end;
end;

procedure emuANSiWrite(S : String);
Var I: Byte;
begin
  For I:=1 to Length(S) Do emuANSiWriteChar(S[I]);
end;

procedure emuANSiWriteLn(S: String);
begin
  emuANSiWrite(S); Writeln;
end;

procedure emuScreenToANSi;
var ansScr : Text;

  Procedure Xlate(var OutFile : text);
  const
    NUMROWS = 24;
    NUMCOLS = 80;
  type
    ElementType = record
                    ch   : char;
                    Attr : byte;
                  end;
    ScreenType = array[1..NUMROWS,1..NUMCOLS] of ElementType;

  const
    TextMask = $07; {0000 0111}
    BoldMask = $08; {0000 1000}
    BackMask = $70; {0111 0000}
    FlshMask = $80; {1000 0000}
    BackShft = 4;

    ESC = #$1B;

    ANSIcolors : array[0..7] of byte = (0, 4, 2, 6, 1, 5, 3, 7);

    Procedure ChangeAttr(var Outfile : text; var OldAtr : byte; NewAtr : byte);
    var
      Connect : string[1]; {Is a seperator needed?}
    begin
      Connect := '';
      write(Outfile, ESC, '['); {Begin sequence}
      If (OldAtr AND (BoldMask+FlshMask)) <>     {Output flash & blink}
         (NewAtr AND (BoldMask+FlshMask)) then begin
        write(Outfile, '0');
        If NewAtr AND BoldMask <> 0 then write(Outfile, ';1');
        If NewAtr AND FlshMask <> 0 then write(Outfile, ';5');
        OldAtr := $FF; Connect := ';';   {Force other attr's to print}
      end;

      If OldAtr AND BackMask <> NewAtr AND BackMask then begin
        write(OutFile, Connect,
              ANSIcolors[(NewAtr AND BackMask) shr BackShft] + 40);
        Connect := ';';
      end;

      If OldAtr AND TextMask <> NewAtr AND TextMask then begin
        write(OutFile, Connect,
              ANSIcolors[NewAtr AND TextMask] + 30);
      end;

      write(outfile, 'm'); {Terminate sequence}
      OldAtr := NewAtr;
    end;

    {Does this character need a changing of the attribute?  If it is a space,
     then only the background color matters}

    Function AttrChanged(Attr : byte; ThisEl : ElementType) : boolean;
    var
      Result : boolean;
    begin
      Result := FALSE;
      If ThisEl.ch = ' ' then begin
        If ThisEl.Attr AND BackMask <> Attr AND BackMask then
          Result := TRUE;
      end else begin
        If ThisEl.Attr <> Attr then Result := TRUE;
      end;
      AttrChanged := Result;
    end;

  var
    Screen   : ScreenType absolute $b800:0000;
    ThisAttr, TestAttr : byte;
    LoopRow, LoopCol, LineLen : integer;
  begin {Xlate}
    ThisAttr := $FF; {Force attribute to be set}
    For LoopRow := 1 to NUMROWS do begin

      LineLen := NUMCOLS;   {Find length of line}
      While (LineLen > 0) and (Screen[LoopRow, LineLen].ch = ' ')
            and not AttrChanged($00, Screen[LoopRow, LineLen])
        do Dec(LineLen);

      For LoopCol := 1 to LineLen do begin {Send stream to file}
        If AttrChanged(ThisAttr, Screen[LoopRow, LoopCol])
          then ChangeAttr(Outfile, ThisAttr, Screen[LoopRow, LoopCol].Attr);
        write(Outfile, Screen[LoopRow, LoopCol].ch);
      end;
    If LineLen < 80 then writeln(OutFile); {else wraparound occurs}
    end;
  end; {Xlate}

begin
   Assign(ansScr,Cfg^.pathText+fileTempScr);
   Rewrite(ansScr);
   Write(ansScr,#27'[0m'#27'[2J');
   Xlate(ansScr);
   Close(ansScr);
   scrX := oWhereX;
   scrY := oWhereY;
   scrCol := Col;
end;

procedure emuANSitoScreen;
begin
   oClrScr;
   oSetColor(15,0);
   sfShowTextFile(fileTempScr,ftNormal);
   oGotoXY(scrX,scrY);
   oSetColRec(scrCol);
end;

end.