{F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
{$M 40000,0,100000}

(*                                                                          *)
(*   Iniquity EchoMail Manager                                              *)
(*   (C)Copyright 1994, Mike Fricker                                        *)
(*                                                                          *)

program iniqMail;

uses
   Dos,
   Crt,
   Global, FastIO, Files, Misc, Strings, MsgArea, DateTime;

const
   fileHiWater = bbsTitle+'.HWM';
   fileGecho   = '1.MSG';

   maxBuf      = 2048;

type
   tFidoHeadRec = record
      maFrom,
      maTo           : array[1..36] of Char;
      maSubject      : array[1..72] of Char;
      maDate         : array[1..20] of Char;
      maTimesRead,
      nodeDest,
      nodeOrig,
      maCost,
      netOrig,
      netDest         : Integer;
      dateWritten,
      dateArrived     : LongInt;
      maRef           : Integer;
      maAttrL,
      maAttrH         : Byte;
      UnReply         : Integer;
   end;

var
   fA : file of tMsgAreaRec;
   fC : file of tCfgRec;

function mailPackedDate(S : String) : LongInt;
var Dt : Dos.DateTime; L : LongInt; Z : String;
begin
   mailPackedDate := 0;
   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Day := StrToInt(Z);

   Z := UpStr(S[1]+S[2]+S[3]);
   Delete(S,1,4);

   Dt.Month := 1;
   if Z = 'JAN' then Dt.Month := 1 else
   if Z = 'FEB' then Dt.Month := 2 else
   if Z = 'MAR' then Dt.Month := 3 else
   if Z = 'APR' then Dt.Month := 4 else
   if Z = 'MAY' then Dt.Month := 5 else
   if Z = 'JUN' then Dt.Month := 6 else
   if Z = 'JUL' then Dt.Month := 7 else
   if Z = 'AUG' then Dt.Month := 8 else
   if Z = 'SEP' then Dt.Month := 9 else
   if Z = 'OCT' then Dt.Month := 10 else
   if Z = 'NOV' then Dt.Month := 11 else
   if Z = 'DEC' then Dt.Month := 12;

   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Year := 1900+StrToInt(Z);

   if S[1] = ' ' then Delete(S,1,1);

   Z := S[1]+S[2];
   if Z[1] = ' ' then Delete(Z,1,1);
   Delete(S,1,3);
   Dt.Hour := StrToInt(Z);

   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Min := StrToInt(Z);

   Z := S[1]+S[2];
   Dt.Sec := StrToInt(Z);

   PackTime(Dt,L);

   mailPackedDate := L;
end;

function mailFidoDate(L : LongInt) : String; { DD MMM YY  HH:MM:SS }
var Dt : Dos.DateTime; Z, S : String;
begin
   UnpackTime(L,Dt);
   mailFidoDate := '';
   FillChar(S,SizeOf(S),0);
   S := St(Dt.Day);
   if Length(S) < 2 then Insert('0',S,1);
   S := S+' ';
   case Dt.Month of
     1  : Z := 'Jan';
     2  : Z := 'Feb';
     3  : Z := 'Mar';
     4  : Z := 'Apr';
     5  : Z := 'May';
     6  : Z := 'Jun';
     7  : Z := 'Jul';
     8  : Z := 'Aug';
     9  : Z := 'Sep';
     10 : Z := 'Oct';
     11 : Z := 'Nov';
     12 : Z := 'Dec';
     else Z := 'Ukn';
   end;
   if Dt.Year < 1901 then Dt.Year := 1901;
   S := S+Z+' '+St(Dt.Year-1900)+'  ';

   Z := St(Dt.Hour);
   if Length(Z) < 2 then Insert('0',Z,1);
   S := S+Z+':';
   Z := St(Dt.Min);
   if Length(Z) < 2 then Insert('0',Z,1);
   S := S+Z+':';
   Z := St(Dt.Sec);
   if Length(Z) < 2 then Insert('0',Z,1);
   S := S+Z;

   mailFidoDate := S;
end;

function mailmportEcho(Fn : String; var Head : tMsgHeaderRec; var Txt : tMessage) : Boolean;
var mHead : tFidoHeadRec; fH : file of tFidoHeadRec; C : Char; fT : file;
    N, Z, X : Word; un : String; Buf : array[1..maxBuf] of Char;
    sRead, tRead : LongInt;
    nRead : Integer;

begin
   mailmportEcho := False;
   Assign(fH,Fn);
   {$I-}
   Reset(fH);
   {$I+}
   if ioResult <> 0 then Exit;
   {$I-}
   Read(fH,mHead);
   {$I+}
   if ioResult <> 0 then begin Close(fH); Exit; end;
   Close(fH);
   Assign(fT,Fn);
   Reset(fT,1);
   Seek(fT,SizeOf(mHead));
   FillChar(Txt,SizeOf(Txt),0);
   FillChar(Head,SizeOf(Head),0);
   N := 1;
   Head.sigPos := 0;

   tRead := 0;
   sRead := FileSize(ft)-SizeOf(mHead);
   while (ioResult = 0) and (N <= maxMsgLines) and (tRead < sRead) do
   begin
      {$I-}
      BlockRead(ft,Buf,maxBuf,nRead);
      {$I+}
      Inc(tRead,nRead);
      for X := 1 to nRead do
      begin
         if (not (Buf[x] in [#10,#13])) and (Ord(Txt[N,0]) < 80) then
            Txt[N] := Txt[N]+Buf[x] else if Buf[x] = #13 then Inc(N);
      end;
   end;
   Close(ft);
   if N > maxMsgLines then Txt[maxMsgLines] := '--- [iniqMail] This message has been truncated to 200 lines.';
   Un := '';
   Z := 1;
   while Z <= N do if Txt[Z,1] = #1 then
   begin
      if Copy(Txt[Z],1,10) = #1'USERNOTE:' then Un := Copy(Txt[Z],12,255) else
      if Copy(Txt[Z],1,8) = #1'SIGPOS:' then Head.sigPos := strToInt(Copy(Txt[Z],10,255));
      for X := Z+1 to N do Txt[X-1] := Txt[X];
      Dec(N);
   end else Inc(Z);

   if Head.sigPos = 0 then
   for Z := 1 to N do
   begin
      if (Copy(Txt[Z],1,4) = '--- ') and (Head.sigPos = 0) then Head.sigPos := Z;
      if (Copy(Txt[Z],1,10) = ' * Origin:') and (Head.sigPos = 0) then Head.sigPos := Z;
   end;
   with Head.FromInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      for Z := 1 to 36 do if mHead.maFrom[Z] in [' ',#0] then mHead.maFrom[Z] := ' ';
      Name := CleanUp(mHead.maFrom);
      if Un <> '' then UserNote := Un else UserNote := 'None';
      Address := Cfg^.Address[mArea^.Address];
{     Address.Node :=}
   end;
   with Head.ToInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      for Z := 1 to 36 do if mHead.maTo[Z] in [' ',#0] then mHead.maTo[Z] := ' ';
      Name := CleanUp(mHead.maTo);
      UserNote := 'None';
      Address := Cfg^.Address[mArea^.Address];
   end;
   Head.Size := N;
   Head.Date := dtDateTimePacked; {mailEchoDate(mHead.maDate);}
   for Z := 1 to 72 do if mHead.maSubject[Z] in [' ',#0] then mHead.maSubject[Z] := ' ';
   Head.Subject := strSquish(CleanUp(mHead.maSubject),40);
   Head.Status := [msgEchoMail];
   Head.NetFlag := [];
   Z := mHead.maAttrL;
   if mGetBit(Z,00) then Head.netFlag := Head.netFlag+[nPrivate];
   if mGetBit(Z,01) then Head.netFlag := Head.netFlag+[nCrash];
   if mGetBit(Z,02) then Head.netFlag := Head.netFlag+[nReceived];
   if mGetBit(Z,03) then Head.netFlag := Head.netFlag+[nSent];
   if mGetBit(Z,04) then Head.netFlag := Head.netFlag+[nFileAttached];
   if mGetBit(Z,05) then Head.netFlag := Head.netFlag+[nInTransit];
   if mGetBit(Z,06) then Head.netFlag := Head.netFlag+[nOrphan];
   if mGetBit(Z,07) then Head.netFlag := Head.netFlag+[nKillSent];
   Z := mHead.maAttrH;
   if mGetBit(Z,00) then Head.netFlag := Head.netFlag+[nLocal];
   if mGetBit(Z,01) then Head.netFlag := Head.netFlag+[nHold];
   if mGetBit(Z,02) then Head.netFlag := Head.netFlag+[nUnused];
   if mGetBit(Z,03) then Head.netFlag := Head.netFlag+[nFileRequest];
   if mGetBit(Z,04) then Head.netFlag := Head.netFlag+[nReturnReceiptRequest];
   if mGetBit(Z,05) then Head.netFlag := Head.netFlag+[nIsReturnReceipt];
   if mGetBit(Z,06) then Head.netFlag := Head.netFlag+[nAuditRequest];
   if mGetBit(Z,07) then Head.netFlag := Head.netFlag+[nFileUpdateRequest];
   if nPrivate in Head.netFlag then Head.Status := Head.Status+[msgPrivate];
   Head.Replies := 0;
   Head.incFile := 0;
   mailmportEcho := True;
end;

function mailExportEcho(Fn : String; var Head : tMsgHeaderRec; var Txt : tMessage) : Boolean;
var mHead : tFidoHeadRec; fH : file; S : String; X : Word;
begin
   mailExportEcho := False;
   FillChar(mHead,SizeOf(mHead),0);

   with mHead do
   begin
      S := Head.FromInfo.Name;
      Move(S[1],maFrom,Length(S));
      S := Head.ToInfo.Name;
      Move(S[1],maTo,Length(S));
      S := Head.Subject;
      Move(S[1],maSubject,Length(S));
      S := mailFidoDate(Head.Date);
      Move(S[1],maDate,Length(S));
      maTimesRead     := 1;
      nodeDest        := 0; {Cfg^.Address[mArea^.Address].Node;}
      nodeOrig        := Cfg^.Address[mArea^.Address].Node;
      maCost          := 0;
      netOrig         := Cfg^.Address[mArea^.Address].Net;
      netDest         := 0; {Cfg^.Address[mArea^.Address].Net;}
      dateWritten     := 0; {Head.Date;}
      dateArrived     := 0; {dtDateTimePacked;}
      maRef           := 0;
      maAttrL         := 0;
      maAttrH         := 0;
      if nPrivate in Head.netFlag then maAttrL := maAttrL or (1 shl 0);
      maAttrL := maAttrL or (1 shl 7);  { kill }
      maAttrH := maAttrH or (1 shl 0);  { local }
      if nHold in Head.netFlag then maAttrH := maAttrH or (1 shl 1);
      UnReply         := 0;
   end;
   Assign(fH,Fn);
   {$I-}
   Rewrite(fH,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockWrite(fH,mHead,SizeOf(mHead));
   S := #1+'PID: '+bbsTitle+' v'+bbsVerLong+#13;
   BlockWrite(fH,S[1],Length(S));
   S := #1+'USERNOTE: '+Head.FromInfo.UserNote+#13;
   BlockWrite(fH,S[1],Length(S));
   if Head.sigPos > 0 then
   begin
      S := #1+'SIGPOS: '+St(Head.sigPos)+#13;
      BlockWrite(fH,S[1],Length(S));
   end;
   for X := 1 to Head.Size do
   begin
      S := Txt[X]+#13#10;
      BlockWrite(fH,S[1],Length(S));
   end;
   if Cfg^.Origin[mArea^.Origin] <> '' then
   begin
      S := '--- '+bbsTitle+' v'+bbsVerLong+#13#10;
      BlockWrite(fH,S[1],Length(S));
      S := ' * Origin: '+Cfg^.Origin[mArea^.Origin]+#13#10;
      BlockWrite(fH,S[1],Length(S));
   end;
   Close(fH);
   mailExportEcho := True;
end;
(*
procedure mailUpdateMarker(Fn : String; High : LongInt);
var F : file; M : tFidoHeadRec; S : String;
begin
   FillChar(M,SizeOf(M),0);
   with M do
   begin
      S := bbsTitle;
      Move(S[1],maFrom,Length(S));
      S := bbsTitle;
      Move(S[1],maTo,Length(S));
      S := 'High water marking message';
      Move(S[1],maSubject,Length(S));
      S := mailFidoDate(High);
      Move(S[1],maDate,Length(S));
      maTimesRead     := 0;
      nodeDest        := 0;
      nodeOrig        := 0;
      maCost          := 0;
      netOrig         := 0;
      netDest         := 0;
      dateWritten     := 0;
      dateArrived     := 0;
      maRef           := 0;
      maAttr          := 0;
      maAttr          := maAttr or (0 shl 9);
      maAttr          := maAttr or (2 shl 9);
      maAttr          := maAttr or (3 shl 9);
      UnReply         := 0;
   end;
   Assign(F,Fn);
   {$I-}
   Rewrite(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockWrite(F,M,SizeOf(M));
   FillChar(S,SizeOf(S),0);
   S := bbsTitle+' v'+bbsVersion+' echomail processor -- high water marker'+#13#13;
   BlockWrite(F,S[1],Length(S));
   Close(F);
end; *)

procedure mailUpdateMarker(Fn : String; High : LongInt);
var F : file;
begin
   Assign(F,Fn);
   {$I-}
   Rewrite(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockWrite(F,High,SizeOf(High));
   Close(F);
end;

function mailReadMarker(Fn : String) : LongInt;
var F : file; {M : tFidoHeadRec;} L : LongInt;
begin
   mailReadMarker := 0;
(* FillChar(M,SizeOf(M),0);
   Assign(F,Fn);
   {$I-}
   Reset(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockRead(F,M,SizeOf(M));
   Close(F);
   mailReadMarker := mailPackedDate(M.maDate);*)
   Assign(F,Fn);
   {$I-}
   Reset(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockRead(F,L,SizeOf(L));
   Close(F);
   mailReadMarker := L;
end;

procedure mailToss;
var N, X : Word; Txt : tMessage; Head : tMsgHeaderRec; fH : file of tMsgHeaderRec;
begin
   while not Eof(fA) do
   begin
      Read(fA,mArea^);
      if mArea^.areaType = mareaEchoMail then
      begin
         ioTextAttr($01);
         ioWrite('Processing ');
         ioTextAttr($09);
         ioWrite(mArea^.Name);
         ioTextAttr($08);
         ioWrite('... ');
         X := ioWhereX;
         N := 2;
         while fExists(mArea^.MsgPath+St(N)+extMsgEcho) do
         begin
            ioGotoXY(X,ioWhereY);
            ioTextAttr($05);
            ioWrite('(msg ');
            ioTextAttr($0D);
            ioWrite(St(N));
            ioTextAttr($05);
            ioWrite(')');
            if mailmportEcho(mArea^.MsgPath+St(N)+extMsgEcho,Head,Txt) then
               maAddMessage(Txt,Head,False);
            Inc(N);
         end;
         Assign(fH,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
         {$I-}
         Reset(fH);
         {$I+}
         if (ioResult = 0) and (fileSize(fH) >= 1) then
         begin
            mArea^.Msgs := FileSize(fH);
            Seek(fH,FileSize(fH)-1);
            Read(fH,Head);
            Close(fH);
            mailUpdateMarker(mArea^.MsgPath+fileHiWater,dtDateTimePacked);
            Seek(fA,FilePos(fA)-1);
            Write(fA,mArea^);
         end;
         ioGotoXY(X,ioWhereY);
         ioTextAttr($01);
         ioWrite('Complete');
         ioTextAttr($08);
         ioWriteLn('.     ');
      end;
   end;
end;

procedure mailScan;
var Dt, Hi : LongInt; N, Z, X : Word; Txt : tMessage; Head : tMsgHeaderRec; fH : file of tMsgHeaderRec;
begin
   while not Eof(fA) do
   begin
      Read(fA,mArea^);
      if mArea^.areaType = mareaEchoMail then
      begin
         ioTextAttr($02);
         ioWrite('Scanning ');
         ioTextAttr($0A);
         ioWrite(mArea^.Name);
         ioTextAttr($08);
         ioWrite('... ');
         X := ioWhereX;
         N := 1;
         dt := mailReadMarker(mArea^.MsgPath+fileHiWater);
         fDeleteFile(mArea^.MsgPath+fileGecho);
         Hi := dt;
         Assign(fH,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
         {$I-}
         Reset(fH);
         {$I+}
         if ioResult = 0 then
         begin
            Z := 0;
            while not Eof(fH) do
            begin
               Read(fH,Head);
               Hi := Head.Date;
               Inc(Z);
               if (not (msgDeleted in Head.Status)) and
                  (Head.Date > dt) and (maLoadMessage(Txt,Head,Z)) then
               begin
                  Inc(N);
                  while (fExists(mArea^.MsgPath+St(N)+extMsgEcho)) and (N < 999) do Inc(N);
                  ioGotoXY(X,ioWhereY);
                  ioTextAttr($08);
                  ioWrite('(msg ');
                  ioTextAttr($07);
                  ioWrite(St(N));
                  ioTextAttr($08);
                  ioWrite(')');
                  mailExportEcho(mArea^.MsgPath+St(N)+extMsgEcho,Head,Txt);
                  Head.Status := Head.Status+[msgSent];
                  Seek(fH,Z-1);
                  Write(fH,Head);
               end;
            end;
            Close(fH);
         end;
         mailUpdateMarker(mArea^.MsgPath+fileHiWater,dtDateTimePacked);
         ioGotoXY(X,ioWhereY);
         ioTextAttr($02);
         ioWrite('Complete');
         ioTextAttr($08);
         ioWriteLn('.     ');
      end;
   end;
end;

procedure mailPurge;
var X : Word; Txt : tMessage; Sr : SearchRec; cD : String; F : file;
begin
   while not Eof(fA) do
   begin
      Read(fA,mArea^);
      if mArea^.areaType = mareaEchoMail then
      begin
         ioTextAttr($04);
         ioWrite('Purging ');
         ioTextAttr($0C);
         ioWrite(mArea^.Name);
         ioTextAttr($08);
         ioWrite('... ');
         X := ioWhereX;
         FindFirst(mArea^.MsgPath+'*'+extMsgEcho,0,Sr);
         while dosError = 0 do if (Sr.Name <> fileHiWater) and
                                  (Sr.Name <> fileGecho) then
         begin
            ioGotoXY(X,ioWhereY);
            ioTextAttr($07);
            ioWrite('(msg ');
            ioTextAttr($0F);
            ioWrite(Copy(Sr.Name,1,Pos('.',Sr.Name)-1));
            ioTextAttr($07);
            ioWrite(')');
            Assign(F,mArea^.MsgPath+Sr.Name);
            {$I-}
            Erase(F);
            {$I+}
            FindNext(Sr);
         end else FindNext(Sr);
{        mailUpdateMarker(mArea^.MsgPath+fileHiWater,dtDateTimePacked);}
         ioGotoXY(X,ioWhereY);
         ioTextAttr($04);
         ioWrite('Complete');
         ioTextAttr($08);
         ioWriteLn('.     ');
      end;
   end;
end;

procedure mailReset;
var Dt : Dos.DateTime; L : LongInt;
begin
   Dt.Year := 1990;
   Dt.Month := 1;
   Dt.Day := 1;
   Dt.Hour := 0;
   Dt.Min := 0;
   Dt.Sec := 0;
   PackTime(Dt,L);
   while not Eof(fA) do
   begin
      Read(fA,mArea^);
      if mArea^.areaType = mareaEchoMail then
      begin
         ioTextAttr($05);
         ioWrite('Resetting ');
         ioTextAttr($0D);
         ioWrite(mArea^.Name);
         ioTextAttr($08);
         ioWrite('... ');
         mailUpdateMarker(mArea^.MsgPath+fileHiWater,0);
         fDeleteFile(mArea^.MsgPath+fileGecho);
         ioTextAttr($05);
         ioWrite('Complete');
         ioTextAttr($08);
         ioWriteLn('.     ');
      end;
   end;
end;

procedure mailError;
begin
   Dispose(Cfg);
   Dispose(mArea);
   Halt(255);
end;

begin
   New(mArea);
   New(Cfg);
   TextMode(co80);
   ioInitFastIO;
   ioClrScr;
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($0F);
   ioWriteLn('iniqMail v'+bbsVersion+'  (c)Copyright 1995, Mike Fricker');
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($07);
   ioWriteLn('Echomail import/export utility for Iniquity bulletin board systems');
   ioTextAttr($08);
   ioWrite(sRepeat('',80));
   ioTextAttr($07);
   Assign(fC,fileConfig);
   {$I-}
   Reset(fC);
   {$I+}
   if ioResult <> 0 then
   begin
      ioWriteLn(fileConfig+' not found in current directory.');
      ioWriteLn('Please change to your Iniquity directory before executing this program.');
      mailError;
   end;
   Read(fC,Cfg^);
   Close(fC);
   Assign(fA,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(fA);
   {$I+}
   if ioResult <> 0 then
   begin
      ioWriteLn(fileMsgArea+' not found in your data directory ('+Cfg^.pathData+').');
      ioWriteLn('Please ensure that this file exists before using this program.');
      mailError;
   end;
   if mParam('PURGE') then mailPurge else
   if mParam('RESET') then mailReset else
   if mParam('SCAN') then mailScan else
   if mParam('TOSS') then mailToss else
   begin
      if ParamCount = 0 then ioWriteLn('No command specified') else
                             ioWriteLn('Invalid echomail command');
      ioWriteLn('');
      ioWriteLn('PURGE  Purge (destroy) messages in echomail directories');
      ioWriteLn('RESET  Reset all echomail export scanning message pointers');
      ioWriteLn('SCAN   Scan and export new outbound echomail in message areas');
      ioWriteLn('TOSS   Toss incoming messages into echomail areas');
      Close(fA);
      mailError;
   end;
   Close(fA);
   Dispose(Cfg);
   Dispose(mArea);
end.