Unit ZFiles;
Interface
Uses DOS;

Function  Z_OpenFile (Var f: File; pathname: String): Boolean;
(* Return true if able to open an existing file *)
Function  Z_MakeFile (Var f: File; pathname: String): Boolean;
(* Return true if able to create a file *)
Procedure Z_CloseFile (Var f: File);
(* Closes a file and ignores errors *)
Function  Z_SeekFile (Var f: File; fpos: LongInt): Boolean;
(* Find a byte position within a file *)
Function  Z_WriteFile (Var f: File; Var buff; bytes: Word): Boolean;
(* Read a specified number of bytes from a file *)
Function  Z_ReadFile (Var f: File; Var buff; btoread: Word; Var bread: Word): Boolean;
(* Search for a named file *)
Function  Z_FindFile (pathname: String; Var Name: String; Var Size, Time: LongInt): Boolean;
(* Set time and date of a file *)
Procedure Z_SetFTime (Var f: File; Time: LongInt);

Implementation

Function Z_OpenFile (Var f: File; pathname: String): Boolean;
Begin {$I-}
  Assign (f, pathname);
  Reset (f, 1);
  Z_OpenFile := (IOResult = 0)
End; {$I+}

Function Z_MakeFile (Var f: File; pathname: String): Boolean;
Begin {$I-}
  Assign (f, pathname);
  Rewrite (f, 1);
  Z_MakeFile := (IOResult = 0)
End; {$I+}

Procedure Z_CloseFile (Var f: File);
Begin {$I-}
  Close (f);
  If (IOResult <> 0) Then
    { ignore this error }
End; {$I+}

Function Z_SeekFile (Var f: File; fpos: LongInt): Boolean;
Begin {$I-}
  Seek (f, fpos);
  Z_SeekFile := (IOResult = 0)
End; {$I+}

Function Z_WriteFile (Var f: File; Var buff; bytes: Word): Boolean;
Begin {$I-}
  BlockWrite (f, buff, bytes);
  Z_WriteFile := (IOResult = 0)
End; {$I+}

Function Z_ReadFile (Var f: File; Var buff; btoread: Word; Var bread: Word): Boolean;
Begin {$I-}
  BlockRead (f, buff, btoread, bread);
  Z_ReadFile := (IOResult = 0)
End; {$I+}

Function Z_FindFile (pathname: String; Var Name: String; Var Size, Time: LongInt): Boolean;
Var
  sr: SearchRec;
Begin {$I-}
  FindFirst (pathname, Archive, sr);
  If (DosError <> 0) Or (IOResult <> 0) Then
  Begin
    Z_FindFile := False;
    Exit
  End;
  Name := sr. Name;
  Size := sr. Size;
  Time := sr. Time;
  Z_FindFile := True
End; {$I+}

Procedure Z_SetFTime (Var f: File; Time: LongInt);
Begin {$I-}
  SetFTime (f, Time);
  If (IOResult <> 0) Then
    {null}
End; {$I+}

End.
