(*
**  UnDial.Inc (FrontDoor)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  NODIAL.FD format for FrontDoor 2.00+
**
**  Last revision:  91-10-02
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)

CONST
  MAXUNDIAL   = 200;                (* Maximum number of undialable systems *)
  DIALTROUBLE = 1;                                       (* Got one failure *)
  DIALWORSE   = 2;                                      (* Got two failures *)
  DIALNOMORE  = 3;                        (* Got three failures, undialable *)

(*
**  When FrontDoor reaches the maximum number of resend retries for a system
**  during an event (session handshake failures, bad sends, etc.) it bumps
**  the 'badness' counter one. Once it reaches three (i.e. FD has reached the
**  resend limit in three separate events), the system is flagged as 'hard'
**  undialable and FD will no longer attempt to call that system.
*)

TYPE
  NoDialRec   = RECORD
    Zone,
    Net,
    Node,
    Point     : word;                       (* Address of undialable system *)
    PhoneCrc  : longint;                  (* CRC-32 of raw telephone number *)
    Grade     : word;                       (* How undialable the system is *)
  End;

(* end of file "UnDial.Inc" *)
