Unit TSRZmodem;{Ver .93 Beta}

Interface

Uses Crt, Dos, TPZasync, TPZVideo, TPZFiles, TPZunix, TPZcrc;

Function Zmodem_Receive(path: String; comport: Word; baudrate: Longint): BOOLEAN;
Function Zmodem_Send(pathname: String; lastfile: BOOLEAN; comport: Word; baudrate: Longint): BOOLEAN;

Implementation

Const
   TPZVER = 'TSR [Zmodem] .93 Beta';
   ZBUFSIZE = 1024;
   zport: Word = 1;
   zbaud: Longint = 0;

Type
   hdrtype = ARRAY[0..3] OF Byte;
   buftype = ARRAY[0..1023] OF Byte;

Const
   ZPAD = 42;  { '*' }
   ZDLE = 24;  { ^X  }
   ZDLEE = 88;
   ZBIN = 65;  { 'A' }
   ZHEX = 66;  { 'B' }
   ZBIN32 = 67;{ 'C' }
   ZRQINIT = 0;
   ZRINIT = 1;
   ZSINIT = 2;
   ZACK = 3;
   ZFILE = 4;
   ZSKIP = 5;
   ZNAK = 6;
   ZABORT = 7;
   ZFIN = 8;
   ZRPOS = 9;
   ZDATA = 10;
   ZEOF = 11;
   ZFERR = 12;
   ZCRC = 13;
   ZCHALLENGE = 14;
   ZCOMPL = 15;
   ZCAN = 16;
   ZFREECNT = 17;
   ZCOMMAND = 18;
   ZSTDERR = 19;
   ZCRCE = 104; { 'h' }
   ZCRCG = 105; { 'i' }
   ZCRCQ = 106; { 'j' }
   ZCRCW = 107; { 'k' }
   ZRUB0 = 108; { 'l' }
   ZRUB1 = 109; { 'm' }
   ZOK = 0;
   ZERROR = -1;
   ZTIMEOUT = -2;
   RCDO = -3;
   FUBAR = -4;
   GOTOR = 256;
   GOTCRCE = 360; { 'h' Or 256 }
   GOTCRCG = 361; { 'i' "   "  }
   GOTCRCQ = 362; { 'j' "   "  }
   GOTCRCW = 363; { 'k' "   "  }
   GOTCAN = 272;  { CAN Or  "  }

{ xmodem paramaters }
Const
   ENQ = 5;
   CAN = 24;
   XOFF = 19;
   XON = 17;
   SOH = 1;
   STX = 2;
   EOT = 4;
   ACK = 6;
   NAK = 21;
   CPMEOF = 26;

{ Byte positions }
Const
   ZF0 = 3;
   ZF1 = 2;
   ZF2 = 1;
   ZF3 = 0;
   ZP0 = 0;
   ZP1 = 1;
   ZP2 = 2;
   ZP3 = 3;

{ bit masks For ZRINIT }
Const
   CANFDX = 1;    { can handle full-duplex          (yes For PC's)}
   CANOVIO = 2;   { can overlay disk And serial I/O (ditto)       }
   CANBRK = 4;    { can send a break - True but superfluous       }
   CANCRY = 8;    { can encrypt/decrypt - Not defined yet         }
   CANLZW = 16;   { can LZ compress - Not defined yet             }
   CANFC32 = 32;  { can use 32 bit crc frame checks - True        }
   ESCALL = 64;   { escapes all control chars. Not implemented    }
   ESC8 = 128;    { escapes the 8th bit. Not implemented          }

{ bit masks For ZSINIT }
Const
   TESCCTL = 64;
   TESC8 = 128;

{ paramaters For ZFILE }
Const
{ ZF0 }
   ZCBIN = 1;
   ZCNL = 2;
   ZCRESUM = 3;
{ ZF1 }
   ZMNEW = 1;   {I haven't implemented these as of yet - most are}
   ZMCRC = 2;   {superfluous on a BBS - Would be nice from a comm}
   ZMAPND = 3;  {programs' point of view however                 }
   ZMCLOB = 4;
   ZMSPARS = 5;
   ZMDIFF = 6;
   ZMPROT = 7;
{ ZF2 }
   ZTLZW = 1;   {encryption, compression And funny File handling }
   ZTCRYPT = 2; {flags - My docs (03/88) from OMEN say these have}
   ZTRLE = 3;   {not been defined yet                            }
{ ZF3 }
   ZCACK1 = 1;  {God only knows...                               }

VAR
   rxpos: Longint; {file position received from Z_GetHeader}
   rxhdr: hdrtype;    {receive header Var}
   rxtimeout,
   rxtype,
   rxframeind: Integer;
   attn: buftype;
   secbuf: buftype;
   fname: String;
   fmode: Integer;
   ftime,
   fsize: Longint;
   usecrc32: BOOLEAN;
   zcps, zerrors: Word;
   txpos: Longint;
   txhdr: hdrtype;
   ztime: Longint;

Const
   lastsent: Byte = 0;

Function Z_SetTimer: Longint;
VAR
   l: Longint;
   h,m,s,x: Word;
Begin
   Gettime(h,m,s,x);
   l := Longint(h) * 3600;
   l := l + Longint(m) * 60;
   l := l + Longint(s);
   Z_SetTimer := l
End;

Function Z_FileCRC32(VAR f: File): Longint;
VAR
   fbuf: buftype;
   crc: Longint;
   bread, n: Integer;
Begin {$I-}
   crc := $FFFFFFFF;
   Seek(f,0);
   If (Ioresult <> 0) Then
      {null};
   REPEAT
     Blockread(f,fbuf,ZBUFSIZE,bread);
     For n := 0 To (bread - 1) Do
       crc := UpdC32(fbuf[n],crc)
   Until (bread < ZBUFSIZE) Or (Ioresult <> 0);
   Seek(f,0);
   If (Ioresult <> 0) Then
      {null};
   Z_FileCRC32 := crc
End; {$I+}

Function Z_GetByte(tenths: Integer): Integer;
(* Reads a Byte from the modem - Returns RCDO If *)
(* no carrier, Or ZTIMEOUT If nothing received   *)
(* within 'tenths' of a second.                  *)
VAR
   n: Integer;
Begin
   REPEAT
      If (Not Z_Carrier) Then
      Begin
         Z_GetByte := RCDO; { nobody To talk To }
         Exit
      End;
      If (Z_CharAvail) Then
      Begin
         Z_GetByte := Z_ReceiveByte; { got character }
         Exit
      End;
      Dec(tenths);              { Dec. the count    }
      Delay(100)                { pause 1/10th sec. }
   Until (tenths <= 0);
   Z_GetByte := ZTIMEOUT        { timed out }
End;

Function Z_qk_read: Integer;
(* Just like Z_GetByte, but timeout value is In *)
(* global Var rxtimeout.                        *)
Begin
   Z_qk_read := Z_GetByte(rxtimeout)
End;


Function Z_TimedRead: Integer;
(* A Z_qk_read, that strips parity And *)
(* ignores XON/XOFF characters.        *)
VAR
   done: BOOLEAN;
   c: Integer;
Begin
   done := FALSE;
   REPEAT
      c := Z_qk_read AND $FF7F                { strip parity }
   Until (c < 0) Or (Not (Lo(c) In [17,19])); { wait For other than XON/XOFF }
   Z_TimedRead := c
End;

Procedure Z_SendCan;
(* Send a zmodem CANcel sequence To the other guy *)
(* 8 CANs And 8 backspaces                        *)
VAR
   n: Byte;
Begin
   Z_ClearOutbound; { spare them the junk }
   For n := 1 To 8 Do
   Begin
      Z_SendByte(CAN);
      Delay(100)     { the pause seems To make reception of the sequence }
   End;              { more reliable                                     }
   For n := 1 To 10 Do
      Z_SendByte(8)
End;

Procedure Z_PutString(VAR p: buftype);
(* Outputs an ASCII-Z Type String (null terminated) *)
(* Processes meta characters 221 (send break) And   *)
(* 222 (2 second Delay).                            *)
VAR
   n: Integer;
Begin
   n := 0;
   While (n < ZBUFSIZE) AND (p[n] <> 0) Do
   Begin
      CASE p[n] OF
         221 : Z_SendBreak;
         222 : Delay(2000)
         Else
            Z_SendByte(p[n])
      End;
      Inc(n)
   End
End;

Procedure Z_PutHex(b: Byte);
(* Output a Byte as two hex digits (In ASCII) *)
(* Uses lower Case To avoid confusion With    *)
(* escaped control characters.                *)
Const
   hex: ARRAY[0..15] OF CHAR = '0123456789abcdef';
Begin
   Z_SendByte(Ord(hex[b Shr 4]));  { high nybble }
   Z_SendByte(Ord(hex[b AND $0F])) { low nybble  }
End;

Procedure Z_SendHexHeader(htype: Byte; VAR hdr: hdrtype);
(* Sends a zmodem hex Type header *)
VAR
   crc: Word;
   n, i: Integer;
Begin
   Z_SendByte(ZPAD);                  { '*' }
   Z_SendByte(ZPAD);                  { '*' }
   Z_SendByte(ZDLE);                  { 24  }
   Z_SendByte(ZHEX);                  { 'B' }
   Z_PutHex(htype);
   crc := UpdCrc(htype,0);
   For n := 0 To 3 Do
   Begin
      Z_PutHex(hdr[n]);
      crc := UpdCrc(hdr[n],crc)
   End;
   crc := UpdCrc(0,crc);
   crc := UpdCrc(0,crc);
   Z_PutHex(Lo(crc Shr 8));
   Z_PutHex(Lo(crc));
   Z_SendByte(13);                    { make it readable To the other End }
   Z_SendByte(10);                    { just In Case                      }
   If (htype <> ZFIN) AND (htype <> ZACK) Then
      Z_SendByte(17);                 { Prophylactic XON To assure flow   }
   If (Not Z_Carrier) Then
      Z_ClearOutbound
End;

Function Z_PullLongFromHeader(VAR hdr: hdrtype): Longint;
(* Stuffs a Longint into a header variable - N.B. - bytes are REVERSED! *)
VAR
   l: Longint;
Begin
   l := hdr[ZP3];               { hard coded For efficiency }
   l := (l Shl 8) Or hdr[ZP2];
   l := (l Shl 8) Or hdr[ZP1];
   l := (l Shl 8) Or hdr[ZP0];
   Z_PullLongFromHeader := l
End;

Procedure Z_PutLongIntoHeader(l: Longint);
(* Reverse of above *)
Begin
   txhdr[ZP0] := Byte(l);
   txhdr[ZP1] := Byte(l Shr 8);
   txhdr[ZP2] := Byte(l Shr 16);
   txhdr[ZP3] := Byte(l Shr 24)
End;

Function Z_GetZDL: Integer;
(* Gets a Byte And processes For ZMODEM escaping Or CANcel sequence *)
VAR
   c, d: Integer;
Begin
   If (Not Z_Carrier) Then
   Begin
      Z_GetZDL := RCDO;
      Exit
   End;
   c := Z_qk_read;
   If (c <> ZDLE) Then
   Begin
      Z_GetZDL := c;
      Exit
   End;   {got ZDLE Or 1st CAN}
   c := Z_qk_read;
   If (c = CAN) Then  {got 2nd CAN}
   Begin
      c := Z_qk_read;
      If (c = CAN) Then {got 3rd CAN}
      Begin
         c := Z_qk_read;
         If (c = CAN) Then {got 4th CAN}
            c := Z_qk_read
      End
   End;
   { Flags Set In high Byte }
   CASE c OF
      CAN: Z_GetZDL := GOTCAN; {got 5th CAN}
      ZCRCE,                   {got a frame End marker}
      ZCRCG,
      ZCRCQ,
      ZCRCW: Z_GetZDL := (c Or GOTOR);
      ZRUB0: Z_GetZDL := $007F; {got an ASCII Delete}
      ZRUB1: Z_GetZDL := $00FF  {any parity         }
      Else
      Begin
         If (c < 0) Then
            Z_GetZDL := c
         Else If ((c AND $60) = $40) Then  {make sure it was a valid escape}
            Z_GetZDL := c Xor $40
         Else
            Z_GetZDL := ZERROR
      End
   End
End;

Function Z_GetHex: Integer;
(* Get a Byte that has been received as two ASCII hex digits *)
VAR
   c, n: Integer;
Begin
   n := Z_TimedRead;
   If (n < 0) Then
   Begin
      Z_GetHex := n;
      Exit
   End;
   n := n - $30;                     {build the high nybble}
   If (n > 9) Then
      n := n - 39;
   If (n AND $FFF0 <> 0) Then
   Begin
      Z_GetHex := ZERROR;
      Exit
   End;
   c := Z_TimedRead;
   If (c < 0) Then
   Begin
      Z_GetHex := c;
      Exit
   End;
   c := c - $30;                     {now the low nybble}
   If (c > 9) Then
      c := c - 39;
   If (c AND $FFF0 <> 0) Then
   Begin
      Z_GetHex := ZERROR;
      Exit
   End;
   Z_GetHex := (n Shl 4) Or c        {Insert tab 'A' In slot 'B'...}
End;

Function Z_GetHexHeader(VAR hdr: hdrtype): Integer;
(* Receives a zmodem hex Type header *)
VAR
   crc: Word;
   c, n: Integer;
Begin
   c := Z_GetHex;
   If (c < 0) Then
   Begin
      Z_GetHexHeader := c;
      Exit
   End;
   rxtype := c;                        {get the Type of header}
   crc := UpdCrc(rxtype,0);
   For n := 0 To 3 Do                  {get the 4 bytes}
   Begin
      c := Z_GetHex;
      If (c < 0) Then
      Begin
         Z_GetHexHeader := c;
         Exit
      End;
      hdr[n] := Lo(c);
      crc := UpdCrc(Lo(c),crc)
   End;
   c := Z_GetHex;
   If (c < 0) Then
   Begin
      Z_GetHexHeader := c;
      Exit
   End;
   crc := UpdCrc(Lo(c),crc);
   c := Z_GetHex;
   If (c < 0) Then
   Begin
      Z_GetHexHeader := c;
      Exit
   End;
   crc := UpdCrc(Lo(c),crc);             {check the CRC}
   If (crc <> 0) Then
   Begin
      Inc(zerrors);
      Z_Errors(zerrors);
      Z_GetHexHeader := ZERROR;
      Exit
   End;
   If (Z_GetByte(1) = 13) Then           {throw away CR/LF}
      c := Z_GetByte(1);
   Z_GetHexHeader := rxtype
End;


Function Z_GetBinaryHeader(VAR hdr: hdrtype): Integer;
(* Same as above, but binary With 16 bit CRC *)
VAR
   crc: Word;
   c, n: Integer;
Begin
   c := Z_GetZDL;
   If (c < 0) Then
   Begin
      Z_GetBinaryHeader := c;
      Exit
   End;
   rxtype := c;
   crc := UpdCrc(rxtype,0);
   For n := 0 To 3 Do
   Begin
      c := Z_GetZDL;
      If (Hi(c) <> 0) Then
      Begin
         Z_GetBinaryHeader := c;
         Exit
      End;
      hdr[n] := Lo(c);
      crc := UpdCrc(Lo(c),crc)
   End;
   c := Z_GetZDL;
   If (Hi(c) <> 0) Then
   Begin
      Z_GetBinaryHeader := c;
      Exit
   End;
   crc := UpdCrc(Lo(c),crc);
   c := Z_GetZDL;
   If (Hi(c) <> 0) Then
   Begin
      Z_GetBinaryHeader := c;
      Exit
   End;
   crc := UpdCrc(Lo(c),crc);
   If (crc <> 0) Then
   Begin
      Inc(zerrors);
      Z_Errors(zerrors);
      Exit
   End;
   Z_GetBinaryHeader := rxtype
End;


Function Z_GetBinaryHead32(VAR hdr: hdrtype): Integer;
(* Same as above but With 32 bit CRC *)
VAR
   crc: Longint;
   c, n: Integer;
Begin
   c := Z_GetZDL;
   If (c < 0) Then
   Begin
      Z_GetBinaryHead32 := c;
      Exit
   End;
   rxtype := c;
   crc := UpdC32(rxtype,$FFFFFFFF);
   For n := 0 To 3 Do
   Begin
      c := Z_GetZDL;
      If (Hi(c) <> 0) Then
      Begin
         Z_GetBinaryHead32 := c;
         Exit
      End;
      hdr[n] := Lo(c);
      crc := UpdC32(Lo(c),crc)
   End;
   For n := 0 To 3 Do
   Begin
      c := Z_GetZDL;
      If (Hi(c) <> 0) Then
      Begin
         Z_GetBinaryHead32 := c;
         Exit
      End;
      crc := UpdC32(Lo(c),crc)
   End;
   If (crc <> $DEBB20E3) Then   {this is the polynomial value}
   Begin
      Inc(zerrors);
      Z_Errors(zerrors);
      Z_GetBinaryHead32 := ZERROR;
      Exit
   End;
   Z_GetBinaryHead32 := rxtype
End;

Function Z_GetHeader(VAR hdr: hdrtype): Integer;
(* Use this routine To get a header - it will figure out  *)
(* what Type it is getting (hex, bin16 Or bin32) And call *)
(* the appropriate routine.                               *)
LABEL
   gotcan, again, agn2, splat, done;  {sorry, but it's actually eisier To}
VAR                                   {follow, And lots more efficient   }
   c, n, cancount: Integer;           {this way...                       }
Begin
   n := zbaud * 2;                    {A guess at the # of garbage characters}
   cancount := 5;                     {to expect.                            }
   usecrc32 := FALSE;                 {assume 16 bit Until proven otherwise  }
again:
   If (Keypressed) Then               {check For operator panic}
      If (Readkey = #27) Then         {in the form of ESCape   }
      Begin
         Z_SendCan;                              {tell the other End,   }
         Z_message('Cancelled from keyboard');  {the operator,         }
         Z_GetHeader := ZCAN;                   {and the rest of the   }
         Exit                                   {routines To forget it.}
      End;
   rxframeind := 0;
   rxtype := 0;
   c := Z_TimedRead;
   CASE c OF
      ZPAD: {we want this! - all headers Begin With '*'.} ;
      RCDO,
      ZTIMEOUT: Goto done;
      CAN: Begin
gotcan:
              Dec(cancount);
              If (cancount < 0) Then
              Begin
                 c := ZCAN;
                 Goto done
              End;
              c := Z_GetByte(1);
              CASE c OF
                 ZTIMEOUT: Goto again;
                 ZCRCW: Begin
                           c := ZERROR;
                           Goto done
                        End;
                 RCDO: Goto done;
                 CAN: Begin
                         Dec(cancount);
                         If (cancount < 0) Then
                         Begin
                            c := ZCAN;
                            Goto done
                         End;
                         Goto again
                      End
                 Else
                    {fallthru}
              End {case}
           End {can}
      Else
agn2: Begin
         Dec(n);
         If (n < 0) Then
         Begin
            Inc(zerrors);
            Z_Errors(zerrors);
            Z_message('Header is FUBAR');
            Z_GetHeader := ZERROR;
            Exit
         End;
         If (c <> CAN) Then
            cancount := 5;
         Goto again
      End
   End;           {only falls thru If ZPAD - anything Else is trash}
   cancount := 5;
splat:
   c := Z_TimedRead;
   CASE c OF
      ZDLE: {this is what we want!} ;
      ZPAD: Goto splat;   {junk Or second '*' of a hex header}
      RCDO,
      ZTIMEOUT: Goto done
      Else
         Goto agn2
   End; {only falls thru If ZDLE}
   c := Z_TimedRead;
   CASE c OF
      ZBIN32: Begin
                 rxframeind := ZBIN32;        {using 32 bit CRC}
                 c := Z_GetBinaryHead32(hdr)
              End;
      ZBIN: Begin
               rxframeind := ZBIN;            {bin With 16 bit CRC}
               c := Z_GetBinaryHeader(hdr)
            End;
      ZHEX: Begin
               rxframeind := ZHEX;            {hex}
               c := Z_GetHexHeader(hdr)
            End;
      CAN: Goto gotcan;
      RCDO,
      ZTIMEOUT: Goto done
      Else
         Goto agn2
   End; {only falls thru If we got ZBIN, ZBIN32 Or ZHEX}
   rxpos := Z_PullLongFromHeader(hdr);        {set rxpos just In Case this}
done:                                         {header has File position   }
   Z_GetHeader := c                           {info (i.e.: ZRPOS, etc.   )}
End;

(***************************************************)
(* RECEIVE File ROUTINES                           *)
(***************************************************)

Const
   ZATTNLEN = 32;  {max Length of attention String}
   lastwritten: Byte = 0;
VAR
   t: Longint;
   rzbatch: BOOLEAN;
   outfile: File;     {this is the File}
   tryzhdrtype: Byte;
   rxcount: Integer;
   filestart: Longint;
   isbinary, eofseen: BOOLEAN;
   zconv: Byte;
   zrxpath: String;

Function RZ_ReceiveDa32(VAR buf: buftype; blength: Integer): Integer;
(* Get a 32 bit CRC data block *)
LABEL
   crcfoo;
VAR
   c, d, n: Integer;
   crc: Longint;
   done: Boolean;
Begin
   usecrc32 := True;
   crc := $FFFFFFFF;
   rxcount := 0;
   done := FALSE;
   REPEAT
      c := Z_GetZDL;
      If (Hi(c) <> 0) Then
      Begin
crcfoo:  CASE c OF
            GOTCRCE,
            GOTCRCG,
            GOTCRCQ,
            GOTCRCW: Begin
                        d := c;
                        crc := UpdC32(Lo(c),crc);
                        For n := 0 To 3 Do
                        Begin
                           c := Z_GetZDL;
                           If (Hi(c) <> 0) Then
                              Goto crcfoo;
                           crc := UpdC32(Lo(c),crc)
                        End;
                        If (crc <> $DEBB20E3) Then
                        Begin
                           Inc(zerrors);
                           Z_Errors(zerrors);
                           RZ_ReceiveDa32 := ZERROR
                        End
                        Else
                           RZ_ReceiveDa32 := d;
                        DONE := True
                     End;
            GOTCAN: Begin
                       RZ_ReceiveDa32 := ZCAN;
                       DONE := True
                    End;
            ZTIMEOUT: Begin
                         RZ_ReceiveDa32 := c;
                         DONE := True
                      End;
            RCDO: Begin
                     RZ_ReceiveDa32 := c;
                     done := True
                  End
            Else
            Begin
               Z_message('Debris');
               Z_ClearInbound;
               RZ_ReceiveDa32 := c;
               DONE := True
            End
         End
      End;
      If (Not done) Then
      Begin
         Dec(blength);
         If (blength < 0) Then
         Begin
            Z_message('Long packet');
            RZ_ReceiveDa32 := ZERROR;
            done := True
         End;
         buf[INTEGER(rxcount)] := Lo(c);
         Inc(rxcount);
         crc := UpdC32(Lo(c),crc)
      End
   Until done
End;

Function RZ_ReceiveData(VAR buf: buftype; blength: Integer): Integer;
(* get a 16 bit CRC data block *)
LABEL
   crcfoo;
VAR
   c, d: Integer;
   crc: Word;
   done: Boolean;
Begin
   If (rxframeind = ZBIN32) Then
   Begin
      Z_ShowCheck(True);
      RZ_ReceiveData := RZ_ReceiveDa32(buf,blength);
      Exit
   End;
   Z_ShowCheck(FALSE);
   crc := 0;
   rxcount := 0;
   done := FALSE;
   REPEAT
      c := Z_GetZDL;
      If (Hi(c) <> 0) Then
      Begin
crcfoo:  CASE c OF
            GOTCRCE,
            GOTCRCG,
            GOTCRCQ,
            GOTCRCW: Begin
                        d := c;
                        crc := UpdCrc(Lo(c),crc);
                        c := Z_GetZDL;
                        If (Hi(c) <> 0) Then
                           Goto crcfoo;
                        crc := UpdCrc(Lo(c),crc);
                        c := Z_GetZDL;
                        If (Hi(c) <> 0) Then
                           Goto crcfoo;
                        crc := UpdCrc(Lo(c),crc);
                        If (crc <> 0) Then
                        Begin
                           Inc(zerrors);
                           Z_Errors(zerrors);
                           RZ_ReceiveData := ZERROR;
                           done := True
                        End;
                        RZ_ReceiveData := d;
                        DONE := True
                     End;
            GOTCAN: Begin
                       Z_Message('Got CANned');
                       RZ_ReceiveData := ZCAN;
                       DONE := True
                    End;
            ZTIMEOUT: Begin
                         RZ_ReceiveData := c;
                         DONE := True
                      End;
            RCDO: Begin
                     Z_Message('Lost carrier');
                     RZ_ReceiveData := c;
                     done := True
                  End
            Else
            Begin
               Z_message('Debris');
               Z_ClearInbound;
               RZ_ReceiveData := c;
               DONE := True
            End
         End
      End;
      If (Not done) Then
      Begin
         Dec(blength);
         If (blength < 0) Then
         Begin
            Z_message('Long packet');
            RZ_ReceiveData := ZERROR;
            done := True
         End;
         buf[INTEGER(rxcount)] := Lo(c);
         Inc(rxcount);
         crc := UpdCrc(Lo(c),crc)
      End
   Until done
End;

Procedure RZ_AckBibi;
(* ACKnowledge the other ends request To terminate cleanly *)
VAR
   n: Integer;
Begin
   Z_PutLongIntoHeader(rxpos);
   n := 4;
   Z_ClearInbound;
   REPEAT
      Z_SendHexHeader(ZFIN,txhdr);
      CASE Z_GetByte(20) OF
         ZTIMEOUT,
         RCDO: Exit;
         79: Begin
                If (Z_GetByte(10) = 79) Then
                   {null};
                Z_ClearInbound;
                Exit
             End
         Else
            Z_ClearInbound;
            Dec(n)
      End
   Until (n <= 0)
End;

Function RZ_InitReceiver: Integer;
LABEL
   again;
VAR
   c, n, errors: Integer;
Begin
   Fillchar(attn,Sizeof(attn),0);
   zerrors := 0;
   For n := 10 Downto 0 Do
   Begin
      If (Not Z_Carrier) Then
      Begin
         Z_Message('Lost carrier');
         RZ_InitReceiver := ZERROR;
         Exit
      End;
      Z_PutLongIntoHeader(Longint(0));
      txhdr[ZF0] := CANFDX Or CANOVIO Or CANFC32 Or CANBRK; {Full dplx, overlay I/O And CRC32}
      Z_SendHexHeader(tryzhdrtype,txhdr);
      If (tryzhdrtype = ZSKIP) Then
         tryzhdrtype := ZRINIT;
again:
         c := Z_GetHeader(rxhdr);
         Z_Frame(c);
         CASE c OF
         ZFILE: Begin
                   zconv := rxhdr[ZF0];
                   tryzhdrtype := ZRINIT;
                   c := RZ_ReceiveData(secbuf,ZBUFSIZE);
                   Z_Frame(c);
                   If (c = GOTCRCW) Then
                   Begin
                      RZ_InitReceiver := ZFILE;
                      Exit
                   End;
                   Z_SendHexHeader(ZNAK,txhdr);
                   Goto again
                End;
         ZSINIT: Begin
                   c := RZ_ReceiveData(attn,ZBUFSIZE);
                   Z_Frame(c);
                   If (c = GOTCRCW) Then
                       Z_SendHexHeader(ZACK,txhdr)
                    Else
                       Z_SendHexHeader(ZNAK,txhdr);
                    Goto again
                 End;
         ZFREECNT: Begin
                      Z_PutLongIntoHeader(Diskfree(0));
                      Z_SendHexHeader(ZACK,txhdr);
                      Goto again
                   End;
         ZCOMMAND: Begin
                      c := RZ_ReceiveData(secbuf,ZBUFSIZE);
                      Z_Frame(c);
                      If (c = GOTCRCW) Then
                      Begin
                         Z_PutLongIntoHeader(Longint(0));
                         REPEAT
                            Z_SendHexHeader(ZCOMPL,txhdr);
                            Inc(errors)
                         Until (errors > 10) Or (Z_GetHeader(rxhdr) = ZFIN);
                         RZ_AckBibi;
                         RZ_InitReceiver := ZCOMPL;
                         Exit
                      End;
                      Z_SendHexHeader(ZNAK,txhdr);
                      Goto again
                   End;
         ZCOMPL,
         ZFIN: Begin
                  RZ_InitReceiver := ZCOMPL;
                  Exit
               End;
         ZCAN,
         RCDO: Begin
                  RZ_InitReceiver := c;
                  Exit
               End
      End
   End;
   Z_message('Timeout');
   RZ_InitReceiver := ZERROR
End;

Function RZ_GetHeader: Integer;
VAR
   e, p, n, i: Integer;
   multiplier: Longint;
   s: String;
   ttime, tsize: Longint;
   tname: String;
Begin
   isbinary := True;    {Force the issue!}
   fsize := Longint(0);
   p := 0;
   s := '';
   While (p < 255) AND (secbuf[p] <> 0) Do
   Begin
      s := s + Upcase(Chr(secbuf[p]));
      Inc(p)
   End;
   Inc(p);
   (* get rid of drive & path specifiers *)
   While (Pos(':',s) > 0) Do
      Delete(s,1,Pos(':',s));
   While (Pos('\',s) > 0) Do
      Delete(s,1,Pos('\',s));
   fname := s;

(**** done With name ****)

   fsize := Longint(0);
   While (p < ZBUFSIZE) AND (secbuf[p] <> $20) AND (secbuf[p] <> 0) Do
   Begin
      fsize := (fsize *10) + Ord(secbuf[p]) - $30;
      Inc(p)
   End;
   Inc(p);

(**** done With size ****)

   s := '';
   While (p < ZBUFSIZE) AND (secbuf[p] In [$30..$37]) Do
   Begin
      s := s + Chr(secbuf[p]);
      Inc(p)
   End;
   Inc(p);
   ftime := Z_FromUnixDate(s);

(**** done With time ****)

   If (Z_FindFile(zrxpath+fname,tname,tsize,ttime)) Then
   Begin
      If (zconv = ZCRESUM) AND (fsize > tsize) Then
      Begin
         filestart := tsize;
         If (Not Z_OpenFile(outfile,zrxpath + fname)) Then
         Begin
            Z_message('Error opening '+fname);
            RZ_GetHeader := ZERROR;
            Exit
         End;
         If (Not Z_SeekFile(outfile,tsize)) Then
         Begin
            Z_Message('Error positioning File');
            RZ_GetHeader := ZERROR;
            Exit
         End;
         Z_Message('Recovering')
      End
      Else
      Begin
         Z_ShowName(fname);
         Z_Message('File is already complete');
         RZ_GetHeader := ZSKIP;
         Exit
      End
   End
   Else
   Begin
      filestart := 0;
      If (Not Z_MakeFile(outfile,zrxpath + fname)) Then
      Begin
         Z_message('Unable To create '+fname);
         RZ_GetHeader := ZERROR;
         Exit
      End
   End;
   Z_ShowName(fname);
   Z_ShowSize(fsize);
   Z_ShowTransferTime(fsize,zbaud);
   RZ_GetHeader := ZOK
End;

Function RZ_SaveToDisk(VAR rxbytes: Longint): Integer;
Begin
   If (Keypressed) Then
      If (Readkey = #27) Then
      Begin
         Z_message('Aborted from keyboard');
         Z_SendCan;
         RZ_SaveToDisk := ZERROR;
         Exit
      End;
   If (Not Z_WriteFile(outfile,secbuf,rxcount)) Then
   Begin
      Z_Message('Disk Write error');
      RZ_SaveToDisk := ZERROR
   End
   Else
      RZ_SaveToDisk := ZOK;
   rxbytes := rxbytes + rxcount
End;

Function RZ_ReceiveFile: Integer;
LABEL
   err, nxthdr, moredata;
VAR
   c, n: Integer;
   rxbytes: Longint;
   Sptr: String;
   done: BOOLEAN;
Begin
   zerrors := 0;
   done := FALSE;
   eofseen := FALSE;
   c := RZ_GetHeader;
   If (c <> ZOK) Then
   Begin
      If (c = ZSKIP) Then
         tryzhdrtype := ZSKIP;
      RZ_ReceiveFile := c;
      Exit
   End;
   c := ZOK;
   n := 10;
   rxbytes := filestart;
   rxpos := filestart;
   ztime := Z_SetTimer;
   zcps := 0;
   REPEAT
      Z_PutLongIntoHeader(rxbytes);
      Z_SendHexHeader(ZRPOS,txhdr);
nxthdr:
      c := Z_GetHeader(rxhdr);
      Z_Frame(c);
      CASE c OF
         ZDATA: Begin
                   If (rxpos <> rxbytes) Then
                   Begin
                      Dec(n);
                      Inc(zerrors);
                      Z_Errors(zerrors);
                      If (n < 0) Then
                         Goto err;
                      Z_message('Bad position');
                      Z_PutString(attn)
                   End
                   Else
                   Begin
moredata:
                      c := RZ_ReceiveData(secbuf,ZBUFSIZE);
                      Z_Frame(c);
                      CASE c OF
                         ZCAN,
                         RCDO: Goto err;
                         ZERROR: Begin
                                    Dec(n);
                                    Inc(zerrors);
                                    Z_Errors(zerrors);
                                    If (n < 0) Then
                                        Goto err;
                                    Z_PutString(attn)
                                 End;
                         ZTIMEOUT: Begin
                                      Dec(n);
                                      If (n < 0) Then
                                         Goto err
                                   End;
                         GOTCRCW: Begin
                                     n := 10;
                                     c := RZ_SaveToDisk(rxbytes);
                                     If (c <> ZOK) Then
                                     Begin
                                        RZ_ReceiveFile := c;
                                        Exit
                                     End;
                                     Z_ShowLoc(rxbytes);
                                     Z_PutLongIntoHeader(rxbytes);
                                     Z_SendHexHeader(ZACK,txhdr);
                                     Goto nxthdr
                                  End;
                         GOTCRCQ: Begin
                                     n := 10;
                                     c := RZ_SaveToDisk(rxbytes);
                                     If (c <> ZOK) Then
                                     Begin
                                        RZ_ReceiveFile := c;
                                        Exit
                                     End;
                                     Z_ShowLoc(rxbytes);
                                     Z_PutLongIntoHeader(rxbytes);
                                     Z_SendHexHeader(ZACK,txhdr);
                                     Goto moredata
                                  End;
                         GOTCRCG: Begin
                                     n := 10;
                                     c := RZ_SaveToDisk(rxbytes);
                                     If (c <> ZOK) Then
                                     Begin
                                        RZ_ReceiveFile := c;
                                        Exit
                                     End;
                                     Z_ShowLoc(rxbytes);
                                     Goto moredata
                                  End;
                         GOTCRCE: Begin
                                     n := 10;
                                     c := RZ_SaveToDisk(rxbytes);
                                     If (c <> ZOK) Then
                                     Begin
                                        RZ_ReceiveFile := c;
                                        Exit
                                     End;
                                     Z_ShowLoc(rxbytes);
                                     Goto nxthdr
                                  End
                      End {case}
                   End
                End; {case of ZDATA}
         ZNAK,
         ZTIMEOUT: Begin
                      Dec(n);
                      If (n < 0) Then
                         Goto err;
                      Z_ShowLoc(rxbytes)
                   End;
         ZFILE: Begin
                   c := RZ_ReceiveData(secbuf,ZBUFSIZE);
                   Z_Frame(c)
                End;
         ZEOF: If (rxpos = rxbytes) Then
               Begin
                  RZ_ReceiveFile := c;
                  Exit
               End
               Else
                  Goto nxthdr;
         ZERROR: Begin
                    Dec(n);
                    If (n < 0) Then
                       Goto err;
                    Z_ShowLoc(rxbytes);
                    Z_PutSTring(attn)
                 End
         Else
         Begin
            c := ZERROR;
            Goto err
         End
      End {case}
   Until (Not done);
err:
   RZ_ReceiveFile := ZERROR
End;

Function RZ_ReceiveBatch: Integer;
VAR
   s: String;
   c: Integer;
   done: BOOLEAN;
Begin
   Z_Message('Receiving...');
   done := FALSE;
   While (Not done) Do
   Begin
      If Not (Z_Carrier) Then
      Begin
         RZ_ReceiveBatch := ZERROR;
         Exit
      End;
      c := RZ_ReceiveFile;
      zcps := fsize Div (Z_SetTimer - ztime);
      Z_Frame(c);
      Z_SetFTime(outfile,ftime);
      Z_CloseFile(outfile);
      Str(zcps:4,s);
      Z_Message(s+' cps');
      CASE c OF
         ZEOF,
         ZSKIP: Begin
                   c := RZ_InitReceiver;
                   Z_Frame(c);
                   CASE c OF
                      ZFILE: {null};
                      ZCOMPL: Begin
                                 RZ_AckBibi;
                                 RZ_ReceiveBatch := ZOK;
                                 Exit
                              End;
                      Else
                      Begin
                         RZ_ReceiveBatch := ZERROR;
                         Exit
                      End
                   End
                End
         Else
         Begin
            RZ_ReceiveBatch := c;
            Exit
         End
      End {case}
   End {while}
End;


Function Zmodem_Receive(path: String; comport: Word; baudrate: Longint): BOOLEAN;
VAR
   i: Integer;
Begin
   zbaud := baudrate;
   zport := comport;
   Z_OpenWindow(TPZVER);
   Z_Message('Initializing...');
   If (Not Z_AsyncOn(comport,baudrate)) Then
   Begin
      Clrscr;
      Writeln('Unable To open:');
      Writeln('Port: ',comport);
      Writeln('Baud: ',baudrate);
      Delay(2000);
      Z_CloseWindow;
      Zmodem_Receive := FALSE;
      Exit
   End;
   zrxpath := path;
   If (zrxpath[Length(zrxpath)] <> '\') AND (zrxpath <> '') Then
      zrxpath := zrxpath + '\';
   rxtimeout := 100;
   tryzhdrtype := ZRINIT;
   i := RZ_InitReceiver;
   If (i = ZCOMPL) Or ((i = ZFILE) AND ((RZ_ReceiveBatch) = ZOK)) Then
   Begin
      Z_Message('Restoring async params');
      Z_AsyncOff;
      Z_CloseWindow;
      Zmodem_Receive := True
   End
   Else
   Begin
      Z_ClearOutbound;
      Z_Message('Sending CAN');
      Z_SendCan;
      Z_Message('Restoring async params');
      Z_AsyncOff;
      Z_CloseWindow;
      Zmodem_Receive := FALSE;
   End
End;


(*######### SEND ROUTINES #####################################*)



VAR
   infile: File;
   strtpos: Longint;
   rxbuflen: Integer;
   txbuf: buftype;
   blkred: Integer;


Procedure SZ_Z_SendByte(b: Byte);
Begin
   If ((b AND $7F) In [16,17,19,24]) Or (((b AND $7F) = 13) AND ((lastsent AND $7F) = 64)) Then
   Begin
      Z_SendByte(ZDLE);
      lastsent := (b Xor 64)
   End
   Else
      lastsent := b;
   Z_SendByte(lastsent)
End;

Procedure SZ_SendBinaryHead32(htype: Byte; VAR hdr: hdrtype);
VAR
   crc: Longint;
   n: Integer;
Begin
   Z_SendByte(ZPAD);
   Z_SendByte(ZDLE);
   Z_SendByte(ZBIN32);
   SZ_Z_SendByte(htype);
   crc := UpdC32(htype,$FFFFFFFF);
   For n := 0 To 3 Do
   Begin
      SZ_Z_SendByte(hdr[n]);
      crc := UpdC32(hdr[n],crc)
   End;
   crc := (Not crc);
   For n := 0 To 3 Do
   Begin
      SZ_Z_SendByte(Byte(crc));
      crc := (crc Shr 8)
   End;
   If (htype <> ZDATA) Then
      Delay(500)
End;

Procedure SZ_SendBinaryHeader(htype: Byte; VAR hdr: hdrtype);
VAR
   crc: Word;
   n: Integer;
Begin
   If (usecrc32) Then
   Begin
      SZ_SendBinaryHead32(htype,hdr);
      Exit
   End;
   Z_SendByte(ZPAD);
   Z_SendByte(ZDLE);
   Z_SendByte(ZBIN);
   SZ_Z_SendByte(htype);
   crc := UpdCrc(htype,0);
   For n := 0 To 3 Do
   Begin
      SZ_Z_SendByte(hdr[n]);
      crc := UpdCrc(hdr[n],crc)
   End;
   crc := UpdCrc(0,crc);
   crc := UpdCrc(0,crc);
   SZ_Z_SendByte(Lo(crc Shr 8));
   SZ_Z_SendByte(Lo(crc));
   If (htype <> ZDATA) Then
      Delay(500)
End;

Procedure SZ_SendDa32(VAR buf: buftype; blength: Integer; frameend: Byte);
VAR
   crc: Longint;
   t: Integer;
Begin
   crc := $FFFFFFFF;
   For t := 0 To (blength - 1) Do
   Begin
      SZ_Z_SendByte(buf[t]);
      crc := UpdC32(buf[t],crc)
   End;
   crc := UpdC32(frameend,crc);
   crc := (Not crc);
   Z_SendByte(ZDLE);
   Z_SendByte(frameend);
   For t := 0 To 3 Do
   Begin
      SZ_Z_SendByte(Byte(crc));
      crc := (crc Shr 8)
   End;
   Begin
      Z_SendByte(17);
      Delay(500)
   End
End;

Procedure SZ_SendData(VAR buf: buftype; blength: Integer; frameend: Byte);
VAR
   crc: Word;
   t: Integer;
Begin
   If (usecrc32) Then
   Begin
      SZ_SendDa32(buf,blength,frameend);
      Exit
   End;
   crc := 0;
   For t := 0 To (blength - 1) Do
   Begin
      SZ_Z_SendByte(buf[t]);
      crc := UpdCrc(buf[t],crc)
   End;
   crc := UpdCrc(frameend,crc);
   Z_SendByte(ZDLE);
   Z_SendByte(frameend);
   crc := UpdCrc(0,crc);
   crc := UpdCrc(0,crc);
   SZ_Z_SendByte(Lo(crc Shr 8));
   SZ_Z_SendByte(Lo(crc));
   If (frameend = ZCRCW) Then
   Begin
      Z_SendByte(17);
      Delay(500)
   End
End;


Procedure SZ_EndSend;
VAR
   done: BOOLEAN;
Begin
   done := FALSE;
   REPEAT
      Z_PutLongIntoHeader(txpos);
      SZ_SendBinaryHeader(ZFIN,txhdr);
      CASE Z_GetHeader(rxhdr) OF
         ZFIN: Begin
                  Z_SendByte(Ord('O'));
                  Z_SendByte(Ord('O'));
                  Delay(500);
                  Z_ClearOutbound;
                  Exit
               End;
         ZCAN,
         RCDO,
         ZFERR,
         ZTIMEOUT: Exit
      End {case}
   Until (done)
End;

Function SZ_GetReceiverInfo: Integer;
VAR
   rxflags, n, c: Integer;
Begin
   Z_Message('Getting info.');
   For n := 1 To 10 Do
   Begin
      c := Z_GetHeader(rxhdr);
      Z_Frame(c);
      CASE c OF
         ZCHALLENGE: Begin
                        Z_PutLongIntoHeader(rxpos);
                        Z_SendHexHeader(ZACK,txhdr)
                     End;
         ZCOMMAND: Begin
                      Z_PutLongIntoHeader(Longint(0));
                      Z_SendHexHeader(ZRQINIT,txhdr)
                   End;
         ZRINIT: Begin
                    rxbuflen := (Word(rxhdr[ZP1]) Shl 8) Or rxhdr[ZP0];
                    usecrc32 := ((rxhdr[ZF0] AND CANFC32) <> 0);
                    Z_ShowCheck(usecrc32);
                    SZ_GetReceiverInfo := ZOK;
                    Exit
                 End;
         ZCAN,
         RCDO,
         ZTIMEOUT: Begin
                      SZ_GetReceiverInfo := ZERROR;
                      Exit
                   End
         Else
            If (c <> ZRQINIT) Or (rxhdr[ZF0] <> ZCOMMAND) Then
               Z_SendHexHeader(ZNAK,txhdr)
      End {case}
   End; {for}
   SZ_GetReceiverInfo := ZERROR
End;

Function SZ_SyncWithReceiver: Integer;
VAR
   c, num_errs: Integer;
   done: BOOLEAN;
Begin
   num_errs := 7;
   done := FALSE;
   REPEAT
      c := Z_GetHeader(rxhdr);
      Z_Frame(c);
      Z_ClearInbound;
      CASE c OF
         ZTIMEOUT: Begin
                      Dec(num_errs);
                      If (num_errs < 0) Then
                      Begin
                         SZ_SyncWithReceiver := ZERROR;
                         Exit
                      End
                   End;
         ZCAN,
         ZABORT,
         ZFIN,
         RCDO: Begin
                  SZ_SyncWithReceiver := ZERROR;
                  Exit
               End;
         ZRPOS: Begin
                   If (Not Z_SeekFile(infile,rxpos)) Then
                   Begin
                      Z_Message('File Seek error');
                      SZ_SyncWithReceiver := ZERROR;
                      Exit
                   End;
                   Z_Message('Repositioning...');
                   Z_ShowLoc(rxpos);
                   txpos := rxpos;
                   SZ_SyncWithReceiver := c;
                   Exit
                End;
         ZSKIP,
         ZRINIT,
         ZACK: Begin
                  SZ_SyncWithReceiver := c;
                  Exit
               End
         Else
         Begin
            Z_Message('I dunno what happened!');
            SZ_SendBinaryHeader(ZNAK,txhdr)
         End
      End {case}
   Until (done)
End;


Function SZ_SendFileData: Integer;
LABEL
   waitack, somemore, oops;
VAR
   c, e: Integer;
   newcnt, blklen, blkred, maxblklen, goodblks, goodneeded: Word;
Begin
   Z_Message('Sending File...');
   goodneeded := 1;
   If (zbaud < 300) Then
      maxblklen := 128
   Else
      maxblklen := (Word(zbaud) Div 300) * 256;
   If (maxblklen > ZBUFSIZE) Then
      maxblklen := ZBUFSIZE;
   If (rxbuflen > 0) AND (rxbuflen < maxblklen) Then
      maxblklen := rxbuflen;
   blklen := maxblklen;
   ztime := Z_SetTimer;
somemore:
   If (Z_CharAvail) Then
   Begin
WaitAck:
      c := SZ_SyncWithReceiver;
      Z_Frame(c);
      CASE c OF
         ZSKIP: Begin
                   SZ_SendFileData := ZSKIP;
                   Exit
                End;
         ZACK: {null};
         ZRPOS: Begin
                   Inc(zerrors);
                   Z_Errors(zerrors);
                   If ((blklen Shr 2) > 32) Then
                      blklen := (blklen Shr 2)
                   Else
                      blklen := 32;
                   goodblks := 0;
                   goodneeded := (goodneeded Shl 1) Or 1
                End;
         ZRINIT: Begin
                    SZ_SendFileData := ZOK;
                    Exit
                 End
         Else
         Begin
            SZ_SendFileData := ZERROR;
            Exit
         End
      End {case};
      While (Z_CharAvail) Do
      Begin
         CASE (Z_GetByte(1)) OF
            CAN,
            ZPAD: Goto waitack;
            RCDO: Begin
                     SZ_SendFileData := ZERROR;
                     Exit
                  End
         End {case}
      End
   End; {if Char avail}
   newcnt := rxbuflen;
   Z_PutLongIntoHeader(txpos);
   SZ_SendBinaryHeader(ZDATA,txhdr);
   Z_Message('Sending data header');
   REPEAT
      If (Keypressed) Then
         If (Readkey = #27) Then
         Begin
            Z_Message('Aborted from keyboard');
            Z_SendCan;
            Goto oops
         End;
      If (Not Z_Carrier) Then
         Goto oops;
      If (Not Z_ReadFile(infile,txbuf,blklen,blkred)) Then
      Begin
         Z_Message('Error reading disk');
         Z_SendCan;
         Goto oops
      End;
      If (blkred < blklen) Then
         e := ZCRCE
      Else If (rxbuflen <> 0) AND ((newcnt - blkred) <= 0) Then
      Begin
         newcnt := (newcnt - blkred);
         e := ZCRCW
      End
      Else
         e := ZCRCG;
      SZ_SendData(txbuf,blkred,e);
      txpos := txpos + blkred;
      Z_ShowLoc(txpos);
      Inc(goodblks);
      If (blklen < maxblklen) AND (goodblks > goodneeded) Then
      Begin
         If ((blklen Shl 1) < maxblklen) Then
            blklen := (blklen Shl 1)
         Else
            blklen := maxblklen;
         goodblks := 0
      End;
      If (e = ZCRCW) Then
         Goto waitack;
      While (Z_CharAvail) Do
      Begin
         CASE Z_GetByte(1) OF
            CAN,
            ZPAD: Begin
                     Z_Message('Trouble?');
                     Z_ClearOutbound;
                     SZ_SendData(txbuf,0,ZCRCE);
                     Goto waitack
                  End;
            RCDO: Begin
                     SZ_SendFileData := ZERROR;
                     Exit
                  End
         End {case}
      End {while}
   Until (e <> ZCRCG);
   REPEAT
      Z_PutLongIntoHeader(txpos);
      Z_Message('Sending Eof');
      SZ_SendBinaryHeader(ZEOF,txhdr);
      c := SZ_SyncWithReceiver;
      CASE c OF
         ZACK: {null};
         ZRPOS: Goto somemore;
         ZRINIT: Begin
                    SZ_SendFileData := ZOK;
                    Exit
                 End;
         ZSKIP: Begin
                   SZ_SendFileData := c;
                   Exit
                End
         Else
oops:    Begin
            SZ_SendFileData := ZERROR;
            Exit
         End
      End {case}
   Until (c <> ZACK)
End;

Function SZ_SendFile: Integer;
VAR
   c: Integer;
   done: BOOLEAN;
Begin
   zerrors := Word(0);
   done := FALSE;
   REPEAT
      If (Keypressed) Then
         If (Readkey = #27) Then
         Begin
            Z_SendCan;
            Z_Message('Aborted from keyboard');
            SZ_SendFile := ZERROR;
            Exit
         End;
      If (Not Z_Carrier) Then
      Begin
         Z_Message('Lost carrier');
         SZ_SendFile := ZERROR;
         Exit
      End;
      Fillchar(txhdr,4,0);
      txhdr[ZF0] := ZCRESUM; {recover}
      SZ_SendBinaryHeader(ZFILE,txhdr);
      SZ_SendData(txbuf,ZBUFSIZE,ZCRCW);
      REPEAT
         c := Z_GetHeader(rxhdr);
         Z_Frame(c);
         CASE c OF
            ZCAN,
            RCDO,
            ZTIMEOUT,
            ZFIN,
            ZABORT: Begin
                       SZ_SendFile := ZERROR;
                       Exit
                    End;
            ZRINIT: {null - this will cause a loopback};
            ZCRC: Begin
                     Z_PutLongIntoHeader(Z_FileCRC32(infile));
                     Z_SendHexHeader(ZCRC,txhdr)
                  End;
            ZSKIP: Begin
                       SZ_SendFile := c;
                       Exit
                    End;
            ZRPOS: Begin
                      If (Not Z_SeekFile(infile,rxpos)) Then
                      Begin
                         Z_Message('File positioning error');
                         Z_SendHexHeader(ZFERR,txhdr);
                         SZ_SendFile := ZERROR;
                         Exit
                      End;
                      Z_Message('Setting start position');
                      Z_ShowLoc(rxpos);
                      strtpos := rxpos;
                      txpos := rxpos;
                      SZ_SendFile := SZ_SendFileData;
                      Exit
                   End
         End {case}
      Until (c <> ZRINIT)
   Until (done)
End;

Function Zmodem_Send(pathname: String; lastfile: BOOLEAN; comport: Word; baudrate: Longint): BOOLEAN;

VAR
   s: String;
   n: Integer;
Begin
   zerrors := 0;
   zbaud := baudrate;
   zport := comport;
   Z_OpenWindow(TPZVER);
   If (Not Z_AsyncOn(comport,baudrate)) Then
   Begin
      Z_Message('Unable To open port');
      Delay(2000);
      Z_CloseWindow;
      Zmodem_Send := FALSE;
      Exit
   End;
   If (Not Z_Carrier) Then
   Begin
      Z_Message('Lost carrier');
      Delay(2000);
      Z_CloseWindow;
      Z_AsyncOff;
      Zmodem_Send := FALSE;
      Exit
   End;
   If (Not Z_FindFile(pathname,fname,fsize,ftime)) Then
   Begin
      Z_Message('Unable To find/open File');
      SZ_EndSend;
      Z_CloseWindow;
      Z_AsyncOff;
      Zmodem_Send := FALSE;
      Exit
   End;
   Z_ShowName(fname);
   Z_ShowSize(fsize);
   Z_ShowTransferTime(fsize,zbaud);
   Str(fsize,s);
   s := (fname + #0 + s + ' ');
   s := s + Z_ToUnixDate(ftime);
   n := Length(s);
   For n := 1 To Length(s) Do
   Begin
      If (s[n] In ['A'..'Z']) Then
         s[n] := Chr(Ord(s[n]) + $20)
   End;
   Fillchar(txbuf,ZBUFSIZE,0);
   Move(s[1],txbuf[0],Length(s));
   If (zbaud > 0) Then
      rxtimeout := Integer(614400 Div zbaud)
   Else
      rxtimeout := 100;
   If (rxtimeout < 100) Then
      rxtimeout := 100;
   attn[0] := Ord('r');
   attn[1] := Ord('z');
   attn[3] := 13;
   attn[4] := 0;
   Z_PutString(attn);
   Fillchar(attn,Sizeof(attn),0);
   Z_PutLongIntoHeader(Longint(0));
   Z_Message('Sending ZRQINIT');
   Z_SendHexHeader(ZRQINIT,txhdr);
   If (SZ_GetReceiverInfo = ZERROR) Then
   Begin
      Z_CloseWindow;
      Z_AsyncOff;
      Zmodem_Send := FALSE;
      Exit
   End;
   If (Not Z_OpenFile(infile,pathname)) Then
   If (Ioresult <> 0) Then
   Begin
      Z_Message('Failure To open File');
      Z_SendCan;
      Z_CloseWindow;
      Z_AsyncOff;
      Zmodem_Send := FALSE;
      Exit
   End;
   n := SZ_SendFile;
   zcps := (fsize Div (Z_SetTimer - ztime));
   Z_CloseFile(infile);
   Z_Frame(n);
   Str(zcps:4,s);
   Z_Message(s+' cps');
   If (n = ZOK) AND (lastfile) Then
      SZ_EndSend
   Else
      Z_SendCan;
   Z_CloseWindow;
   Z_AsyncOff;
   Zmodem_Send := True
End;
End.



