;
;  Check if a character in input comm buffer
;
         MOV   AX,[>Async_Buffer_Tail]
         CMP   AX,[>Async_Buffer_Head]
         JNE   Rec1
;
;  Buffer empty -- begin wait loop.
;
         MOV   AX,[BP+<Secs]                 ;Get seconds to wait
         MOV   CX,10                         ;Shift count = 2 ** 10 = 1024
         SHL   AX,CL                         ;Seconds * 1024 = milleseconds
         MOV   CX,AX                         ;Move to looping register
;
;  Delay for 1 ms.
;
Delay:   PUSH  CX                            ;Save milleseconds to go
         MOV   CX,[>Async_OneMSDelay]        ;Get delay loop value for 1 ms
Delay1:  LOOP  Delay1                        ;Tight loop for 1 ms delay
;
;  Check if any character yet.
;
         POP   CX                            ;Get back millesecond count
;
         MOV   AX,[>Async_Buffer_Tail]
         CMP   AX,[>Async_Buffer_Head]
         JNE   Rec1
;
;  Buffer still empty -- decrement elapsed time
;
         LOOP  Delay                         ;Decrement millesecond count and loop
;
;  Dropped through -- no character arrived in specified interval.
;  Return TimeOut as result.
;
         MOV   BX,>TimeOut                   ;Pick up timeout value
         LES   DI,[BP+<C]                    ;Get result character address
    ES:  MOV   [DI],BX                       ;Store timeout value
         JMP   Return                        ;Return to caller
;
;  Buffer not empty -- pick up next character.
;
Rec1:    LES   DI,[>Async_Buffer_Ptr]        ;Pick up buffer address
         ADD   DI,AX                         ;Add character offset
     ES: MOV   BL,[DI]                       ;Get character from buffer
;
         XOR   BH,BH                         ;Clear high-order bits
         LES   DI,[BP+<C]                    ;Get result address
     ES: MOV   [DI],BX                       ;Store character from buffer
;
         INC   AX                            ;Increment tail pointer
         CMP   AX,[>Async_Buffer_Size]       ;Past end of buffer?
         JLE   Rec2                          ;No -- skip wrapping
         XOR   AX,AX                         ;Yes -- point to start of buffer
Rec2:    MOV   [>Async_Buffer_Tail],AX       ;Update tail pointer
         MOV   AX,[>Async_Buffer_Used]       ;Pick up amount of buffer used
         DEC   AX                            ;Update buffer use count
         MOV   [>Async_Buffer_Used],AX       ;
;
; Check how empty the receive buffer is.
; We may have previously sent XOFF, or dropped RTS, to
; stop sender from sending.  If so, and the buffer is
; now empty enough, we should re-enable the sender.
;
         TEST  BYTE [<Async_Sender_On],1     ;See if sender enabled
         JNZ   Return                        ;Skip buffer tests if so
;
         CMP   AX,[>Async_Buffer_Low]        ;Check if low enough
         JG    Return                        ;Still too full, skip
;
; Buffer is reasonably empty, send XON to get things rolling again
; if XOFF previously sent.
;
         TEST  BYTE [<Async_XOff_Sent],1     ;Check if Xoff sent
         JZ    Rec3                          ;No -- skip.
;
         MOV   AX,>XON                       ;Else push XON onto stack
         PUSH  AX
         CALL  FAR [>Async_Send_Addr]        ;Call output routine
;
         MOV   BYTE [>Async_XOff_Sent],0     ;Clear Xoff flag
;
; If RTS dropped because buffer was too full, enable RTS.
;
Rec3:    TEST    BYTE [<Async_Do_Cts],1      ;Check if CTS/RTS checking
         JZ      Rec4                        ;No -- skip
;
         MOV     DX,[>Async_Uart_MCR]        ;Get modem control register
         IN      AL,DX
         OR      AL,<Async_RTS               ;Enable RTS
         OUT     DX,AL
;
; If DTR dropped because buffer was too full, enable DTR.
;
Rec4:    TEST    BYTE [<Async_Do_Dsr],1      ;Check if DSR/DTR checking
         JZ      Rec5                        ;No -- skip
;
         MOV     DX,[>Async_Uart_MCR]        ;Get modem control register
         IN      AL,DX
         OR      AL,<Async_DTR               ;Enable DTR
         OUT     DX,AL
;
Rec5:    MOV     BYTE [>Async_Sender_On],1   ;Indicate sender enabled

Return:  AND     Byte [>Async_Line_Status],$FD ;Remove overflow flag
