(*
**  SReq.Inc (FrontDoor)
**
**  Structures of file created during an inbound service request
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved
**
**  Last revised: 91-10-02
*)

(*
**  Nodelist capability bit values
*)
CONST
  CMFLAG    = $00000002;                                            (* "CM" *)
  MOFLAG    = $00000004;                                            (* "MO" *)
  HSTFLAG   = $00000008;                                           (* "HST" *)
  H96FLAG   = $00000010;                                           (* "H96" *)
  PEPFLAG   = $00000020;                                           (* "PEP" *)
  MAXFLAG   = $00000040;                                           (* "MAX" *)
  XXFLAG    = $00000080;                                            (* "XX" *)
  XBFLAG    = $00000100;                                            (* "XB" *)
  XRFLAG    = $00000200;                                            (* "XR" *)
  XPFLAG    = $00000400;                                            (* "XP" *)
  XWFLAG    = $00000800;                                            (* "XW" *)
  MNPFLAG   = $00001000;                                           (* "MNP" *)
  V29FLAG   = $00002000;                                           (* "V29" *)
  V32FLAG   = $00004000;                                           (* "V32" *)
  V33FLAG   = $00008000;                                           (* "V33" *)
  V34FLAG   = $00010000;                                           (* "V34" *)
  V42FLAG   = $00020000;                                           (* "V42" *)
  XCFLAG    = $00040000;                                            (* "XC" *)
  XAFLAG    = $00080000;                                            (* "XA" *)
  V42bFLAG  = $00100000;                                          (* "V42B" *)
  V32bFLAG  = $00200000;                                          (* "V32B" *)
  CSPFLAG   = $00400000;                                           (* "CSP" *)


(*
**  The resulting file is written as:
**
**  <_InfoRec>                  <See below>
**  <NumValidEntriesInIDList>   <16-bit integer>
**  <_RemoteID * 20>            <See below>
*)
TYPE
  _RemoteID = RECORD
    Zone,                                                            (* AKA *)
    Net,
    Node,
    Point   : Word;
    Denied  : Boolean;                  (* Whether "DENY" is applied to AKA *)
  End;

  _InfoRec  = RECORD
    Name,                                                    (* System name *)
    Operator: string[80];                                (* System operator *)
    Location: string[40];                                (* System location *)
    Phone   : string[26];                  (* System telephone number (raw) *)
    Domain  : string[29];                
    Baud    : word;                          (* Maximum baud rate of system *)
    Flags   : string[51];                  (* Nodelist flags (as presented) *)
    Zone,                    (* Primary AKA, same as first _RemoteID record *)
    Net,
    Node,
    Point   : word;                      
    Cap     : longint;             (* Nodelist flags (as found in Nodelist) *)
    TrxNum  : string[10];                             (* Transaction number *)
    SerNum  : string[31];                                  (* Serial number *)
    Password: string[17];                         (* Session level password *)
  End;

(* end of file "SReq.Inc" *)
