(*
**  Session.Inc (FrontDoor)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  PASSWORD.FD format for FrontDoor 2.00+
**
**  Last revision:  91-10-02
**                            
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)


(*
**  Status values, non-exclusive bit values
**
**  I.e. If the NOFREQS and ACTIVE options were set for an entry in the
**       security list, the status field would contain 0x05.
*)
CONST
  ACTIVE    = $01;                        (* Active, as opposed to inactive *)
  DELETED   = $02;                                 (* Never written to disk *)
  NOFREQS   = $04;                 (* Don't allow file requests from system *)
  NOMAIL    = $08;                          (* Don't allow mail from system *)
  NOEMSI    = $10;                    (* No outbound EMSI sessions w/system *)
  NOFTSC1   = $20;                  (* No outbound FTSC-1 sessions w/system *)
  NOZAP     = $40;                  (* No outbound ZedZap sessions w/system *)
  NOYOOHOO  = $80;                  (* No outbound YooHoo sessions w/system *)

(*
**  Note that any settings in the FDOPT environment variable applies to
**  all sessions (inbound AND outbound). For example, if FDOPT contains
**  "NOEMSI", NO EMSI handshaking will be done, regardless of settings
**  in the security manager
*)
TYPE
  PwdRec    = RECORD
    Zone,
    Net,
    Node,
    Point   : word;
    Password: Array[1..9] of char;                        (* NUL terminated *)
    Status  : byte;
  End;

(* end of file "Session.Inc" *)
