Program TTRAN;
(*
SEALINK in Pascal.  (STAND-ALONE)
Copyright (c)1990,1991 Eric J. Givler, All Rights Reserved.
-1st attempt at converting this.

SEAlink - Sliding window file transfer protocol
Version 1.20, created on 08/05/87 at 17:51:40
(C) COPYRIGHT 1986,87 by System Enhancement Associates; ALL RIGHTS RESERVED
*)
Uses crt,
  DOS,
  fos,         { fos Send uses char, FOSSIL uses byte }
  CRCS;

Var filename : String;
  transfer : Boolean;
  
  {
  CONVENTIONS:
  com_putc(c) = send(CHAR);    ( FOSSIL   )
  com_getc(t) = com_getc(t);   ( INTERNAL )
  com_dump()  = purgeoutput;   ( FOSSIL   )
  }
  
Function leap ( yr : Integer) : Boolean;
Begin
  If ( ( (yr Mod 4 = 0) And (yr Mod 100 <> 0) )
     Or (yr Mod 400 = 0) ) 
  Then leap := True Else leap := False;
End;

Function Since79 (dt : DateTime) : LongInt;
Var i, leapyrs : Integer;
  secs, thisyear : LongInt;
  Month : Array [1..12] Of Integer;
Begin
  Month [1] := 31; Month [2] := 28; Month [3] := 31; Month [4] := 30;
  Month [5] := 31; Month [6] := 30; Month [7] := 31; Month [8] := 31;
  Month [9] := 30; Month [10] := 31; Month [11] := 30; Month [12] := 31;
  leapyrs := 0;
  For i := 1970 To (dt. Year - 1) Do If leap (i) Then Inc (leapyrs);
  secs := (dt. Year - 1979) * 86400 * 365 + leapyrs * 86400;
  thisyear := (LongInt (dt. Hour) * 60 * 60) + (dt. Min * 60) + (dt. Sec) +
  ( (dt. Day - 1) * 86400);
  For i := 1 To (dt. Month - 1) Do thisyear := thisyear + (Month [i] * 86400);
  If leap (dt. Year) And (dt. Month > 2) Then thisyear := thisyear + 86400;
  Since79 := secs + thisyear;
End;



Function SEALink (fname: String; upload: Boolean): Boolean;

Const Window = 6;                       (* maximum size of window  *)
  ACK    = #$06;
  NAK    = #$15;
  SOH    = #$01;
  EOT    = #$04;
  CPMEOF = ^Z;
  
Type block0 = Record                    (* block zero data structure *)
                flen   : LongInt;                (* file length               *)
                fstamp : LongInt;                (* file date/time stamp      *)
                fnam   : Array [1..17] Of Char;   (* original file name        *)
                prog   : Array [1..15] Of Char;   (* sending program name      *)
                noacks : Char;                   (* true if ACKing not req.   *)
                Fill   : Array [1..87] Of Char;   (* reserved for future use   *)
              End;
  blocktype = Array [0..127] Of Byte; (* A typical xmodem block    *)
  
  { STATICS in C }
Var  outblk : Integer;                 (* number of next block to send  *)
  ackblk : Integer;                 (* number of last block ACKed    *)
  blksnt : Integer;                 (* number of last block sent     *)
  slide  : Integer;                 (* true if sliding window        *)
  ackst  : Integer;                 (* ACK/NAK state                 *)
  numnak : Integer;                 (* number of sequential NAKs     *)
  chktec : Integer;                 (* check type, 1=CRC, 0=checksum *)
  toterr : Integer;                 (* total number of errors        *)
  ackrep : Integer;                 (* true when ACK or NAK reported *)
  ackseen: Integer;                 (* count of sliding ACKs seen    *)
  
  progname: String;                 (* sending program               *)
  ackless : Integer;                (* true if ACKs not req. Ovrdrv  *)
  t1      : LongInt;                (* timer, timerset               *)
  rawblk  : Integer;                (* raw block number              *)
  
  results : Boolean;
  Sector  : blocktype;              (* A packet of data 128 bytes    *)
  
  
Function TimerSet (tenths: Word) : LongInt;
     { Returns a timer value which will expire in T tenths of a second }
     Var
       Hour, Min, Sec, HSec : Word;
       Year, Mon, Day, DoW : Word;
     Begin
       GetDate (Year, Mon, Day, DoW);
       GetTime (Hour, Min, Sec, HSec);
       timerset := tenths + Hsec + 100 * (Sec + 60 * (Min + 60 * (Hour + 24 * DoW) ) );
     End; {  timerset }

     Function TimeUp (Marker : LongInt) : Boolean;
     { Returns true if timer z has expired yet, or false otherwise }
     Var Marker2 : LongInt;
     Begin
       Marker2 := TimerSet (0);
       If (Marker - Marker2) > (8640000) Then          { 24*60*60*100 }
         Marker2 := Marker2 + (60480000);             {7*24*60*60*100}
       TimeUp := Marker2 >= Marker;
     End; { TimeUp }


     Function com_getc ( t : LongInt): Integer;
     {Get char from port in t tenths of a sec.Return CPMEOF if time expired.}
     Var Expires : LongInt;
     Begin
       Expires := TimerSet (t);
       Repeat
       Until serialchar Or (TimeUp (Expires) );
       If serialchar Then com_getc := Ord (receive)
       Else com_getc := Ord (CPMEOF);
     End; { com_getc }


(*   The various ACK/NAK states are:
        0:   Ground state, ACK or NAK expected.
        1:   ACK received
        2:   NAK received
        3:   ACK, block# received
        4:   NAK, block# received
        5:   Returning to ground state
*)
    Procedure ackchk; (* check for ACK or NAK *)
    Var c   : Integer;                      (* one byte of data     *)
    Begin
      ackrep := 0;                          (* nothing reported yet *)
      c := com_getc (0);
      While (c <> Ord (CPMEOF) ) Do Begin
        If (ackst = 3) Or (ackst = 4) Then Begin
          slide := 0;                      (* assume this will fail        *)
          If (rawblk = (c Or $FF) ) Then    (* see if we believe the number *)
          Begin
            rawblk := outblk - ( (outblk - rawblk) And $FF);
            If (rawblk >= 0) And (rawblk <= outblk) And (rawblk > outblk - 128)
            Then Begin
              If (ackst = 3) Then Begin     (* advance for an ACK     *)
                If ackblk > rawblk Then ackblk := ackblk
                Else ackblk := rawblk;
                slide := 1;               (* we have sliding window! *)
                Inc (ackseen);
                If ( (ackless And ackseen) > 10) Then Begin
                  ackless := 0;          (* receiver not ACKless    *)
                  WriteLn ('- Overdrive disengaged    ');
                End;
                Write (#13, '  ACK ', rawblk, ' ==');
              End
              Else Begin        (* else retransmit for a NAK *)
                If rawblk < 0 Then outblk := 0 Else outblk := rawblk;
                slide := Integer (numnak < 4); {boolean}
                Write (#13, '  NAK ', rawblk, ' ==');
              End;
              ackrep := 1;     (* we reported something  *)
            End;
          End;
          ackst := 5;            (* return to ground state *)
        End;
        
        If (ackst = 1) Or (ackst = 2) Then Begin
          rawblk := c;
          Inc (ackst, 2);
        End;
        
        If (slide = 0) Or (ackst = 0) Then Begin
          If (c = Ord (ACK) ) Then Begin
            If (slide = 0) Then Begin
              Inc (ackblk);
              Write (#13, '  ACK ', ackblk, ' --');
              ackrep := 1;     (* we reported an ACK *)
            End;
            ackst := 1;
            numnak := 0;
          End
          
          Else If (c = Ord ('C') ) Or (c = Ord (NAK) ) Then Begin
            If (chktec > 1) Then Begin (* if method not determined yet *)
              If (c = Ord ('C') ) Then chktec := 1
              Else chktec := 0;     (* then do what receiver wants *)
            End;
            purgeoutput;      (* purge pending output *)
            Delay (6);         (* resynch              *)
            
            If (slide = 0) Then Begin
              outblk := ackblk + 1;
              Write (#13, '  NAK ', ackblk + 1, ' --');
              ackrep := 1;    (* we reported a negative ACK *)
            End;
            ackst := 2;
            Inc (numnak);
            If (blksnt <> 0) Then Inc (toterr);
          End; (* else *)
        End; (* slide = 0 or ackst = 0 *)
        
        If (ackst = 5) Then ackst := 0;
        c := com_getc (0);
      End; { while }
    End; { ackblk }


    Procedure shipblk (blk : blocktype; blknum : Integer);
    {PHYSICALLY SHIP A BLOCK,blk=data to be shipped, blknum=number of block}
    Var n,                             (* index                    *)
      crc : Integer;                 (* CRC check value          *)
    Begin
      send (SOH);                      (* block header             *)
      send (Chr (blknum) );              (* block number             *)
      send (Chr (blknum XOr 255) );      (* -blknum-1                *)
      sendblk (Seg (blk [0] ), Ofs (blk [0] ), 128); (* from Fossil unit   *)
      crc := 0;
      If chktec = 1 Then Begin
        crca (blk, SizeOf (blk), crc);
        send (Chr (Hi (crc) ) );
        send (Chr (Lo (crc) ) );
      End Else Begin
        For n := 0 To 127 Do crc := (crc + blk [n] ) Mod 256;
        send (Chr (crc) );
      End;
      purgeline;
    End; { shipblk }


     Procedure sendblock (Var f : File; blknum: Integer); (* send one block *)
     { f=file to read from, blknum=block to send }
     Var blkloc : LongInt;                  (* address of start of block *)
       buf    : blocktype;                (* one block of data         *)
       result : Word;
     Begin
       If (blknum <> blksnt + 1 ) Then Begin       (* if jumping    *)
         blkloc := LongInt (blknum - 1) * LongInt (128);
         Seek (f, blkloc);                       (* move where to *)
       End;
       blksnt := blknum;
       FillChar (buf, SizeOf (buf), CPMEOF);    (* fill buffer with ^Zs      *)
       BlockRead (f, buf, 1, result);           (* read in some data         *)
       shipblk (buf, blknum);                 (* pump it out the comm port *)
     End; { sendblock }

{=======================================================================}

Function xmtfile (fname: String) : Boolean;
(*
    This routine is used to send a file.  One file is sent at a time.
    If the name is blank (name is null or *name points to a null),
    then only an end of transmission marker is sent. This routine
    returns a one if the file is successfully transmitted, or a zero
    if a fatal error occurs.
*)
Label abort;
Var workfile : File;                       (* file to send           *)
  endblk : Integer;                      (* block number of EOT    *)
  zero   : block0;                       (* block zero data        *)
  toadd  : Byte;
  fsize  : LongInt;
  dt     : DateTime;
Begin
  If fname <> '' Then Begin                 (* if sending a file  *)
    Assign (workfile, fname);
    {$I-} Reset (workfile, 1); {$I+}         (* to get proper size *)
    If IOResult <> 0 Then Begin
      WriteLn ('  Can''t read ', fname);
      xmtfile := False;
      Exit;
    End;
    
    FillChar (zero, SizeOf (zero), Chr (0) );       (*clear out data block *)
    (* get file statistics *)
    zero. flen := FileSize (workfile);          (* size of file -bytes *)
    endblk := ( (zero. flen + 127) Div 128) + 1;
    WriteLn ('Ready to send ', endblk - 1, ' blocks of ', fname, ' (', zero. flen, ')');
    Reset (workfile);                          (* for 128 byte reads  *)
    GetFTime (workfile, zero. fstamp);           (* time and date stamp *)
    {
    UnPackTime(zero.fstamp,dt);
    zero.fstamp := Since79(dt);
    }
    Move (fname [1], zero. fnam, Ord (fname [0] ) );
    Move (progname [1], zero. prog, Ord (progname [0] ) );
    zero. noacks := Char (ackless);             (* OVERDRIVE engaged?  *)
    Move (zero, Sector, SizeOf (zero) );           (* move into xmdm blk  *)
  End
  Else endblk := 0;                    (* fake for no file   *)
  
  outblk :=  1;                        (* set starting state *)
  ackblk := - 1;
  blksnt := 0;
  slide  := 0;
  ackst  := 0;
  numnak := 0;
  toterr := 0;
  ackrep := 0;
  ackseen := 0;
  chktec := 2;                        (* undetermined CRC or checksum? *)
  toadd  := 0;
  
  t1 := timerset (300);                (* time limit for first block  *)
  Write ('  Waiting...' + #13);
  
  While (ackblk < endblk) Do Begin     (* while not all there yet    *)
    If Not carrier Then Begin
      WriteLn (#13 + #10 + 'Lost carrier');
      Goto abort;
    End;
    
    If KeyPressed Then Begin
      If ReadKey = #27 Then Begin
        WriteLn (#13 + #10 + 'Aborted by operator');
        Goto abort;
      End;
    End;
    
    If ( timeup (t1) ) Then Begin
      WriteLn (#13 + #10 + 'Fatal timeout');
      Goto abort;
    End;
    
    If slide = 1 Then toadd := Window
    Else toadd := 1;
    
    If (outblk <= ackblk + toadd) Then Begin
      If (outblk < endblk) Then Begin
        If (outblk > 0) Then
          sendblock (workfile, outblk)
        Else
          shipblk (Sector, 0);
        
        If (ackrep <> 0) Then
          Write (' Sending block #', outblk, #13);
        
        If (ackless And slide) <> 0 Then Begin
          If (outblk Mod 10 = 0) Then
            Write (#13, '  Passing block ', outblk);
          ackblk := outblk;
        End;
      End
      Else If (outblk = endblk) Then Begin
        send (EOT);
        If (ackrep <> 0) Then
          Write (' Sent EOT           ' + #13);
      End;
      Inc (outblk);             (* outblk++;                 *)
      t1 := timerset (300);     (* time limit between blocks *)
    End;
    
    ackchk;                     (* determine ACK status      *)
    
    If (numnak > 10) Then Begin
      WriteLn (#13 + #10, '  Too many errors');
      Goto abort;
    End;
  End; { while }
  
  WriteLn (' End of file         ');
  If (endblk <> 0) Then Close (workfile);
  If (toterr > 2) Then
    Write (toterr, ' errors detected and fixed in ', blksnt, ' blocks.');
  xmtFile := True;                          (* exit with good status *)
  Exit;
  
  ABORT:
  If (endblk > 0) Then Close (workfile);
  If (toterr > 0) Then
    WriteLn (toterr, ' errors detected and fixed in ', blksnt, ' blocks.');
  xmtFile := False;                         (* exit with bad status *)
End; (* xmtfile *)

{=======================================================================}

Function rcvfile (fname: String) : String;
{ File receiver logic, fname = name of file }
Label nakblock,                              (* we got a bad block *)
  abort,                                 (* errors occurred    *)
  ackblock,
  nextblock,
  blockstart,
  endrcv;
Var c,                                 (* received character            *)
  tries,                             (* retry counter                 *)
  blknum,                            (* desired block number          *)
  inblk,                             (* this block number             *)
  endblk,                            (* block number of EOT, if known *)
  n       : Integer;                 (* index                         *)
  workfile: File;                    (* file, opener                  *)
  tmpname : String [100];             (* name of temporary file        *)
  outname : String [100];             (* name of final file            *)
  buf     : blocktype;               (* data buffer                   *)
  zero    : block0;                  (* file header data storage      *)
  Left    : LongInt;                 (* bytes left to output          *)
  stat : String [4];                  (* receive block status          *)
  result : Word;                     (* result of block write         *)
  why : String;                      (* single block receiver status  *)
  {   char *getblock(), *why;            (* single block receiver, status *)}
  
  
Procedure sendack (acknak, blknum: Integer);  (* send an ACK or a NAK  *)
    (* acknak: 1=ACK, 0=NAK *)
    Begin
      If (acknak = 1) Then send (ACK)           (* send the right signal *)
      Else If (chktec = 1) Then send ('C')     (* CRC type ACK          *)
      Else send (NAK);                         (* send NAK              *)
      
      send (Chr (blknum) );                      (* block number          *)
      send (Chr ( - blknum - 1) );                   (* block number check    *)
    End; (* sendack*)


    Function getblock (Var buf : blocktype): String; (* read a block of data *)
    (* buf = data buffer *)
    Var ourcrc : Word;
      hiscrc : Integer;                  (* CRC check values    *)
      c,                                 (* one byte of data    *)
      n      : Integer;                  (* index               *)
      timeout: Integer;                  (* short block timeout *)
    Begin
      ourcrc := 0; hiscrc := 0;
      If ackless = 1 Then timeout := 200 Else timeout := 5;
      
      For n := 0 To 127 Do Begin
        c := com_getc (timeout);
        If (c = Ord (CPMEOF) ) Then getblock := 'Short';
        
        If (chktec = 1) Then
          updcrc (ourcrc, c)                    (* CRC table calculation *)
        Else ourcrc := (ourcrc + c) Mod 256;   (* checksum              *)
        buf [n] := c;
      End;
      
      If (chktec = 1) Then Begin                (* CRC mode              *)
        { ourcrc := crc_finish(ourcrc); }
        hiscrc := (com_getc (timeout) ShL 8) Or com_getc (timeout);
      End Else Begin
        ourcrc := ourcrc And $FF;
        hiscrc := com_getc (timeout) And $FF;
      End;
      
      If (ourcrc = hiscrc) Then Begin
        getblock := '';                       (* block is good  *)
        Exit;
      End
      Else If (chktec = 1) Then Begin          (* else CRC error *)
        getblock := 'CRC  ';
        Exit;
      End
      Else getblock := 'Check';         (* or maybe checksum error *)
    End; (* function GETBLOCK *)


Begin (* rcvfile *)
  WriteLn;
  rcvfile := '';
  stat := 'Init';                    (* receive block status     *)
  If (fname <> '') Then Begin        (* figure out a name to use *)
    {makefnam("X:\\",name,outname);}
    {outname[2] = '-';}
    {makefnam(outname+2,name,tmpname);}
    {strcpy(outname,name);}
    outname := fname;                     
    Delete (outname, 1, 1);
    tmpname := '-' + outname;
  End Else Begin
    outname := '';
    tmpname := '-TMPFILE.$$$';
  End;
  
  Assign (workfile, tmpname);          (* open output file *)
  {$I-} Reset (workfile); {$I+}
  If IOResult = 0 Then Begin
    WriteLn ('  Cannot create ', tmpname);
    Close (workfile);
    rcvfile := '';
    Exit;
  End;
  Rewrite (workfile);                 (* rewrite this file *)  
  
  If outname <> '' Then blknum := 1 
  Else blknum := 0;                (* first block we must get      *)
  tries  := - 10;                      (* kludge for first time around *)
  chktec := 1;                        (* try for CRC error checking   *)
  toterr := 0;                        (* no errors yet                *)
  endblk := 0;                        (* we don't know the size yet   *)
  ackless := 0;                       (* we don't know about this yet *)
  FillChar (zero, SizeOf (zero), 0);      (* or much of anything else     *)
  
  If com_getc (0) = Ord (SOH) Then      (* kludge for adaptive modem7   *)
    Goto nextblock;
  
  nakblock:                             (* we got a bad block           *)
  If (blknum > 1) Then Inc (toterr);
  Inc (tries);
  If (tries > 10) Then Begin
    WriteLn (#13 + #10'  Too many errors');
    Goto abort;
  End;
  
  If (tries = 0) Then chktec := 0;    (* if CRC isn't going       *)
  (* then give checksum a try *)
  
  sendack (0, blknum);                 (* send the NAK             *)
  Write ('  NAK block ', blknum, ' ', stat, #13);
  
  If (ackless = 1) And (toterr > 20) Then Begin
    ackless := 0;                       (* if ackless mode isn't working *)
    WriteLn ('- Overdrive disengaged'); (* then shut it off              *)
  End;
  Goto nextblock;
  
  ackblock:                              (* we got a good block *)
  If (ackless = 0) Then 
    Write ('  ACK block ', blknum - 1, ' ', stat, #13)
  Else Write ('  Got block ', blknum, #13);
  
  nextblock:                             (* start of "get a block" *)
  stat := '';
  If Not carrier Then Begin
    WriteLn (#13 + #10 + '  Lost carrier');
    Goto abort;
  End;
  
  If KeyPressed Then Begin
    If ReadKey = #27 Then Begin
      WriteLn (#13 + #10 + '  Aborted by operator');
      Goto abort;
    End;
  End;
  
  t1 := timerset (30);                (* timer to start of block *)
  While Not timeup (t1) Do Begin
    c := com_getc (0);
    If (c = Ord (EOT) ) Then Begin
      If ( endblk <> 0) Or (endblk = blknum) Then
        Goto endrcv;
    End
    Else If (c = Ord (SOH) ) Then Begin
      inblk := com_getc (5);
      If (com_getc (5) = (inblk Or $FF) ) Then
        Goto blockstart;       (* we found a start *)
    End;
  End;
  stat := 'Time ';
  Goto nakblock;
  
  blockstart:                            (* start of block detected *)
  c := blknum And $FF;
  If (inblk = 0) And (blknum <= 1) Then Begin (* if this is the header *)
    why := getblock (Sector);
    Move (Sector, zero, SizeOf (Sector) );  (* put into our SEALink header *)
    If why = '' Then Begin
      sendack (1, inblk);               (* ack the header              *)
      If fname = '' Then Begin        (* given name takes precedence *)
        Move (zero. fnam, outname [1], SizeOf (zero. fnam) );
        outname [0] := Chr (17);
      End;
      If (Left = zero. flen) Then   (* length to transfer    *)
        endblk := (Left + 127) Div 128 + 1;
      If (ackless <> Integer (zero. noacks) ) Then (* note variant *)
      Begin
        If Integer (zero. noacks) = 1 Then WriteLn ('+ Overdrive engaged')
        Else WriteLn ('+ Overdrive disengaged');
      End;
      ackless := Integer (zero. noacks);
      
      Write ('  Receiving');
      If (endblk <> 0) Then Write (' ', endblk - 1, ' blocks of');
      Write (outname);
      Move (zero. prog, progname [1], SizeOf (zero. prog) );
      progname [0] := Chr (15);
      If (progname <> '') Then Write (' from ', progname);
      WriteLn;
      blknum := 1;              (* now we want first data block *)
      Goto ackblock;
    End
    Else Begin
      stat := why;
      Goto nakblock;            (* bad header block *)
    End;
  End
  Else If (inblk = c) Then Begin        (* if this is the one we want *)
    why := getblock (buf);
    If why = '' Then Begin             (* else if we get it okay     *)
      sendack (1, inblk);               (* ack the data               *)
      For n := 0 To 127 Do Begin
        If (endblk <> 0) Then Begin   (* limit file size if known   *)
          If Left = 0 Then Goto endrcv;
          Dec (Left);
        End;
        {$I-} BlockWrite (workfile, buf [n], 1, result); {$I+}
        If IOResult <> 0 Then Begin
          WriteLn (#13 + #10, '  Write error (disk full?)');
          Goto abort;
        End;
      End;
      tries := 0;                    (* reset try count        *)
      Inc (blknum);                   (* we want the next block *)
      Goto ackblock;
    End
    Else Begin
      stat := why;
      Goto nakblock;                 (* ask for a resend       *)
    End;
  End                                  (* else if resending what we have *)
  Else If (inblk < c) Or (inblk > c + 100) Then Begin
    why := getblock (buf);             (* ignore it              *)
    sendack (1, inblk);                 (* but ack it             *)
    stat := 'Dup';
    Goto ackblock;
  End
  Else Goto nextblock;                 (* else if running ahead  *)
  
  endrcv:
  sendack (0, blknum);
  Write ('  NAK EOT         ', #13);
  If (com_getc (20) <> Ord (EOT) ) Then Goto nakblock;
  sendack (1, blknum);
  Write ('  ACK EOT', #13);
  
  If ( blknum > 1 ) Then Begin         (* if we really got anything *)
    If ( toterr > 2 ) Then 
      WriteLn (toterr, ' errors detected and fixed in ', blknum - 1, 'blocks.');
    
    If (zero. fstamp <> 0) Then      (* set stamp, if known *)
      SetFTime (workfile, zero. fstamp);
    Close (workfile);
    {unlink(outname);              (* erase this copy of file  * )}
    Rename (workfile, outname);
    rcvfile := outname;            (* signal what file we got    *)
    Exit;
  End
  Else Begin                          (* else no real file          *)
    Close (workfile);
    {unlink(tmpname);                (* discard empty file         *)}
    rcvfile := '';                   (* signal end of transfer     *)
  End;
  
  abort:
  If (toterr <> 0) Then
    WriteLn ('  ', toterr, ' errors detected and fixed in ', blknum - 1, ' blocks.');
  Close (workfile);
  rcvfile := '';
End; (* recvfile *)


Begin (* SEALink *)
  SEALink := False;
  progname := 'NBBS';                (* name of sending program *)
  slide   := 1;                     (* Sliding Windows please? *)
  rawblk  := 1;
  ackless := 0;                     (* acks ARE required       *)
  If upload Then SEALink := xmtfile (fname)
  Else SEALink := (rcvfile (fname) <> '');
End; (* SEALink *)


(* ==================================================================== 
                            QUICK INTERFACE
   ==================================================================== *)
Begin { SEALink Sample Test Shell }
  PortNum := 0;
  If Not OpenFossil Then Exit;
  WriteLn ('SEAlink (Pascal) v1.20');
  Write ('enter filename:');
  ReadLn (filename);
  Write ('press <S>end or <R>eceive');
  WriteLn;
  Repeat Until KeyPressed;
  If UpCase (ReadKey) = 'S' Then Begin
    transfer := SEALink (filename, True); (* upload SEND it *)
    filename := '';
    transfer := SEALink (filename, True); (* terminate it   *)
  End Else
    WriteLn (filename, ' was received as: ', SEALink (filename, False) );
  CloseFossil;
End. { SEALink Sample Test Shell }
