{$A+} {$B-} {$D+} {$G+} {$R-} {$S-} {$V-}
(*
  $A+: Align on word boundaries (for 80x86 processors
  $B-: short circuit boolean evaluation
  $G+: enable 80286 code optimization
  $L : local symbols switch
  $R+- only adds time when an index is used in array or a string
  $S+- checks stack whenever a procedure is called or a dynamic variable
       is created.
  $V+: Controls type-checking on strings passed as variable parameters
 
*)
(*
   PROTOCOL.PAS - protocol unit for NBBS BBS v1.00a
   (c)1989,1990,1993 Eric J. Givler, All Rights Reserved.

   History:

   Internal Functions and Procedures in this unit include:
   function eltime      - elapsed time calculations of transfers.
   function leap        - return true if year is a leap year
   function octal       - return octal string of a longint
   function since70     - Calculate seconds since 01/01/70
   function sendxmodem  - send xmodem/checksum
   function sendxmodemCRC guess?
   function send1kxmodem- send Xmodem-1K
   function sendymodem  - send true Ymodem (has header info)
   function sendascii   - not done
   function recvascii   - not done
   function recvxmodem  - Receive Xmodem/Checksum

   Dispatcher functions (CALLABLE)
   FUNCTION UpLoad(fname: string; using:protocols): boolean;
   FUNCTION DownLoad(fname: string; using:protocols): boolean;


   FOR A USER WHO DOESN'T HAVE MNP:
   var valid_protocol_set : set of protocol;

   valid_protocol_set := protocol_set - MNP_set;

   YOU CAN THEN STEP THROUGH THE SET, PRESENT THE USER WITH WHAT PROTOCOLS
   ARE AVAILABLE, AND THEN USE THE UNIT TO INITIATE THE TRANSFER.  LIKE:

   var p: protocol;
   p := integer(0);
   repeat
     writeln('How about using ', protocol_name[p]);
     p := succ(p);
   until (p = External);
*)
Unit PROTOCOL;

Interface

Type protocols = (ASCII, XmodemChkSum, XmodemCRC, Xmodem1K, Ymodem,
  MegaLink, YmodemG);
  
Const protocol_name: Array [protocols] Of String [12] =
  ('ASCII', 'XmodemChkSum', 'XmodemCRC', 'Xmodem1K',
  'Ymodem', 'MegaLink', 'YmodemG');
  
  protocol_set : Set Of protocols = [ASCII..YmodemG];
  batch_set    : Set Of protocols = [Ymodem, YmodemG, MegaLink];
  MNP_set      : Set Of protocols = [YmodemG];
  
Var errorcode : Byte;
  {
  0 = No Error, Success
  1 = User/Remote Aborted Transfer
  2 = Local Abort
  3 = Carrier Loss
  4 = Bad CRC
  5 = No ACK on EOT
  6 = File already exists?
  7 = File NOT found
  }
  cps : Real;  { result of last transfer - Characters Per Second }
  
  
  (* protocol dispatchers *)
Function Upload (fname: String; using : protocols): Boolean;
Function Download (fname: String; using : protocols): Boolean;

(* ------------------------- IMPLEMENTATION ---------------------------- *)
Implementation

Uses DOS,
  crt,     { Turbo Pascal CRT routines    }
  crcs,    { CRC calculation routines     }
  fos;     { Fossil communication library }

Const NUL  = 00;
  SOH  = #$01;            { Start Of Header (128)   }
  STX  = #$02;            { Start Of Header (1024)  }
  EOT  = #$04;            { End of Transmission     }
  ACK  = #$06;            { Acknowledge (positive)  }
  DLE  = #$10;            { Data Link Escape        }
  NAK  = #$15;            { Negative Acknowledge    }
  SYN  = #$16;            { Synchronous idle        }
  XON  = #$11;            { Transmit On (DC1)       }
  XOFF = #$13;            { Transmit Off (DC3)      }
  CAN  = #$18;            { Cancel                  }
  CPMEOF = #$1A;          { End Of File (padding)^Z }
  
  C   = #$43;
  TAB = 09;
  LF  = #$0A;
  CR  = #$0D;
  Space = ' ';
  
  lastbyte = 127;
  errormax = 5;
  retrymax = 10;             { 10 retries }
  
Type  blocktype = Array [0..127] Of Byte;
  
Var   Sector : blocktype;        { array[0..lastbyte] of byte; }
  systicks  : LongInt Absolute $40:$6c;
  tickstart : Real;
  
  
Function eltime (lesser, greater: Real): Real;
Begin
  If lesser <= greater Then
    eltime := greater - lesser
  Else eltime := (86400.0 - lesser) + greater;
End; (* eltime (elapsed time) for reals *)


Function SENDXMODEM (Var f : File): Boolean;
{ currently no abort local or remote allowed here!! }
Var j,                            { for local loops }
  result,
  checksum,
  blocknum,
  CH       : Integer;
  lc       : Char;              { possible local abort }
  counter  : Byte;
  temp     : String [5];
Begin
  sendxmodem := False;
  blocknum := 1;
  Str ( (FileSize (f) Div 128): 5, temp);
  WriteLn ('File open:' + temp + ' records.');
  Repeat
    counter := 0;
    FillChar (Sector, SizeOf (Sector), CPMEOF);
    BlockRead (f, Sector, SizeOf (Sector), result);
    Repeat
      Write (cr, 'Sending block: ', blocknum);
      FOS. Send (SOH);                             { Start of Header  }
      FOS. Send (Chr (blocknum) );                   { Packet Number    }
      FOS. Send (Chr ( - blocknum - 1) );                { One's complement }
      CHECKSUM := 0;
      FOS. Sendblk (Seg (Sector [0] ), Ofs (Sector [0] ), 128);
      For j := 0 To lastbyte Do CHECKSUM := (CHECKSUM + Sector [j] ) Mod 256;
      send (Chr (CHECKSUM) );
      purgeline;
      Inc (counter);
      CH := readline (10);
      If KeyPressed Then lc := ReadKey;
    Until (CH In [Ord (ACK), Ord (CAN) ] ) Or (counter = retrymax) Or (Not carrier);
    If (CH = Ord (CAN) ) Or (lc = #27) Then
    Begin
      errorcode := 1;
      Exit;
    End;        
    Inc (blocknum);
  Until EoF (f) Or (counter = retrymax) Or (Not FOS. carrier);
  If counter = retrymax Then
  Begin
    WriteLn (cr, lf, 'No ACK on sector');
    errorcode := 1;
  End
  Else
  Begin
    counter := 0;
    Repeat
      send (EOT);
      Inc (counter);
    Until (readline (10) = Ord (ACK) ) Or (counter = retrymax) Or (Not carrier);
    If counter = retrymax Then
    Begin
      WriteLn (cr, lf, 'No ACK on EOT');
      errorcode := 1;
    End
    Else
    Begin
      WriteLn (cr, lf, 'Transfer complete');
      errorcode := 0;
      sendxmodem := True;
    End;
  End;
End;


Function SendXmodemCRC ( Var f : File ) : Boolean;
Var  temp    : String [5];
  counter,
  result  : Word;
  j, k, blocknum: Integer;
Begin
  blocknum := 1;
  Str ( (FileSize (f) Div 128): 5, temp);
  WriteLn ('File open:' + temp + ' records.');
  Repeat
    counter := 0;
    FillChar (Sector, SizeOf (Sector), CPMEOF);
    {$I-} BlockRead (f, Sector, SizeOf (Sector), result); {$I+}
    If IOResult <> 0 Then
    Begin
      WriteLn ('Error Reading File: CANCELLED');
      Send (CAN); 
      Send (CAN);
      Exit;
    End;
    Repeat
      Write (cr, 'Sending block# ', blocknum);
      Send (SOH);
      Send (Chr (blocknum) );
      Send (Chr ( - blocknum - 1) );
      SendBlk ( Seg (Sector [0] ), Ofs (Sector [0] ), 128);
      crc := 0;
      Crca (Sector, SizeOf (Sector), crc);
      Send (Chr (Hi (crc) ) );
      Send (Chr (Lo (crc) ) );           
      PurgeLine;
      Inc (counter);
    Until (readline (10) = Ord (ACK) ) Or (counter = retrymax);
    Inc (blocknum);
  Until EoF (f) Or (counter = retrymax) Or (Not Carrier);
  If counter = retrymax Then
    WriteLn (cr, lf, 'No ACK on sector')
  Else 
  Begin
    counter := 0;
    Repeat
      Send (EOT);
      Inc (counter);
    Until (readline (10) = Ord (ACK) ) Or (counter = retrymax);
    If counter = retrymax Then
      WriteLn (cr, lf, 'No ACK on EOT')
    Else WriteLn (cr, lf, 'Transfer complete');
  End;
End;


Function SendAscii (fname: String): Boolean;
{ establish any flow control before calling this function }
Var thefile : Text;
  inch, CH, lc : Char;
Begin
  SendAscii := False;
  CH := ' '; lc := ' ';
  Assign (thefile, fname);
  {$I-} Reset (thefile); {$I+}
  If IOResult <> 0 Then Begin
    errorcode := 7; { file not found }
    Exit;
  End;
  Repeat
    Read (thefile, inch);
    send (inch);
    If serialchar Then CH := receive;
    If KeyPressed Then lc := ReadKey;
    {
    if ch = chr(ord(xoff))) then
    repeat 
    if serialchar then ch := receive;
    until ch = chr(ord(xon));
    }
  Until EoF (thefile) Or (Not carrier) Or (CH = ^X) Or (lc = #27);
  send (^Z);
  Close (thefile);
  SendAscii := True;
  errorcode := 0;
  If Not carrier Then Begin
    errorcode := 3;  SendAscii := False;
  End Else If CH = ^X Then Begin
    errorcode := 1;  SendAscii := False;
  End Else If lc = #27 Then Begin
    errorcode := 2;  SendAscii := False;
  End;
End;


Function octal ( t : LongInt) : String;
{ FUNCTION  octal   - Returns OCTAL string of a LongInt (seconds) }
Var quotient, remainder : LongInt;
  code : Integer;
  os : String;
  CH : String [1];
Begin
  os := '';
  CH := ' ';
  quotient := t;
  While (quotient <> 0) Do Begin
    quotient := quotient Div 8;
    remainder := t Mod 8;
    t := quotient;
    Str (remainder, CH);
    os := CH + os;
  End;
  octal := os;
End;


Function leap ( yr : Integer) : Boolean;
{ FUNCTION  leap    - Returns TRUE if yr is a leapyear. }
Begin
  If ( ( (yr Mod 4 = 0) And (yr Mod 100 <> 0) ) Or (yr Mod 400 = 0) ) Then 
    leap := True 
  Else leap := False;
End;


Function since70 (dt : DateTime) : LongInt;
{ FUNCTION  since70 - Calculates seconds since 01/01/70 for LAST UPDATE }
Const Month : Array [1..12] Of Integer = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
Var i, leapyrs : Integer;
  secs, thisyear : LongInt;
Begin
  leapyrs := 0;
  For i := 1970 To (dt. Year - 1) Do If leap (i) Then Inc (leapyrs);
  secs := (dt. Year - 1970) * 86400 * 365 + leapyrs * 86400;
  thisyear := (LongInt (dt. Hour) * 60 * 60) + (dt. Min * 60) + (dt. Sec) +
  ( (dt. Day - 1) * 86400);
  For i := 1 To (dt. Month - 1) Do thisyear := thisyear + (Month [i] * 86400);
  If leap (dt. Year) And (dt. Month > 2) Then thisyear := thisyear + 86400;
  since70 := secs + thisyear;
End;


{============================== SendYmodem =============================}
Function  SENDYMODEM ( filename : String; Var f : File ) : Boolean;
Const NULL = $0;
Var block : Array [0..1023] Of Byte; (* byte *)
  temp : String [5];
  j, i  : Integer;
  Str1  : String;
  ftime  : LongInt;
  tcrc   : Word;
  dt : DateTime;
  blocknum,
  counter,
  result : Integer;
Begin
  
  (* Build Ymodem header block - block 0 *)
  FillChar (Sector, SizeOf (Sector), NULL); { chr(0) }
  For j := 0 To Length (filename) - 1 Do Sector [j] := Ord (filename [j + 1] );
  Inc (j);
  Str (FileSize (f), Str1);
  For i := 1 To Length (Str1) Do Sector [j + i] := Ord (Str1 [i] );
  j := j + i + 1;
  Sector [j] := $20;
  GetFTime (f, ftime);
  UnpackTime (ftime, dt);
  Str1 := Octal (Since70 (dt) );
  For i := 1 To Length (Str1) Do Sector [j + i] := Ord (Str1 [i] );
  Sector [j + i + 1] := $20;
  
  (* Send header packet *)
  Repeat
    Send (SOH);
    Send (#0);
    Send (#$FF);
    SendBlk (Seg (Sector [0] ), Ofs (Sector [0] ), 128);
    crc := 0;
    crca (Sector, SizeOf (Sector), crc);
    Send (Chr (Hi (crc) ) );
    Send (Chr (Lo (crc) ) );
    PurgeLine;
  Until (readline (10) = Ord (ACK) );
  
  blocknum := 1;
  Str ( (FileSize (f) Div 1024): 5, temp);
  WriteLn ('File open:' + temp + ' records.');
  Repeat
    counter := 0;
    FillChar (block, SizeOf (block), CPMEOF);
    {$I-} BlockRead (f, block, SizeOf (block), result); {$I+}
    If IOResult <> 0 Then
    Begin
      WriteLn ('Error Reading File: CANCELLED');
      FOS. Send (CAN);
      FOS. Send (CAN);
      Exit;
    End;
    Repeat
      Write (cr, 'Sending block: ', blocknum);
      Send (STX);
      Send (Chr (blocknum) );
      Send (Chr ( - blocknum - 1) );
      SendBlk (Seg (block [0] ), Ofs (block [0] ), 1024);
      crc := 0;
      Crca (block, SizeOf (block), crc);
      Send (Chr (Hi (crc) ) );
      Send (Chr (Lo (crc) ) );
      PurgeLine;
      Inc (counter);
    Until (readline (10) = Ord (ACK) ) Or (counter = retrymax);
    Inc (blocknum);
  Until EoF (f) Or (counter = retrymax) Or (Not Carrier);
  
  If counter = retrymax Then
    WriteLn (CR, LF, 'No ACK on sector')
  Else
  Begin
    counter := 0;
    Repeat
      Send (EOT);
      Inc (counter);
    Until (readline (10) = Ord (ACK) ) Or (counter = retrymax);
    If counter = retrymax Then
      WriteLn (CR, LF, 'No ACK on EOT')
    Else WriteLn (CR, LF, 'Transfer complete');
  End;
  
  (*  Send a null header block to signify end of transfer! *)
  counter := 0;
  Repeat
    FillChar (Sector, SizeOf (Sector), Chr (0) );  { NULL := CHR(0) }
    Send (SOH);
    Send (#$00);
    Send (#$FF);
    SendBlk (Seg (Sector [0] ), Ofs (Sector [0] ), 128);
    crc := 0;
    crca (Sector, SizeOf (Sector), crc);
    Send (Chr (Hi (crc) ) );
    Send (Chr (Lo (crc) ) );
    Inc (counter);
  Until (Readline (10) = Ord (ACK) ) Or (counter = retrymax);
End;


(*  
    PROCEDURE PackDateAndTime(var pd : date; dt : DateTime);
    { Returns the number of seconds since 00:00:00 01/01/1970 }
    CONST TDays : array[boolean,0..12] of word =
           ((0,31,59,90,120,151,181,212,243,273,304,334,365),
           (0,31,60,91,121,152,182,213,244,274,305,335,366));
          diff  = 347155200;
    VAR total,
        temp   : date;
        lyr    : boolean;
    BEGIN
       lyr := (((dt.year mod 4 = 0) and (dt.year mod 100 <>0))
              or (dt.year mod 400 = 0));
       dec(dt.year,1981);
       total := date(dt.sec) + (dt.min * 60) + (date(dt.hour) * 3600);
       temp := date(dt.year) * word(365) + (dt.year div 4);
       inc(temp,TDays[lyr][dt.month-1]);
       inc(temp,dt.day-1);
       pd := total + (temp * 86400) + diff;
    END;  {PackDateAndTime}

    crc := 0;
    crca(block, SizeOf(block), crc);
    Send(CHR(Hi(crc)));
    Send(CHR(Lo(crc)));
    BlockCRC(Seg(block),Ofs(block),1023);
    Send(CHR(Hi(crc_reg_hi)));
    Send(CHR(Lo(crc_reg_hi)));

    BlockCRC(Seg(sector[0]),ofs(sector[0]),127);
    Send(CHR(Hi(crc_reg_hi)));
    Send(CHR(Lo(crc_reg_hi)));

           {FOR j := 0 TO 1023 do begin
               Send(block[j]);
               updcrc(tcrc,block[j]);
           end;
           }
*)

Function SEND1KXMODEM ( Var f : File ) : Boolean;
Var block  : Array [0..1023] Of Byte;
  temp   : String [5];
  result : Word;
  counter,
  blocknum,
  j     : Integer;
Begin
  blocknum := 1;
  Str ( (FileSize (f) Div 1024): 5, temp);
  WriteLn (#13 + #10'File open:' + temp + ' records.');
  Repeat
    counter := 0;
    FillChar (block, SizeOf (block), CPMEOF);
    {$I-} BlockRead (f, block, SizeOf (block), result); {$I+}
    If IOResult <> 0 Then
    Begin
      WriteLn ('Error Reading File: CANCELLED');
      Send (CAN);
      Send (CAN);
      Exit;
    End;
    Repeat
      Write (cr, 'Sending block: ', blocknum);
      Send (STX);                              {  Send(SOH);     }
      Send (Chr (blocknum) );
      Send (Chr ( - blocknum - 1) );                 { (-blocknum-1)); }
      For j := 0 To 1023 Do Send (Chr (block [j] ) );
      crc := 0;
      crca (block, 1024, crc);
      Send (Chr (Hi (crc) ) );
      Send (Chr (Lo (crc) ) );
      PurgeLine;
      Inc (counter);
      { ch := readline(10);  write('ch:',ch,#7); }
    Until (readline (10) = Ord (ACK) ) Or (counter = retrymax);
    Write (COUNTER);
    Inc (blocknum);
  Until EoF (f) Or (counter = retrymax) Or (Not FOS. Carrier);
  If counter = retrymax Then
    WriteLn (cr, lf, 'No ACK on sector')
  Else
  Begin
    counter := 0;
    Repeat
      Send (EOT);
      Inc (counter);
    Until (readline (10) = Ord (ACK) ) Or (counter = retrymax);
    If counter = retrymax Then
      WriteLn (cr, lf, 'No ACK on EOT')
    Else WriteLn (cr, lf, 'Transfer complete');
  End;
End;


{====================================================================
 UPLOAD DISPATCHER
 ====================================================================}
Function UPLOAD (fname: String; using: protocols): Boolean;
Var result   : Boolean;
  workfile : File;
  sizeoffile : LongInt;
  elapsed  : Word;
Begin
  result := False;
  Assign (workfile, fname);
  {$I-} Reset (workfile, 1); {$I+}
  If IOResult <> 0 Then
    errorcode := 7
  Else
  Begin
    tickstart := systicks / 18.23;
    sizeoffile := FileSize (workfile);
    Case using Of
      {Ascii       : result := SendAscii(fname);}
      XmodemChkSum : result := SendXmodem ( workfile );
      XmodemCRC    : result := SendXmodemCRC ( workfile );
      Xmodem1K     : result := Send1KXmodem ( workfile );
      Ymodem       : result := SendYmodem (fname, workfile );
      Else
        Write ('Protocol currently unavailable!', #7);
    End;
    Close (workfile);
    Upload  := result;
    elapsed := Trunc (Eltime ( tickstart, (systicks / 18.23) ) );
    WriteLn ('Elapsed Seconds: ', elapsed );
    cps     := sizeoffile / elapsed;
    WriteLn ('Cps: ', cps: 7: 2)
  End;
End;


{==========================================================================
  Receive protocols and dispatcher follow
===========================================================================}
Function recvascii (fname: String) : Boolean;
Var  lc, rc: Char;
  textfile : Text;
Begin
  recvascii := False;
  lc := ' ';
  rc := ' ';
  Assign (textfile, fname);
  {$I-} Reset (textfile); {$I+}
  If (IOResult = 0) Then Begin
    Close (textfile);
    errorcode := 6;
    Exit;
  End;
  Rewrite (textfile);
  SendText ('Ends on Ctrl-Z, Abort with Ctrl-X');
  WriteLn ('Type ^X to exit ASCII receive');
  Repeat
    If SerialChar Then rc := Receive;
    If KeyPressed Then lc := ReadKey;
    Write (textfile, rc);
  Until (rc = ^Z) Or (rc = ^X) Or (lc = #27) Or (Not Carrier);
  Close (textfile);
  If rc = ^Z Then Begin
    errorcode := 0;
    recvascii := True;
    Exit;
  End;
  If rc = ^X Then errorcode := 1
  Else If lc = #27 Then errorcode := 2
  Else If Not carrier Then errorcode := 3;
  Erase (textfile);
End;


Function RecvXmodem (fname: String) : Boolean;
Var j,
  firstchar,
  sectornum,
  sectorcurrent,
  sectorcomp,
  errors,
  checksum  : Integer;
  errorflag : Boolean;
  c         : Char;
  workfile  : File;
  
Begin
  RecvXmodem := False;
  Assign (workfile, fname);
  Rewrite (workfile);
  If IOResult <> 0 Then Begin
    errorcode := 6;
    Exit;
  End;
  sectornum := 0;
  errors := 0;
  send (NAK);
  send (NAK);                       (* send ready characters *)
  Repeat
    errorflag := False;
    Repeat
      firstchar := readline (20);
    Until ( (firstchar In [Ord (SOH), Ord (EOT) ] ) Or
          (firstchar = timeout) ) Or (Not Carrier);
    If Not Carrier Then Begin
      errorcode := 3;
      Exit;
    End;
    If firstchar = timeout Then WriteLn (cr, lf, 'Error - No starting SOH');
    If firstchar = Ord (SOH) Then Begin
      sectorcurrent := Readline (1);      {real sector number}
      sectorcomp    := Readline (1);      {+ inverse of above}
      If (sectorcurrent + sectorcomp) = 255 Then Begin {< becomes this #}
        If (sectorcurrent = sectornum + 1) Then Begin
          checksum := 0;
          ReadBlk (Seg (Sector [0] ), Ofs (Sector [0] ), 128);
          For j := 0 To lastbyte Do 
            checksum := (checksum + Sector [j] ) Mod 256;
          If checksum = Readline (1) Then Begin
            BlockWrite (WorkFile, Sector, 1);
            errors := 0;
            sectornum := sectorcurrent;
            Write (cr, 'Received sector ', sectorcurrent);
            send (ACK)
          End Else Begin
            WriteLn (cr, lf, 'Checksum error');
            errorflag := True
          End
        End Else If (sectorcurrent = sectornum) Then Begin
          Repeat
          Until Readline (1) = timeout;
          WriteLn (cr, lf, 'Received duplicate sector ', sectorcurrent);
          Send (ack)
        End Else Begin
          WriteLn (cr, lf, 'Synchronization error');
          errorflag := True
        End
      End Else Begin
        WriteLn (cr, lf, 'Sector number error');
        errorflag := True
      End
    End;
    If errorflag Then Begin
      Inc (errors);
      Repeat Until Readline (1) = timeout;
      send (nak)
    End;
  Until ( (firstchar = Ord (EOT) ) Or (firstchar = timeout) ) Or
        (errors = errormax) Or (Not Carrier);
  
  If (firstchar = Ord (EOT) ) And (errors < errormax) Then Begin
    send (ack);
    WriteLn (cr, lf, 'Transfer complete');
    errorcode := 0; recvxmodem := True;
  End Else If (errors > errormax) Then Begin
    WriteLn (cr, lf, 'Aborting');
    errorcode := 1;
  End Else If Not carrier Then Begin
    errorcode := 3;
  End;
End;


{====================================================================
 DOWNLOAD DISPATCHER
 ====================================================================}
Function DownLoad (fname: String; using: protocols): Boolean;
Var result : Boolean;
Begin
  result := False;
  Case using Of
    ascii : result := RecvAscii (fname);
    xmodemchksum : result := RecvXmodem (fname);
    {
    xmodemcrc     : result := RecvXmodemCRC(fname);
    }
    Else
      Write ('protocol currently unavailable');
  End;
  DownLoad := result;
End;

{ initialization code }
Begin
  CheckBreak := False;
End.
