{$A+,B-,D-,E-,F+,G+,I-,L-,N-,O+,R-,S-,V-,X+}
{$M 16384,0,655360}
Unit PibTimer;

Interface

Uses
  DOS, GlobType;

   Function TimeOfDay : LongInt;
   Function TimeDiff ( Timer1, Timer2: LongInt ) : LongInt;

   Function TimeOfDayH : LongInt;
   Function TimeDiffH ( Timer1, Timer2: LongInt ) : LongInt;

Implementation

{--------------------------------------------------------------------------}
{                TimeOfDay  --- Get time of day                            }
{--------------------------------------------------------------------------}

Function TimeOfDay : LongInt;

{--------------------------------------------------------------------------}
{     Function:  TimeOfDay                                                 }
{     Purpose:   Gets time of day from internal clock                      }
{     Calling sequence:                                                    }
{        Tod := TimeOfDay : LONGINT;                                       }
{           Tod --- Long integer number which is timer value expressed in  }
{                   seconds as:                                            }
{                   ( 3600 x hour + 60 x minutes + seconds )               }
{     Calls:  GetTime                                                      }
{--------------------------------------------------------------------------}

Var
  Hours   : Word;
  Minutes : Word;
  Seconds : Word;
  SecHun  : Word;
  TimeVal : LongInt;
  
Begin { TimeOfDay }
  GetTime ( Hours, Minutes, Seconds, SecHun );
  TimeVal    := Hours;
  TimeOfDay  := TimeVal * 3600 + Minutes * 60 + Seconds;
End   { TimeOfDay } ;

{--------------------------------------------------------------------------}
{        TimeDiff  --- Get difference in time between two timer values     }
{--------------------------------------------------------------------------}

Function TimeDiff ( Timer1, Timer2: LongInt ) : LongInt;

{--------------------------------------------------------------------------}
{     Function:  TimeDiff                                                  }
{     Purpose:   Get difference in time between two timer values in        }
{                seconds.                                                  }
{     Calling sequence:                                                    }
{        TDiff := TimeDiff( Timer1, Timer2: LONGINT ) : LONGINT;           }
{           Timer1  --- first timer value (earlier)                        }
{           Timer2  --- second timer value (later)                         }
{           TDiff   --- difference between timer values                    }
{     Calls:  None                                                         }
{     Remarks:                                                             }
{        This routine will handle time wrap around midnight.  However, it  }
{        only handles timer values <= 24 hours in duration.                }
{--------------------------------------------------------------------------}

Const
  Secs_Per_Day = 86400    { Seconds in one day } ;
  
Var
  TDiff : LongInt;
  
Begin { TimeDiff }
  TDiff := Timer2 - Timer1;
  If ( TDiff < 0 ) Then TDiff := TDiff + Secs_Per_Day;
  TimeDiff := TDiff;
End   { TimeDiff } ;

{--------------------------------------------------------------------------}
{      TimeOfDayH  --- Get time of day in 1/100 seconds from midnight      }
{--------------------------------------------------------------------------}

Function TimeOfDayH : LongInt;

{--------------------------------------------------------------------------}
{     Function:  TimeOfDayH                                                }
{     Purpose:   Gets time of day from internal clock in 1/100 seconds     }
{     Calling sequence:                                                    }
{        Tod := TimeOfDayH : LONGINT;                                      }
{           Tod --- Real number which is timer value expressed in          }
{                   hundredths of seconds as:                              }
{                   ( 360000 x hour + 6000 x minutes + 100 x seconds +     }
{                     hundredths of seconds ).                             }
{     Calls:  GetTime                                                      }
{--------------------------------------------------------------------------}

Var
  Hours   : Word;
  Minutes : Word;
  Seconds : Word;
  SecHun  : Word;
  TimerVal: LongInt;
  
Begin { TimeOfDayH }
  GetTime ( Hours, Minutes, Seconds, SecHun );
  TimerVal    := Hours;
  TimeOfDayH  := TimerVal * 360000 + Minutes * 6000 + Seconds * 100 + SecHun;
End   { TimeOfDayH } ;

{--------------------------------------------------------------------------}
{       TimeDiffH  --- Get difference in time between two timer values     }
{--------------------------------------------------------------------------}

Function TimeDiffH ( Timer1, Timer2: LongInt ) : LongInt;

{--------------------------------------------------------------------------}
{     Function:  TimeDiffH                                                 }
{     Purpose:   Get difference in time between two timer values           }
{                in hundredths of seconds.                                 }
{     Calling sequence:                                                    }
{        Tdiff := TimeDiffH( Timer1, Timer2: LONGINT ) : REAL;             }
{           Timer1  --- first timer value (earlier)                        }
{           Timer2  --- second timer value (later)                         }
{           Tdiff   --- difference between timer values                    }
{     Calls:  None                                                         }
{     Remarks:                                                             }
{        This routine will handle time wrap around midnight.  However, it  }
{        only handles timer values <= 24 hours in duration.                }
{--------------------------------------------------------------------------}

Const
  Hundredths_Secs_Per_Day = 8640000    { 1/100 Seconds in one day } ;
  
Var
  TDiff : LongInt;
  
Begin { TimeDiffH }
  TDiff := Timer2 - Timer1;
  If Tdiff < 0 Then Tdiff := Tdiff + Hundredths_Secs_Per_Day;
  TimeDiffH := Tdiff;
End   { TimeDiffH } ;

End { PibTimer } .
