{$A+,B-,D-,E-,F+,G+,I-,L-,N-,O+,R-,S-,V-,X+}
{$M 16384,0,655360}

Unit PibAsync;

{----------------------------------------------------------------------}
{         PIBASYNC.PAS   --- Asynchronous I/O for Turbo Pascal         }
{----------------------------------------------------------------------}
{  Author:  (c) 1985, 1986, 1987, 1988 by Philip R. Burns              }
{  Version: 4.7   (May, 1988)                                          }
{  Systems: For MSDOS/PC DOS on IBM PCs and close compatibles only.    }
{  History: Some of these routines are based upon ones written by:     }
{              Alan Bishop                                             }
{              C. J. Dunford                                           }
{              Michael Quinlan                                         }
{              Gene Harris                                             }
{           I have cleaned up these other authors' code, fixed some    }
{           bugs, and added many new features.                         }
{           In particular, starting with v4.0 of PibTerm, both input   }
{           and output to the serial port is buffered and interrupt-   }
{           driven.  Also, XON/XOFF support has been moved to the      }
{           serial port interrupt handler, which results in fewer      }
{           overrun problems.                                          }
{           Suggestions for improvements or corrections are welcome.   }
{           If you use this code in your own programs, please be nice  }
{           and give proper credit.                                    }
{----------------------------------------------------------------------}
{  Routines:                                                           }
{     BIOS_RS232_Init        ---    Use BIOS to initialize port        }
{     Async_Isr              ---    Com port interrupt service routine }
{     Async_Init             ---    Performs initialization.           }
{     Async_Clear_Errors     ---    Clear pending serial port errors   }
{     Async_Reset_Port       ---    Resets UART parameters for port    }
{     Async_Open             ---    Sets up COM port                   }
{     Async_Close            ---    Closes down COM port               }
{     Async_Carrier_Detect   ---    Checks for modem carrier detect    }
{     Async_Carrier_Drop     ---    Checks for modem carrier drop      }
{     Async_Buffer_Check     ---    Checks if character in COM buffer  }
{     Async_Term_Ready       ---    Toggles terminal ready status      }
{     Async_Find_Delay       ---    Find busy wait count for 1ms delay }
{     Async_Receive          ---    Reads character from COM buffer    }
{     Async_Receive_With_Timeout                                       }
{                            ---    Receives char. with timeout check  }
{     Async_Ring_Detect      ---    If ringing detected                }
{     Async_Send             ---    Transmits char over COM port       }
{     Async_Send_String      ---    Sends string over COM port         }
{     Async_Send_String_With_Delays                                    }
{                            ---    Sends string with timed delays     }
{     Async_Send_Break       ---    Sends break (attention) signal     }
{     Async_Percentage_Used  ---    Returns percentage com buffer used }
{     Async_Purge_Buffer     ---    Purges receive buffer              }
{     Async_Release_Buffers  ---    Free memory for serial port queues }
{     Async_Set_Rejection    ---    Set noise rejection processing     }
{     Async_Setup_Port       ---    Define port base, IRQ, RS232 addr  }
{     Async_Stuff            ---    Insert char into receive buffer    }
{     Async_Flush_Output_Buffer                                        }
{                            ---    Flush serial port output buffer    }
{     Async_Drain_Output_Buffer                                        }
{                            ---    Wait for serial output to drain    }
{     Async_Port_Address_Given                                         }
{                            ---    Check if port address installed    }
{     Async_Send_Now         ---    Send character without buffering   }
{     Async_Wait_For_Quiet   ---    Wait for port to quiesce           }
{----------------------------------------------------------------------}
{      PIBASYNC.PAS was split into PIBASYN1.PAS and PIBASYN2.PAS at    }
{      version 3.2 of PibTerm, and into PIBASYN1, PIBASYN2, and        }
{      PIBASYN3 for v4.0 of PibTerm.   The UNIT structure was added    }
{      for use with Turbo Pascal v4.0.                                 }
{----------------------------------------------------------------------}

Interface
                                   { Uncomment PibMTask if the    }
                                   { multitasking interface is to }
                                   { be used.                     }
Uses
  DOS, Crt, GlobType, PibTimer{, PibMTask} ;

{I PIBASYNC.GLO }

Procedure BIOS_RS232_Init ( ComPort : Integer; ComParm : Word );
Procedure Async_Close ( Drop_DTR: Boolean );
Procedure Async_Clear_Errors;
Procedure Async_Reset_Port ( ComPort       : Integer;
                            BaudRate      : Word;
                            Parity        : Char;
                            WordSize      : Integer;
                            StopBits      : Integer  );
Function  Async_Open ( ComPort       : Integer;
                      BaudRate      : Word;
                      Parity        : Char;
                      WordSize      : Integer;
                      StopBits      : Integer  ) : Boolean;
Procedure Async_Send ( C : Char );
Function Async_Receive ( Var C : Char ) : Boolean;
Procedure Async_Receive_With_Timeout ( Secs : Integer; Var C : Integer );
Procedure Async_Stuff ( CH: Char );
Procedure Async_Find_Delay ( Var One_MS_Delay : Integer );
Procedure Async_Init ( Async_Buffer_Max  : Integer;
                      Async_OBuffer_Max : Integer;
                      Async_High_Lev1   : Integer;
                      Async_High_Lev2   : Integer;
                      Async_Low_Lev     : Integer );
Function  Async_Carrier_Detect : Boolean;
Function  Async_Carrier_Drop : Boolean;
Procedure Async_Term_Ready ( Ready_Status : Boolean );
Function  Async_Buffer_Check : Boolean;
Function  Async_Line_Error ( Var Error_Flags: Byte ) : Boolean;
Function  Async_Ring_Detect : Boolean;
Procedure Async_Send_Break;
Procedure Async_Send_String ( S : AnyStr );
Procedure Async_Send_String_With_Delays ( S          : AnyStr;
                                         Char_Delay : Integer;
                                         EOS_Delay  : Integer  );
Function  Async_Percentage_Used : Real;
Procedure Async_Purge_Buffer;
Function  Async_Peek ( Nchars : Integer ) : Char;
Procedure Async_Setup_Port ( ComPort       : Integer;
                            Base_Address  : Integer;
                            IRQ_Line      : Integer;
                            Int_Numb      : Integer );
Procedure Async_Release_Buffers;
Procedure Async_Flush_Output_Buffer;
Procedure Async_Drain_Output_Buffer ( Max_Wait_Time : Integer );
Function  Async_Port_Address_Given ( Com_Port : Integer ) : Boolean;
Procedure Async_Send_Now ( C : Char );
Function  Async_Wait_For_Quiet ( Max_Wait : LongInt;
                                Wait_Time: LongInt  ) : Boolean;
Procedure Async_Set_Rejection ( Reject_Bad : Boolean; Reject_Char : Char );

Implementation
{ $DEFINE MTASK}
{$I PIBASYN1.MOD }
{$I PIBASYN2.MOD }
{$I PIBASYN3.MOD }

Begin { PibAsync }
  { Default communications parameters }
  Async_Do_CTS         := False;
  Async_Do_DSR         := False;
  Async_Hard_Wired_On  := False;
  Async_Break_Length   := 500;
  Async_Do_XonXoff     := True;
  Async_OV_XonXoff     := True;
  Async_Buffer_Length  := 4096;
  Async_OBuffer_Length := 1132;
  Async_Reject_Noise   := False;
  Async_Noise_Char     := Chr ( 0 );
  { Port addresses of each com port }
  Default_Com_Base [1]  := COM1_Base;
  Default_Com_Base [2]  := COM2_Base;
  Default_Com_Base [3]  := COM3_Base;
  Default_Com_Base [4]  := COM4_Base;
  { IRQ line for each port }
  Default_Com_Irq [1]  := COM1_Irq;
  Default_Com_Irq [2]  := COM2_Irq;
  Default_Com_Irq [3]  := COM3_Irq;
  Default_Com_Irq [4]  := COM4_Irq;
  { Pick up address of send-a-character }
  { routine, which is used by INLINE code.   }
  Async_Send_Addr := Addr ( Async_Send );
End   { PibAsync } .
