(*
**  Folder.Inc (FrontDoor)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  FOLDER.FD definitions for FrontDoor 2.00+
**
**  Last revision:  91-10-02
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)

(*
**  Constant long bit values
*)
CONST
  RESTRICT  = $00000001;
  ECHO_INFO = $00000002;
  EXPORT_OK = $00000004;
  USE_XLAT  = $00000008;
  PRIVATE   = $00000010;
  READONLY  = $00000020;
  NETMAIL   = $08000000;                              (* Commercial version *)
  QUICKBBS  = $10000000;                             (* Hudson-style folder *)
  DELETED   = $20000000;                           (* Never written to disk *)
  LOCAL     = $40000000;
  ECHOMAIL  = $80000000;


(*
**  User access mask
*)
  USER_1    = $00000001;
  USER_2    = $00000002;
  USER_3    = $00000004;
  USER_4    = $00000008;
  USER_5    = $00000010;
  USER_6    = $00000020;
  USER_7    = $00000040;
  USER_8    = $00000080;
  USER_9    = $00000100;
  USER_10   = $00000200;


(*
**  Folder structure
**
**  The "path" and "title" fields below are NUL terminated.
*)
TYPE
  FolderRec = RECORD
    Path    : Array[1..65] of char;  (* Path if "board==0", otherwise emtpy *)
    Title   : Array[1..41] of char;            (* Title to appear on screen *)
    Origin  : byte;                            (* Default origin line, 0-19 *)
    Flags,                                           (* Behavior, see above *)
    PwdCrc,                      (* CRC32 of password or -1L if unprotected *)
    UserOK  : longint;                         (* Users with initial access *)
    UseAKA  : byte;                               (* AKA to use, 0==primary *)
    Board   : word;                     (* Hudson-message base board number *)
  End;

(* end of file "Folder.Inc" *)
