(*
**  Event.Inc (FrontDoor)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  EVENT.FD definitions for FrontDoor 2.00+
**
**  Last revision:  91-10-02
**                            
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)

(*
**  Day values, non-exclusive bit values
**
**  I.e. If the event was active on Monday and Tuesday, the day field
**       would contain $03. If the event is active on all days, the
**       day field should only contain $80.
*)
CONST
  MONDAY      = $01;
  TUESDAY     = $02;
  WEDNESDAY   = $04;
  THURSDAY    = $08;
  FRIDAY      = $10;
  SATURDAY    = $20;
  SUNDAY      = $40;
  ALL         = $80;


(*
**  Behavior, non-exclusive bit values
**
**  I.e. If an event had FREQ_OK and DO_PICKUP enabled, the behavior field
**       would be $00000018.
**
**       Ignore the "ifndef" directive below, it's only used when I compile
**       FDSETUP.EXE on my system.
*)
  USERS_OK    = $00000001;                 (* Allow users to interrupt event*)
  MAIL_EXIT   = $00000002;                     (* Exit when mail is received*)
  CRASH_ONLY  = $00000004;                           (* Only send Crash mail*)
  FREQ_OK     = $00000008;                    (* Honor inbound file requests*)
  DO_PICKUP   = $00000010;              (* Pickup mail during outbound calls*)
  ALLOW_PICKUP= $00000020;             (* Allow calling nodes to pickup mail*)
  SEND_ONLY   = $00000040;            (* Send only, don't wait between calls*)
  RECV_ONLY   = $00000080;             (* Receive only, don't make any calls*)
  FORCED      = $00000100;           (* Event is forced and MUST be executed*)
  ENDNOMAIL   = $00000200;           (* End event when no more outgoing mail*)
  SENDTOCM    = $00000400;                        (* Send to CM systems only*)
  SENDTONOCM  = $00000800;                    (* Send to non-CM systems only*)
  ONLYONCE    = $00001000;             (* Only call a node once during event*)
  PICKUPFREQ  = $00002000;          (* Honor file requests on outbound calls*)
  HOLDFREQ    = $00004000;          (* Don't send file requests during event*)

  (* .. gap .. *)

  DELETED     = $40000000;                          (* Never written to disk*)
  INACTIVE    = $80000000;


(*
**  The first record in EVENT.FD must be the EVENTBASE and have the tag
**  field set to '@'.
*)
TYPE
  EventRec    = RECORD
    Tag       : char;                        (* Event tag A-Z (X==External) *)
    Day       : byte;      (* Days to execute event on, non-exclusive value *)
    Modifier  : char;   (* '-'=Subtract, '+'= Add, '*'= Don't use eventbase *)
    StartHr,                               (* Starting hour, 24 hour format *)
    StartMin,                                            (* Starting minute *)
    LengthHr,                             (* Length (hours), 24 hour format *)
    LengthMin,                                           (* Length (minute) *)
    Level     : byte;    (* Errorlevel on X-events, ignored on non-X events *)
    Behavior  : longint;             (* Event behavior, non-exclusive value *)
    Cost,                  (* Maxmium cost of mail to go out, -1 don't care *)
    LastRun   : integer;              (* Packed DOS date when last executed *)
    Reserved1 : byte;
    Timer,                    (* Delay between calls in seconds, 0==Default *)
    MinCost   : word;                (* Minimum cost for messages to go out *)
    Reserved2 : byte;
  End;

(* end of file "Event.Inc" *)
