(*
**  ctl.inc (FrontDoor)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  SETUP.FD definitions for FrontDoor 2.00+
**
**  Last revision:  91-10-02
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)

(* Mailer ----------------------------------------------------------------- *)

(* --- Loglevels *)

CONST
  LOGFATAL    = $0001;                                    (* ! Fatal errors *)
  LOGERROR    = $0002;                                          (* ? Errors *)
  LOGBRIEF    = $0004;                         (* + Major changes in action *)
  LOGACCT     = $0008;                          (* $ Accounting information *)
  LOGXFER     = $0010;                             (* * Sent/Received files *)
  LOGTRIVIAL  = $0020;                         (* - Minor changes in action *)
  LOGXFERMSG  = $0040;                               (* % Transfer messages *)
  LOGMODEM    = $0080;                      (* = Modem activities/responses *)
  LOGTRX      = $0100;                     (* : Session transaction numbers *)
  LOGSESSION  = $0200;                      (* ~ Session stuff, SysOp, etc. *)
  LOGRMTAKAS  = $0400;                            (* ~ Remote system's AKAs *)
  LOGRMTINFO  = $0800;                     (* ~ Remote system's information *)
  LOGUNEXPECT = $1000;                             (* # Unexpected password *)
  LOGDEBUG    = $8000;                             (* All loglevels enabled *)

(* --- Miscellaneous MAILER flags *)

  NOUNLISTED      = $00000001;              (* Don't allow unlisted systems *)
  CREATE_BATCH    = $00000002;          (* Create batchfile when BBS caller *)
  TERMONLY        = $00000004;                  (* Running as Terminal-Only *)
  DTR_HANGUP      = $00000008;                         (* Use DTR to hangup *)
  DTR_DIAL        = $00000010;               (* Toggle DTR prior to dialing *)
  DTR_BUSY        = $00000020;                    (* Use DTR to signal BUSY *)
  MANUAL_ANSWER   = $00000040;                         (* Use manual answer *)
  CONNECT_RESET   = $00000080;              (* Reset modem to connect speed *)
  MODEM_FIXED     = $00000100;          (* Use constant speed against modem *)
  NOMAIL_NOPWD    = $00000200;            (* No mail from unsecured systems *)
  DELAYFIRST      = $00000400;                   (* Delay before first call *)
  CLOCK           = $00000800;                             (* Display clock *)
  KILLNULL        = $00001000;              (* Remove messages with no text *)
  MAILONLY        = $00002000;                 (* Don't allow human callers *)
  LIMITED_ANSWER  = $00004000;                   (* Limited hours to answer *)
  EXIT_NETMAIL    = $00008000;                (* Exit when netmail received *)
  ZONE_ADAPTION   = $00010000;                 (* Adopt called/calling zone *)
  PRINTNEWMSGS    = $00020000;                   (* Print received messages *)
  NOUNKNOWNPOINTS = $00040000;              (* Don't accept unlisted points *)
  FORCEDCARRIER   = $00080000;          (* Carrier is forced. Ring required *)
  NULLMODEM       = $00100000;             (* Initiate session when CD high *)
  MAILER43LINES   = $00200000;             (* Use 43/50 line mode in mailer *)
  SWAPTOEMSDISK   = $00400000;         (* Swap file to LIM/EMS/DISK w/shell *)
  MAILEREMSOK     = $00800000;           (* If EMS can be used for swapping *)
  PRESENTAKAS     = $01000000;         (* Present AKAs during EMSI sessions *)
  NOBLINKMAIL     = $02000000;         (* Don't flash the waiting mail sign *)
  EXITONANYFILE   = $04000000;         (* Exit after ANY data has been rcvd *)
  MAILERAUTOLINES = $08000000;         (* Use whatever screen mode is there *)
  HONOR_RRQ       = $10000000;                                 (* Honor RRQ *)
  NO_TIMESTAMP    = $20000000;          (* Don't show timestamp in window-1 *)
  MAILERCUSTOMCRT = $40000000;                  (* User-defined screen size *)

(* --- Audio flags *)

  CLOCKNOISE      = $0001;                       (* Tic-tac-tic-tac-tic-tac *)
  INMAILNOISE     = $0002;                             (* Unpacked any mail *)
  INCRASHNOISE    = $0004;              (* Unpacked crash or immediate mail *)
  INCONNECTNOISE  = $0008;                  (* Incoming MAIL call (connect) *)
  INCALLERNOISE   = $0010;              (* Incoming human caller passed >BBS*)
  MAILWAITING     = $0020;                               (* Mail is waiting *)
  OUTMAILNOISE    = $0040;                     (* Sent mail (after session) *)
  OUTCONNECTNOISE = $0080;                  (* Outgoing MAIL call (connect) *)
  ERRORNOISE      = $0100;                                        (* S.O.S. *)

(* --- Request types *)

  REQALL          = $01;                             (* Anybody can request *)
  REQNONE         = $02;                              (* No one can request *)
  REQLISTED       = $04;                             (* Only listed systems *)
  REQLIMITED      = $08;                                   (* Limited hours *)

(*--------------------------------------------------------------------------*)
  MAXKEY          = 24;

TYPE
  Arr11           = array[1..11] of Char;
  Arr16           = array[1..16] of Char;
  Arr26           = array[1..26] of Char;
  Arr31           = array[1..31] of Char;
  Arr40           = array[1..40] of Char;
  Arr41           = array[1..41] of Char;
  Arr50           = array[1..50] of Char;
  Arr61           = array[1..61] of Char;
  Arr71           = array[1..71] of Char;

(*--------------------------------------------------------------------------*)

  MailRec         = RECORD

    (* --- The logfile *)

    Log           : Arr71;
    LogLevel      : word;                              (* See --- Loglevels *)

    (* ---  Telephone number manipulation *)

    Prefix        : Arr31;                                  (* Always added *)
    Hidden        : array[1..10] of Arr31;           (* Strip these if in # *)
    PostFix       : Arr31;                               (* Always appended *)

    (* --- Miscellaneous flags *)

    Flags         : longint;                 (* See --- Miscellaneous flags *)
    Flags_Reserved: longint;                              (* Reserved flags *)
    Audio         : word;                            (* See --- Audio flags *)
    SynchTimer    : byte;                     (* Number of seconds for sync *)

    (* --- Errorlevels *)

    CrashExit,                                                 (* Mail exit *)
    bbs300,
    bbs1200,
    bbs1275,
    bbs2400,
    bbs4800,
    bbs9600,
    bbs19200,
    bbs38400      : byte;

    (* --- Modem *)

    ModemBaud     : word;                          (* 30=300, 24=2400, etc. *)
    ModemPort,                              (* 1-255 (COM1=1, COM2=2, etc.) *)
    ModemDelay    : byte;                 (* 1/10 seconds delay / line sent *)

    (* --- Messages *)

    b300msg,
    b1200msg,
    b1275msg,
    b2400msg,
    b4800msg,
    b9600msg,
    b19200msg,
    b38400msg,
    ErrorMsg,
    BusyMsg,
    NoCarrierMsg,
    OkMsg,
    RingMsg,
    NodialMsg,
    NoAnswerMsg,
    VoiceMsg      : Arr16;

    (* --- Commands *)

    EscapeStr,
    OffhookStr,
    ReconnectStr  : Arr11;
    Init1,
    Init2,
    Init3,
    ResetStr,
    DownStr       : Arr50;
    HangupStr,
    DialStr       : Arr11;

    (* --- Manual answer stuff *)

    OldModemAnswer: Arr11;                              (* Not used anymore *)
    AnswerDelay   : byte;

    (* --- Limited answer start and end times *)

    Begin_Hour,
    Begin_Minute,
    End_Hour,
    End_Minute    : byte;

    (* --- Calling control *)

    RetryBusy,
    RetryResend,
    RetryDelay    : byte;

    (* --- File request control *)

    reqlist,                               (* List to scan for reqable dirs *)
    reqalias,                                            (* Magic filenames *)
    reqmessage    : Arr71;            (* Appended to FAILED REQUEST message *)
    reqtype,                                                   (* Bit field *)
    reqmaxfiles   : byte;           (* Max number of files to send on 1 req *)
    reqmaxtime,                        (* Maximum number of minutes for req *)
    reqmaxsize,                             (* Maximum size (in KB) for req *)
    reqminbaud    : word;                       (* Minimum baudrate for req *)
    reqstarthr,                     (* Start time for file requests, can be *)
    reqstartmin,                       (* - combined with the reqdays field *)
    reqendhr,
    reqendmin,              
    reqdays       : byte;           (* 7 6 5 4 3 2 1        $80==All days
                                       _ _ _ _ _ _ _
                                       : : : : : : :
                                       : : : : : : +--- Saturday
                                       : : : : : +----- Friday
                                       : : : : +------- Thursday
                                       : : : +--------- Wednesday
                                       : : +----------- Tuesday
                                       : +------------- Monday
                                       +--------------- Sunday              *)

    (* --- File to send when human callers are let thru *)

    BBSname       : Arr11;
    LoadBBSbanner : Arr71;

    (* Function keys from mailer menu *)
    (* --- F1-F12, Shift F1-F12       *)

    Key           : Array[1..MAXKEY] of RECORD
      Cmd         : Arr61;
      Title       : Arr26;
      Behavior    : byte;                    (* 1-Pause, 2-Process msg base *)
    End;

    (* --- Mailer colors *)

    Color         : RECORD
      Header,
      HiLite,
      Clock,
      DataEntry,
      Error,
      NormalText,
      Frame,
      WndwText,
      WndwFrame,
      WndwSelect,
      WndwHiLite  : byte;
    End;

    (* --- Number of days to keep entries in history files *)

    KeepHistory   : byte;

    (* --- FDServer password, if none given, server is INactive *)

    SlavePwd      : Array[1..21] of char;

    (* --- File displayed to users when system is in event for no callers *)

    InEventFile   : Arr71;

    (* --- File displayed when human callers are seen on mail-only system *)

    MailOnlyFile  : Arr71;

    (* --- External programs to run on certain "wake-up" strings *)

    ExternMail    : Array[1..10] of RECORD
      WakeUpStr   : Arr40;
      ErrorLevel  : byte;
    End;

    (* --- Limited audio start and end times. If the below four bytes
      are all zero (0), audio is enabled all the time *)

    AudioBeginHour,
    AudioBeginMin,
    AudioEndHour,
    AudioEndMin   : byte;

    (* --- Minimum cost to process undialable *)

    MinUnDialCost : word;

    (* --- Carrier detect mask (commercial version), default=128 *)

    CDmask        : byte;

    (* --- FDCD buffer sizes (commercial version) *)

    FossilOutBs,
    FossilInBs    : word;

    (* --- List to scan for SECURE sessions during file requests *)

    ReqSecList    : Arr71;

    (* --- Extended baud rate exits *)

    bbs7200,
    bbs12000,
    bbs14400      : byte;

    (* --- Custom screen size parameters to INT 10H (commercial version) *)

    SetCustomCRTax,
    SetCustomCRTbx,
    SetCustomCRTcx,
    SetCustomCRTdx,

    ResetCustomCRTax,
    ResetCustomCRTbx,
    ResetCustomCRTcx,
    ResetCustomCRTdx  : word;

    (* --- Alias List to scan for SECURE sessions *)

    ReqSecAlias   : Arr71;

    (* --- Command string to force modem to answer *)

    ModemAnswer   : Arr41;

    RESERVERAT    : Array[1..811] of Char;
  End;


(* Editor ------------------------------------------------------------------*)

CONST
  EDITOR43LINES   = $00000001;                       (* Use 43/50-line mode *)
  SHOWHARDCRS     = $00000002;          (* Display paragraph (hard CR) char *)
  EDITORSWAP      = $00000004;         (* Swap file to LIM/EMS/DISK w/shell *)
  EDITOREMSOK     = $00000008;         (* Whether or not EMS should be used *)
  EDITORAUTOLINES = $00000010;         (* Use whatever screen mode is there *)
  HONOR_CFM       = $00000020;                                 (* Honor CFM *)
  EDITORCUSTOMCRT = $00000040;                  (* User-defined screen size *)
  RKILL_NEVER_E   = $00000080;            (* Never ask "Delete Original?"-E *)
  RKILL_NEVER_L   = $00000100;            (* Never ask "Delete Original?"-L *)
  RKILL_NEVER_N   = $00000200;            (* Never ask "Delete Original?"-N *)
  USEZONEGATE_YES = $00000400;                (* Always use zone gate if OK *)
  USEZONEGATE_NO  = $00000800;           (* Never use zone gate, even if OK *)

(* --- Netmail folder behavior *)

  RESTRICTED      = $00000001;
  EXPORTOK        = $00000004;
  USEXLATTABLES   = $00000008;
  EDREADONLY      = $00000020;

  MAXORIGIN       = 20;


TYPE
  EditRec         = RECORD

    (* --- Macro keys *)
    (* F1-F12, Shift F1-F12 *)
    
    MacroKey      : Array[1..MAXKEY] of Arr61;

    (* --- Margin, default==60 *)

    Margin        : byte;

    (* --- Default message status *)

    MsgBits       : word;

    (* --- Miscellaneous settings *)

    Flags         : longint;

    (* --- Origin lines *)

    Origin        : Array[1..MAXORIGIN] of Arr61;

    (* --- Editor colors *)

    Color         : RECORD
      TopLine,
      StatusLine,
      Error,
      Text,
      TextQuotes,
      TextReverse,
      TextHardCRs,
      Header,
      HeaderData,
      HeaderDataHiLite,
      DataEntry,
      WndwFrame,
      WndwText,
      WndwSelect,
      WndwHiLite  : byte;
    End;

    (* --- Netmail folder flags *)

    NetBehave     : longint;

    (* --- Translation tables IN/OUT *)

    XlateIn,
    XlateOut      : Array[0..255] of Char;

    (* --- Where Hudson-style message base files are *)

    QBase         : Arr71;

    (* --- Custom screen size parameters to INT 10H (commercial version) *)

    SetCustomCRTax,
    SetCustomCRTbx,
    SetCustomCRTcx,
    SetCustomCRTdx,

    ResetCustomCRTax,
    ResetCustomCRTbx,
    ResetCustomCRTcx,
    ResetCustomCRTdx  : word;

    (* --- RESERVED *)

    Reserved      : Array[1..1008] of Char;
  End;


(* Shared data ------------------------------------------------------------- *)

CONST
  FASTKEY         = $00000001;
  FLICKER         = $00000002;
  BLACKOUT        = $00000004;
  HAVEEXTKBD      = $00000008;                (* Use extended INT 16H calls *)
  FORCE24HOUR     = $00000010;                 (* Force 24-hour time format *)

  SUPERUSER       = $00000001;                                (* User flags *)
  ADMINUSER       = $00000002;
  USER            = $00000004;
  BYPASSRO        = $00010000;
  BYPASSEXP       = $00020000;

  PROTECT_MEXIT   = $00000001;           (* Protect Alt-Q            Mailer *)
  PROTECT_MSHELL  = $00000002;           (* Protect Alt-Z            Mailer *)
  PROTECT_MKEYS   = $00000004;           (* Protect function keys    Mailer *)
  PROTECT_MFREQ   = $00000008;           (* Protect file requests    Mailer *)
  PROTECT_MXMIT   = $00000010;           (* Protect transmit         Mailer *)
  PROTECT_MSEND   = $00000020;           (* Protect send mail        Mailer *)
  PROTECT_MPOLL   = $00000040;           (* Protect poll             Mailer *)
  PROTECT_MNCOMP  = $00000080;           (* Protect FDNC             Mailer *)
  PROTECT_MQUEUE  = $00000100;           (* Protect mail queue       Mailer *)
  PROTECT_MPRN    = $00000200;           (* Protect printer toggle   Mailer *)

  MAXAKA          = 10;
  MAXUSER         = 10;

(*
**  Domain structure
*)
TYPE
  _DOMAIN         = RECORD
    Zone,                                                (* Zone for domain *)
    Reserved      : Word;
    Name          : Array[1..28] of Char;                 (* Name of domain *)
  End;

(*
**  AKA matching structure
*)
  _ZMATCH         = RECORD                                 (* Zone to match *)
    Zone,                                                   (* Net to match *)
    Net,                                                      (* AKA to use *)
    AKAnum        : Word;
  End;

(*
**  Shared information structure
*)
  ShrdRec         = RECORD
    SystemPath,
    MailPath,
    SwapPath,
    RescanPath,                                       (* Commercial version *)
    _ReservedPath,
    InfilePath,
    PacketPath,
    NodelistPath  : Arr71;

    CountryCode   : word;

    AKA           : Array[0..MAXAKA] of RECORD
      Zone,
      Net,
      Node,
      Point       : word;
    End;

    (* --- Timeout value for screen blanker in SECONDS (0-255) *)

    Flags         : longint;
    BlackoutTimer : byte;

    (* --- User record *)

    User          : Array[1..MAXUSER] of RECORD
      Name        : Array[1..37] of Char;
      PwdCrc,                        (* CRC-32 of user password, -1L No pwd *)
      Flags       : longint;
    End;

    (* --- Protection of exits (commercial version) *)

    ExitPwdCrc,                      (* Password for DOS shell, exits, etc. *)
    ExitFlags     : longint;             (* Which flags should be protected *)

    (* --- Zone match set-up *)

    ZMatch        : Array[1..20] of _ZMATCH;

    (* --- "Domain" set-up *)

    Domain        : Array[1..20] of _DOMAIN;

    (* --- System information *)

    SiteInfo      : RECORD
      Name        : Arr50;                                  (* Name of site *)
      Location    : Arr40;                              (* Location of site *)
      PhoneNo     : Arr26;               (* Phone number or '-Unpublished-' *)
      MaxBaud     : Longint;                      (* Baud rate (300-115200) *)
      Flags       : Arr50;                      (* Capability flags of site *)
    End;

    (* --- Reserved *)

    Reserved      : Array[1..86] of Char;
  End;


(* Terminal --------------------------------------------------------------- *)

CONST
  CONNECT_NOISE   = $00000001;
  TRANSFER_NOISE  = $00000002;
  USE_TRANSLATE   = $00000004;
  USE_43LINES     = $00000008;
  AUTOZMODEM      = $00000010;
  NOWRAPAROUND    = $00000020;
  LOCALECHO       = $00000040;
  NOAVATAR        = $00000080;
  USE_AUTOLINES   = $00000100;
  NOCLRONFF       = $00000200;       (*Don't clear screen on form feeds*)
  IEMSIACTIVE     = $00000400;               (*Interactive EMSI Support*)
  TERMCUSTOMCRT   = $00000800;               (*User-defined screen size*)
  TERMLOG         = $00001000;                    (*Logging in Terminal*)

TYPE
  TermRec         = RECORD

    (* --- Init String *)

    InitString    : Arr41;

    (* --- Max memory to use for buffer (in K) *)

    ScrollSize    : word;

    (* --- 0=TTY, 1=ANSI, 2=VT52, 3=VT100 *)

    Emulation     : byte;

    (* --- Index in protocol list *)

    Protocol      : byte;

    (* --- Shift F1-F12 macro settings *)

    ShiftKeys     : Array[1..12] of Array[1..31] of Char;

    (* --- Ctrl F1-F12 macro settings *)

    CtrlKeys      : Array[1..12] of Array[1..31] of Char;

    (* --- Default download path *)

    DownloadPath  : Array[1..60] of Char;

    (* --- Default upload path *)

    UploadPath    : Array[1..60] of Char;

    (* --- Translation table - modem->screen *)

    XlatIn        : Array[0..255] of Char;

    (* --- Translation table - screen->modem *)

    XlatOut       : Array[0..255] of Char;

    (* --- Seconds to wait before next dial.. *)

    RetryWait     : byte;

    (* --- Behavior, sounds, flashes.. etc. *)

    Flags         : longint;

    (* --- CRC-32 of password to enter PhoneDir *)

    DirectoryPWD  : longint;

    (* --- Invoked with Alt-I *)

    Editor        : Array[1..60] of Char;

    (* --- Default profile. See TERMINAL.INC *)

    Profile       : Array[1..94] of byte;

    (* --- Custom screen size params to INT 10H (commercial version) *) 

    SetCustomCRTax,
    SetCustomCRTbx,
    SetCustomCRTcx,
    SetCustomCRTdx,

    ResetCustomCRTax,
    ResetCustomCRTbx,
    ResetCustomCRTcx,
    ResetCustomCRTdx  : word;

    (* --- Reserved *)

    Reserved      : Array[1..854] of Char;
  End;


(* Printer (commercial version) ------------------------------------------- *)

CONST
  PAGE_FORMAT   = $00000001;
  PAGE_FFEED    = $00000002;
  EJECT         = $00000004;
  MANUAL_PAPER  = $00000008;
  HIDE_KLUDGE   = $00000010;
  CONTINOUS     = $00000020;

TYPE
  PrintRec      = RECORD
    Port,                         (* 0 LPT1, 1 LPT2, 2 LPT3, 3 COM1, 4 COM2 *)
    Baud,                                 (* 0 9600, 1 4800, 2 2400, 3 1200 *)
    StopBits,                                           (* $00 - 1, $01 - 2 *)
    WordLength,                                         (* $00 - 7, $01 - 8 *)
    Parity,                            (* $00 - Even, $01 - Odd, $02 - None *)
    PageLen     : byte;
    Behavior    : longint;
    Init,
    Reset       : Arr71;
    BoldOn,
    BoldOff,
    UnderOn,
    UnderOff,
    ItalicsOn,
    ItalicsOff  : Arr31;
    PageWidth,                                (* Width in columns of a page *)
    LeftMargin,                (* Left margin, ie. start printing at column *)
    Footer,                             (* Footer margin, ie. leave nn lines *)
    Header      : byte;                  (* Header margin, ie. skip nn lines *)
    XlatOut     : Array[0..255] of Char;(* Translation table, disk->printer *)
    Reserved    : Array[1..100] of Char;
  End;


(*****************************************************************************
**                                                                          **
** Don't use ANY of the data in the file if the CRC values are NOT correct. **
**                                                                          **
** Check the fingerprint[] field before assuming 1.99b and higher. Your     **
** software should also check the sysrev field to make sure it's compatible **
** with the data listed in SETUP.FD                                         **
**                                                                          **
*****************************************************************************)

CONST
  FD_THISREV    = $0100;

TYPE
  CtlRec        = RECORD
    FingerPrint : Array[1..5] of Char;          (* Must contain "JoHo<NUL>" *)
    SysRev      : word;                    (* Must contain FD_THISREV above *)
    CtlCrc      : longint;   (* CRC-32 of struct excluding the 1st 11 bytes *)
    M           : MailRec;
    E           : EditRec;
    S           : ShrdRec;
    T           : TermRec;
    P           : PrintRec;
    CtlCrc2     : longint;                       (* CRC-32 of all the above *)
  End;

(* --- Uncomment this and compile to display size of records *)
(*
Begin
  Writeln('Mail      ', Sizeof(MailRec));
  Writeln('Editor    ', Sizeof(EditRec));
  Writeln('Shared    ', Sizeof(ShrdRec));
  Writeln('Terminal  ', Sizeof(TermRec));
  WriteLn('Printer   ', SizeOf(PrintRec));
  writeln('Total     ', sizeof(ctlrec));
End.
*)
(* --------------------------------------------------------- *)

(* end of file "ctl.inc" *)
