Unit ZVideo;
Interface
Uses DOS, CRT,
  totFAST, totINPUT, totWIN;

Var
  ZModWin: WinOBJ;
  K: Word;
  X, Y: Byte;

Procedure Z_OpenWindow (title: String);
(* Setup the area of the screen for transfer status window *)
Procedure Z_CloseWindow;
(* Restore the original window *)
Procedure Z_ShowName (filename: String);
(* Display the file name *)
Procedure Z_ShowSize (l: LongInt);
(* Display the file size in blocks and bytes *)
Procedure Z_ShowCheck (is32: Boolean);
(* Display CRC16 or CRC32 block checking *)
Procedure Z_ShowTransferTime (fsize, zbaud: LongInt);
(* Show estimated transfer time in minutes *)
Procedure Z_Message (s: String);
(* Show miscelaneous messages *)
Procedure Z_Frame (n: Integer);
(* Show current ZMODEM frame type *)
Procedure Z_ShowLoc (l: LongInt);
(* Show byte position of file in blocks and bytes *)
Procedure Z_Errors (w: Word);
(* Show total error count *)


Implementation

Const
  X1: Byte = 20;
  X2: Byte = 59;
  Y1: Byte = 5;
  Y2: Byte = 17;
  fore: Byte = LightGray;
  back: Byte = Black;
  bfore: Byte = Black;
  bback: Byte = Green;
  
  
  
  
Var
  vmode: Byte Absolute $0040:$0049;
  vcols: Word Absolute $0040:$004A;
  oldx, oldy, oldattr: Byte;
  oldmin, oldmax, cols, rows, Size, vseg, vofs: Word;
  Buffer: POINTER;
  
Function RtoS (r: Real; width, decimals: Word): String;
Var
  s: String;
Begin
  {$I-}
  Str (r: width: decimals, s);
  {$I+}
  If (IOResult <> 0) Then
    s := ''
  Else
    While (Length (s) > 0) And (s [1] = ' ') Do
      Delete (s, 1, 1);
  RtoS := s
End;



Function ItoS (r: LongInt; width: Word): String;
Var
  s: String;
Begin
  {$I-}
  Str (r: width, s);
  {$I+}
  If (IOResult <> 0) Then
    s := ''
  Else
    While (Length (s) > 0) And (s [1] = ' ') Do
      Delete (s, 1, 1);
  ItoS := s
End;


Procedure Z_OpenWindow (title: String);
Var
  n, pads, bytes: Word;
Begin
  oldx := WhereX;
  oldy := WhereY;
  oldattr := TextAttr;
  oldmin := WindMin;
  oldmax := WindMax;
  With ZModWin Do
  Begin
    Init;
    Draw;
{  ZModWin.Screen.Screen.WritePlain (title);
  title := ' ESCape to abort';
  ZModWin.Screen.Screen.WritePlain (title);}
  Screen. WritePlain (5, 2, ' File name.....:');
  Screen. WritePlain (5, 3, ' File size.....:');
  Screen. WritePlain (5, 4, ' File blocks...:');
  Screen. WritePlain (5, 5, ' Block check...:');
  Screen. WritePlain (5, 6, ' Transfer time.:');
  Screen. WritePlain (5, 7, ' Current BYTE..:');
  Screen. WritePlain (5, 8, ' Current BLOCK.:');
  Screen. WritePlain (5, 9, ' Error count...:');
  Screen. WritePlain (5, 10, ' Last frame....:');
  Screen.GotoXY (5, 11);
{  title := #$19 + 'Last Message' + #$19;}
  End;
End;



Procedure Z_CloseWindow;
Begin
  With ZModWin Do
    Done;
  TextAttr := oldattr;
  WindMax := oldmax;
  WindMin := oldmin;
  Screen.GotoXY (oldx, oldy);
End;

Procedure Z_ShowName (filename: String);
Begin
  If (Length (filename) > 14) Then
    filename [0] := #14;
  Screen.WritePlain (23, 2,filename);
  Screen.GotoXY (5, 11)
End;


Procedure Z_ShowSize (l: LongInt);
Begin
  Screen.WritePlain (23, 3,ItoS (l, 14) );
  If (l Mod 128 <> 0) Then
    l := (l Div 128) + 1
  Else
    l := (l Div 128);
  Screen.WritePlain (23, 4,ItoS (l, 14) );
  Screen.GotoXY (5, 11);
End;


Procedure Z_ShowCheck (is32: Boolean);
Begin
  If (is32) Then
    Screen.WritePlain (23, 5,'CRC 32')
  Else
    Screen.WritePlain (23, 5,'CRC 16');
  Screen.GotoXY (5, 11)
End;

Procedure Z_ShowTransferTime (fsize, zbaud: LongInt);
Var
  bits: Real;
Begin
  bits := fsize * 10.0;
  If (bits <> 0.0) Then
    Screen.WritePlain (23, 6,RtoS ( ( (bits / zbaud) / 60), 10, 2)+'min.')
  Else
    Screen.WritePlain (23, 5,'0min.');
  Screen.GotoXY (5, 11)
End;


Procedure Z_Message (s: String);
Begin
  If (Length (s) > 31) Then
    s [0] := #31;
  Screen.WritePlain (6, 11,'                          ');
  Screen.WritePlain (6, 11,s)
End;

Procedure Z_Frame (n: Integer);
Begin
  If (n < - 3) Or (n > 20) Then
    n := 20;
  Case Lo (n) Of
    3 : Screen.WritePlain (23, 9,'ZNOCARRIER');
    2 : Screen.WritePlain (23, 9,'ZTIMEOUT  ');
    1 : Screen.WritePlain (23, 9,'ZERROR    ');
    0  :Screen.WritePlain (23, 9,'ZRQINIT   ');
    1  : Screen.WritePlain (23, 9,'ZRINIT    ');
    2  : Screen.WritePlain (23, 9,'ZSINIT    ');
    3  : Screen.WritePlain (23, 9,'ZACK      ');
    4  : Screen.WritePlain (23, 9,'ZFILE     ');
    5  : Screen.WritePlain (23, 9,'ZSKIP     ');
    6  : Screen.WritePlain (23, 9,'ZNAK      ');
    7  : Screen.WritePlain (23, 9,'ZABORT    ');
    8  : Screen.WritePlain (23, 9,'ZFIN      ');
    9  : Screen.WritePlain (23, 9,'ZRPOS     ');
    10 : Screen.WritePlain (23, 9,'ZDATA     ');
    11 : Screen.WritePlain (23, 9,'ZEOF      ');
    12 : Screen.WritePlain (23, 9,'ZFERR     ');
    13 : Screen.WritePlain (23, 9,'ZCRC      ');
    14 : Screen.WritePlain (23, 9,'ZCHALLENGE');
    15 : Screen.WritePlain (23, 9,'ZCOMPL    ');
    16 : Screen.WritePlain (23, 9,'ZCAN      ');
    17 : Screen.WritePlain (23, 9,'ZFREECNT  ');
    18 : Screen.WritePlain (23, 9,'ZCOMMAND  ');
    19 : Screen.WritePlain (23, 9,'ZSTDERR   ');
    20 : Screen.WritePlain (23, 9,'ZUNKNOWN  ')
  End;
  Screen.GotoXY (5, 11)
End;

Procedure Z_ShowLoc (l: LongInt);
Begin
  Screen.WritePlain (23, 7,ItoS (l, 14) );
  If (l Mod 128 <> 0) Then
    l := (l Div 128) + 1
  Else
    l := (l Div 128);
  Screen.WritePlain (23, 8,ItoS (l, 14) );
  Screen.GotoXY (5, 11)
End;

Procedure Z_Errors (w: Word);
Begin
  Screen.WritePlain (23, 9,ItoS (w, 14) );
  Screen.GotoXY (5, 11)
End;

End.