Unit ZAsync;
(* Modem interface routines for Turbo Pascal Zmodem *)
(* (c)1988 by J.R.Louvau                            *)
(* You will need a copy of PIBASYN45 to compile     *)
(* this unit.                                       *)
Interface
Uses DOS, SeriellInterface, PibTimer, GlobType;

Function Z_AsyncOn (zport: Word; zbaud: LongInt): Boolean;
Procedure Z_AsyncOff;
Function Z_CharAvail: Boolean;
Procedure Z_ClearInbound;
Procedure Z_FlushOutbound;
Procedure Z_ClearOutbound;
Procedure Z_SendBreak;
Function Z_ReceiveByte: Integer;
Procedure Z_SendByte (b: Byte);
Function Z_Carrier: Boolean;

Implementation

Var
  Port:Word;

Function Z_CharAvail: Boolean;
(* See if there is a character coming in *)
Begin
  If SeriellDiscriptor[Port].NumBuffer < 0 then
    Z_CharAvail := True
  Else
    Z_CharAvail := False;
End;

Procedure Z_ClearInbound;
(* Throw away any pending input to clear the line *)
Begin
  While (CarrierDetector(Port)) And (SeriellDiscriptor[Port].NumBuffer < 0) Do
    SeriellRead(Port)
End;

Procedure Z_ClearOutbound;
(* Throw away any pending output in the buffer *)
Begin
  {Async_Flush_Output_Buffer}
End;

Procedure Z_FlushOutbound;
Begin
  Repeat Until (Not CarrierDetector(Port)) Or
	       (SeriellDiscriptor[Port].Top= SeriellDiscriptor[Port].Bottom)
End;

Procedure Z_SendBreak;
(* Send a break signal *)
Begin
  SendBreak(Port);
End;

Procedure Z_SendByte (b: Byte);
(* Output one byte *)
Begin
  SeriellWrite(Port,Chr (b) )
End;

Function Z_ReceiveByte: Integer;
(* Input one byte (N.B.: RETURNS AN INTEGER!) *)
Var
  n: Integer;
Begin
  N:=Ord(SeriellRead (Port));
  Z_ReceiveByte := (n And $00FF)
End;

Function Z_Carrier: Boolean;
(* Checks for the presence of a carrier *)
Begin
  Z_Carrier := (CarrierDetector(Port))
End;

Procedure Z_AsyncOff;
Var
  I : Integer;
  M : Integer;
Begin  (* Async_Close *)
  ClearStatistic(Port);

{  (* Read the RBR and reset any pending error conditions. *)
  (* First turn off the Divisor Access Latch Bit to allow *)
  (* access to RBR, etc.                                  *)
  Inline ($FA);  (* disable interrupts *)
  Port [UART_LCR + Async_Base] := Port [UART_LCR + Async_Base] And $7F;
  (* Read the Line Status Register to reset any errors *)
  (* it indicates                                      *)
  I := Port [UART_LSR + Async_Base];
  (* Read the Receiver Buffer Register in case it *)
  (* contains a character                         *)
  I := Port [UART_RBR + Async_Base];
  (* enable the irq on the 8259 controller *)
  I := Port [I8088_IMR];  (* get the interrupt mask register *)
  M := (1 ShL Async_Irq) XOr $00FF;
  Port [I8088_IMR] := I And M;
  (* enable OUT2 on 8250 *)
  I := Port [UART_MCR + Async_Base];
  Port [UART_MCR + Async_Base] := I Or $0B;
  (* enable the data ready interrupt on the 8250 *)
  Port [UART_IER + Async_Base] := $0F;
  (* Re-enable 8259 *)
  Port [$20] := $20;
  Inline ($FB); (* enable interrupts *)
  If Async_Open_Flag Then
  Begin
    (* disable the IRQ on the 8259 *)
    Inline ($FA);                 (* disable interrupts *)
    I := Port [I8088_IMR];        (* get the interrupt mask register *)
    M := 1 ShL Async_Irq;        (* set mask to turn off interrupt  *)
    Port [I8088_IMR] := I Or M;
    (* disable the 8250 interrupts *)
    Port [UART_IER + Async_Base] := 0;
    (* Disable OUT2, RTS, OUT1 on the 8250, but *)
    (* possibly leave DTR enabled.              *)
    Port [UART_MCR + Async_Base] := 1;
    Inline ($FB);                 (* enable interrupts *)
    (* re-initialize our data areas so we know *)
    (* the port is closed                      *)
    Async_Open_Flag := False;
    Async_XOFF_Sent := False;
    (* Restore the previous interrupt pointers *)
    SetIntVec ( Async_Irq + 8 , Async_Save_Iaddr );
    I := Port [UART_LSR + Async_Base];
    (* Read the Receiver Buffer Register in case it *)
    (* contains a character                         *)
    I := Port [UART_RBR + Async_Base];
    (* enable the irq on the 8259 controller *)
    I := Port [I8088_IMR];  (* get the interrupt mask register *)
    M := (1 ShL Async_Irq) XOr $00FF;
    Port [I8088_IMR] := I And M;
    (* enable OUT2 on 8250 *)
    I := Port [UART_MCR + Async_Base];
    Port [UART_MCR + Async_Base] := I Or $0B;
    (* enable the data ready interrupt on the 8250 *)
    Port [UART_IER + Async_Base] := $0F;
    (* Re-enable 8259 *)
    Port [$20] := $20;
    Inline ($FB); (* enable interrupts *)
  End;}
End    (* Async_Close *);

Function Z_AsyncOn (zport: Word; zbaud: LongInt): Boolean;
Begin
  {Async_Do_CTS := False;
  Async_Do_DSR := False;
  Async_Do_XonXoff := False;
  Async_Hard_Wired_On := False;
  Async_Break_Length := 500;
  InstallHandler ($3f8, 4, 2048,Port);}
  SetParameter (Port,zbaud,None,1,8);
  Port:=ZPort;
End;

End.

{Procedure InstallHandler (adr, irq, Size : Word ; Var Com : Word);
Procedure DeInstallHandler (Com : Word);
Procedure GetHandlerInfo (Com : Word ; Var adr, ir, buflen : Word);
Function  SeriellRead (Com : Word) : Char;
Procedure SeriellCheckRead (Com : Word ; Var zeichen : Char ; Var flag : Boolean);
Procedure SeriellWrite (Com : Word ; zeichen : Char);
Procedure ClearBuffer (Com : Word);
Function  ReceiverReady (Com : Word) : Boolean;
Function  TransmitterReady (Com : Word) : Boolean;
Function  ClearToSend (Com : Word) : Boolean;
Function  DataSetReady (Com : Word) : Boolean;
Function BreakDetected (Com : Word) : Boolean;
Function  CarrierDetector (Com : Word) : Boolean;
Procedure DataTerminalReady (Com : Word ; zustand : LineZustand);
Procedure RequestToSend (Com : Word ; zustand : LineZustand);
Procedure SendBreak (Com : Word);
Procedure SetStatusMask (Com, mask : Word);
Procedure SetTransmitMask (Com, mask : Word);
Function Status (Com : Word) : Boolean;
Procedure SetParameter (Com   : Word;
			rate    : BaudRateType;
			parity  : ParitYType;
			stopbit : StopBitType;
			wordlen : WordLenType);
Procedure SetBaud (Com : Word ; rate : BaudRateType);
Function  GetBaud (Com : Word) : BaudRateType;
Procedure SetParity (Com : Word ; parity : ParityType);
Function  GetParity (Com : Word) : ParityType;
Procedure SetStop (Com : Word ; stopbit : StopBitType);
Function  GetStop (Com : Word) : StopBitType;
Procedure SetWordLen (Com : Word ; wordlen : WordLenType);
Function  GetWordLen (Com : Word) : WordLenType;
Procedure ClearStatistic (Com : Word);
Function GetIntCounter (Com : Word) : Word;
Function GetReceiveCounter (Com : Word) : Word;
Function GetSendCounter (Com : Word) : Word;
Function GetErrorCounter (Com : Word) : Word;
Function GetOverflowCounter (Com : Word) : Word;
}
