Unit TpzVideo;
(* Status window routines for Turbo Pascal Zmodem *)
(* (c)1988 by J.R.Louvau                          *)
Interface
Uses Crt;

Procedure Z_OpenWindow (title: String);
(* Setup the area of the screen for transfer status window *)
Procedure Z_CloseWindow;
(* Restore the original window *)
Procedure Z_ShowName (filename: String);
(* Display the file name *)
Procedure Z_ShowSize (l: LongInt);
(* Display the file size in blocks and bytes *)
Procedure Z_ShowCheck (is32: Boolean);
(* Display CRC16 or CRC32 block checking *)
Procedure Z_ShowTransferTime (fsize, zbaud: LongInt);
(* Show estimated transfer time in minutes *)
Procedure Z_Message (s: String);
(* Show miscelaneous messages *)
Procedure Z_Frame (n: Integer);
(* Show current ZMODEM frame type *)
Procedure Z_ShowLoc (l: LongInt);
(* Show byte position of file in blocks and bytes *)
Procedure Z_Errors (w: Word);
(* Show total error count *)


Implementation

Const
  X1: Byte = 20;
  X2: Byte = 59;
  Y1: Byte = 5;
  Y2: Byte = 17;
  fore: Byte = LightGray;
  back: Byte = Black;
  bfore: Byte = Black;
  bback: Byte = Green;
  
  {$F+}
  {$L \pascal\screen\mcmvsmem.obj }
Procedure MoveToScreen (Var Source, Dest; Len: Word); External;
Procedure MoveFromScreen (Var Source, Dest; Len: Word); External;
{$F-}



Var
  vmode: Byte Absolute $0040:$0049;
  vcols: Word Absolute $0040:$004A;
  oldx, oldy, oldattr: Byte;
  oldmin, oldmax, cols, rows, Size, vseg, vofs: Word;
  Buffer: POINTER;
  
Function RtoS (r: Real; width, decimals: Word): String;
Var
  s: String;
Begin
  {$I-}
  Str (r: width: decimals, s);
  {$I+}
  If (IOResult <> 0) Then
    s := ''
  Else
    While (Length (s) > 0) And (s [1] = ' ') Do
      Delete (s, 1, 1);
  RtoS := s
End;



Function ItoS (r: LongInt; width: Word): String;
Var
  s: String;
Begin
  {$I-}
  Str (r: width, s);
  {$I+}
  If (IOResult <> 0) Then
    s := ''
  Else
    While (Length (s) > 0) And (s [1] = ' ') Do
      Delete (s, 1, 1);
  ItoS := s
End;


Procedure Z_OpenWindow (title: String);
Var
  p, q: POINTER;
  n, pads, bytes: Word;
Begin
  DirectVideo := True;
  CheckSnow := False;
  oldx := WhereX;
  oldy := WhereY;
  oldattr := TextAttr;
  oldmin := WindMin;
  oldmax := WindMax;
  Window (X1, Y1, X2, Y2);
  TextColor (bfore);
  TextBackground (bback);
  cols := Lo (WindMax) - Lo (WindMin) + 1;
  rows := Hi (WindMax) - Hi (WindMin) + 1;
  If vmode = 7 Then
    vseg := $B000
  Else
    vseg := $B800;
  vofs := ( (Hi (WindMin) * vcols) + Lo (WindMin) ) * 2;
  Size := (rows * cols) * 2;
  bytes := cols * 2;
  pads := (vcols * 2) - bytes;
  GetMem (Buffer, Size);
  p := Ptr (vseg, vofs);
  q := Buffer;
  For n := 1 To rows Do
  Begin
    MoveFromScreen (p^, q^, cols * 2);
    Inc (LongInt (p), vcols * 2);
    Inc (LongInt (q), cols * 2)
  End;
  ClrScr;
  If (Length (title) > (cols - 2) ) Then
    title [0] := Chr (cols - 2);
  GotoXY ( (cols - Length (title) - 2) Div 2 + 1, 1);
  Write (title);
  title := ' ESCape to abort';
  GotoXY ( (cols - Length (title) - 2) Div 2 + 1, rows);
  Write (title);
  Window (X1 + 1, Y1 + 1, X2 - 1, Y2 - 1);
  TextColor (fore);
  TextBackground (back);
  ClrScr;
  GotoXY (1, 1);
  WriteLn (' File name.....:');
  WriteLn (' File size.....:');
  WriteLn (' File blocks...:');
  WriteLn (' Block check...:');
  WriteLn (' Transfer time.:');
  WriteLn (' Current BYTE..:');
  WriteLn (' Current BLOCK.:');
  WriteLn (' Error count...:');
  WriteLn (' Last frame....:');
  TextColor (bfore);
  TextBackground (bback);
  GotoXY (1, 10);
  ClrEol;
  title := #$19 + 'Last Message' + #$19;
  GotoXY ( (cols - Length (title) - 2) Div 2 + 1, 10);
  Write (title);
  TextColor (White);
  TextBackground (back)
End;



Procedure Z_CloseWindow;
Var
  p, q: POINTER;
  n: Word;
Begin
  TextAttr := oldattr;
  WindMax := oldmax;
  WindMin := oldmin;
  GotoXY (oldx, oldy);
  q := Buffer;
  p := Ptr (vseg, vofs);
  For n := 1 To rows Do
  Begin
    MoveToScreen (q^, p^, cols * 2);
    Inc (LongInt (p), vcols * 2);
    Inc (LongInt (q), cols * 2)
  End;
  FreeMem (Buffer, Size)
End;

Procedure Z_ShowName (filename: String);
Begin
  If (Length (filename) > 14) Then
    filename [0] := #14;
  GotoXY (18, 1);
  Write (filename);
  GotoXY (1, 11)
End;


Procedure Z_ShowSize (l: LongInt);
Begin
  GotoXY (18, 2);
  Write (ItoS (l, 14) );
  If (l Mod 128 <> 0) Then
    l := (l Div 128) + 1
  Else
    l := (l Div 128);
  GotoXY (18, 3);
  Write (ItoS (l, 14) );
  GotoXY (1, 11);
End;


Procedure Z_ShowCheck (is32: Boolean);
Begin
  GotoXY (18, 4);
  If (is32) Then
    Write ('CRC32')
  Else
    Write ('CRC16');
  GotoXY (1, 11)
End;

Procedure Z_ShowTransferTime (fsize, zbaud: LongInt);
Var
  bits: Real;
Begin
  bits := fsize * 10.0;
  GotoXY (18, 5);
  If (bits <> 0.0) Then
    Write (RtoS ( ( (bits / zbaud) / 60), 10, 2), 'min.')
  Else
    Write ('0min.');
  GotoXY (1, 11)
End;


Procedure Z_Message (s: String);
Begin
  If (Length (s) > 31) Then
    s [0] := #31;
  GotoXY (1, 11);
  Write (s, #13)
End;

Procedure Z_Frame (n: Integer);
Begin
  If (n < - 3) Or (n > 20) Then
    n := 20;
  GotoXY (18, 9);
  Case Lo (n) Of
    - 3 : Write ('ZNOCARRIER');
    - 2 : Write ('ZTIMEOUT  ');
    - 1 : Write ('ZERROR    ');
    0  : Write ('ZRQINIT   ');
    1  : Write ('ZRINIT    ');
    2  : Write ('ZSINIT    ');
    3  : Write ('ZACK      ');
    4  : Write ('ZFILE     ');
    5  : Write ('ZSKIP     ');
    6  : Write ('ZNAK      ');
    7  : Write ('ZABORT    ');
    8  : Write ('ZFIN      ');
    9  : Write ('ZRPOS     ');
    10 : Write ('ZDATA     ');
    11 : Write ('ZEOF      ');
    12 : Write ('ZFERR     ');
    13 : Write ('ZCRC      ');
    14 : Write ('ZCHALLENGE');
    15 : Write ('ZCOMPL    ');
    16 : Write ('ZCAN      ');
    17 : Write ('ZFREECNT  ');
    18 : Write ('ZCOMMAND  ');
    19 : Write ('ZSTDERR   ');
    20 : Write ('ZUNKNOWN  ')
  End;
  GotoXY (1, 11)
End;

Procedure Z_ShowLoc (l: LongInt);
Begin
  GotoXY (18, 6);
  Write (ItoS (l, 14) );
  If (l Mod 128 <> 0) Then
    l := (l Div 128) + 1
  Else
    l := (l Div 128);
  GotoXY (18, 7);
  Write (ItoS (l, 14) );
  GotoXY (1, 11)
End;

Procedure Z_Errors (w: Word);
Begin
  GotoXY (18, 8);
  Write (ItoS (w, 14) );
  GotoXY (1, 11)
End;

End.