(*
**  Terminal.Inc (FrontDoor Terminal)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  TERMPHON.FD, TERMPROF.FD, and TERMKEYS.FD format for FrontDoor 2.01+
**
**  Last revised: 91-10-02
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)

    (* Phone entry record descriptor -------------------------------------- *)
    (* TERMPHON.FD *)

TYPE
  PhoneRec    = RECORD
    Name      : string[30];                                    (*System name*)
    Number    : string[34];                     (*Telephone number as dialed*)
    BaudRate  : word;                                            (*Baud rate*)
    Flags     : longint;                    (*See below under 'Entry Flags:'*)
    Protocol,                             (*Preferred file transfer protocol*)
    Parity,                                                         (*Parity*)
    Wordlen,                                        (*# of data bits, 7 or 8*)
    StopBits,                                       (*# of stop bits, 1 or 2*)
    Emulation : byte;                                   (*Terminal emulation*)
    KeySet,                          (*Key definition record, 0xFFFF=DEFAULT*)
    Profile   : word;                            (*Profile record, 0=DEFAULT*)
    Script    : string[8];               (*Script name to use, blank if none*)
  End;

    (* Phone record flags: *)

CONST
  XLAT_ON     = $00000001;                          (*Use translation tables*)
  DIALED      = $00000002;                              (*Queued for dialing*)
  LINEFEEDS   = $00000004;                         (*On=CR->CR/LF Off=CR->CR*)
  NOWRAPLINES = $00000008;                   (*Don't wrap lines when xpos=80*)
  B_LOCALECHO = $00000010;                (*Echo keyboard input to local CRT*)
  B_NOAVATAR  = $00000020;                             (*No AVATAR sequences*)
  B_NOIEMSI   = $00000040;                                        (*No IEMSI*)
  DELETED     = $80000000;                  (*Entry is deleted, never stored*)

    (* Profile entry record descriptor ------------------------------------ *)
    (* TERMPROF.FD (all strings are NUL terminated) *)

TYPE
  ProfileRec  = RECORD
    UserName  : array[1..30] of char;                            (*User name*)
    Handle    : array[1..20] of char;                               (*Handle*)
    Password  : array[1..20] of char;                             (*Password*)
    Flags     : longint;                  (*See below under 'Profile Flags:'*)
    Reserved  : array[1..20] of char;                           (* reserved *)
  End;

    (* Profile flags:*)

CONST
  PRF_HOTKEYS = $00000001;                                         (*Hotkeys*)
  PRF_QUIET   = $00000002;                                   (*Don't disturb*)
  PRF_MORE    = $00000004;                                    (*Page pausing*)
  PRF_EDITOR  = $00000008;                          (*Use full-screen editor*)
  PRF_NEWS    = $00000010;                      (*Show bulletins, news, etc.*)
  PRF_NEWMAIL = $00000020;                              (*Check for new mail*)
  PRF_NEWFILE = $00000040;                             (*Check for new files*)
  PRF_CLRSCR  = $00000080;                                 (*Screen clearing*)

    (* Keyset entry record descriptor ------------------------------------- *)
    (* TERMKEYS.FD *)

TYPE
  KeyRec      = RECORD
    ShiftKey  : Array[1..12] of string[30];                   (*Shift F1-F12*)
    CtrlKey   : Array[1..12] of string[30];                    (*Ctrl F1-F12*)
  End;

(* end of file "Terminal.Inc" *)
