(*
**  Modem.Inc (FrontDoor)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  MODEM.FD format for FrontDoor 2.01+
**
**  Last revision:  91-10-02
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)

(*
**  The "MatchStr" and "SendStr" fields are NUL terminated strings
*)

TYPE
  ModemRec  = RECORD
    MatchStr: Array[1..24] of char;                        (*String to match*)
    SendStr : Array[1..32] of char;                         (*String to send*)
    Flags   : word;                                          (*Various flags*)
  End;

CONST
  MODEM_MAXENTRY  = 256;                 (*Maximum number of entries in list*)
  MODEM_INACTIVE  = $0001;                         (*Ignore string, inactive*)
  MODEM_DELETED   = $8000;                           (*Never written to disk*)

(* end of file "Modem.Inc" *)
