(*
**  MailHist.Inc (FrontDoor)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  INBOUND/OUTBOUND.HIS format for FrontDoor 2.00+
**
**  Last revision:  91-10-02
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)

(*
**  The first record in the .HIS files is not a valid history entry. It
**  contains the date/time when the .HIS file was last packed or when
**  it was created if it has never been packed. So if you're reading the
**  .HIS files for any reason, skip the first record and you'll be at the
**  first valid record.
**
**  Note that the COST field will contain zero for inbound mail sessions as
**  well as any failed session negotiated using the script language.
*)
TYPE
  MailHistRec = RECORD
    Year,                                                    (* 1990 - xxxx *)
    Month,                                                        (* 1 - 12 *)
    Day,                                                          (* 1 - 31 *)
    Hour,                                                         (* 0 - 23 *)
    Minute,                                                       (* 0 - 59 *)
    Second,                                                       (* 0 - 59 *)
    Zone,
    Net,
    Node,
    Point     : word;
    SystemName: string[30];
    Location  : string[38];
    TimeOnLine: word;                              (* Seconds spent on-line *)
    RcvdBytes,
    SentBytes : longint;
    Cost      : word;
  End;

(* end of file "MailHist.Inc" *)
