Unit TPZunix;
Interface
Uses DOS;
{file date and time functions}

Function Z_ToUnixDate (fdate: LongInt): String;
Function Z_FromUnixDate (s: String): LongInt;

Implementation

Const
  C1970 = 2440588;
  D0 =    1461;
  D1 =  146097;
  D2 = 1721119;
  
Procedure GregorianToJulianDN (Year, Month, Day : Integer;
                                  Var JulianDN : LongInt);
Var
  Century,
  XYear    : LongInt;
Begin {GregorianToJulianDN}
  If Month <= 2 Then Begin
    Year := Pred (Year);
    Month := Month + 12;
  End;
  Month := Month - 3;
  Century := Year Div 100;
  XYear := Year Mod 100;
  Century := (Century * D1) ShR 2;
  XYear := (XYear * D0) ShR 2;
  JulianDN := ( ( ( (Month * 153) + 2) Div 5) + Day) + D2
  + XYear + Century;
End; {GregorianToJulianDN}

Procedure JulianDNToGregorian (JulianDN : LongInt;
                  Var Year, Month, Day : Integer);
Var
  Temp,
  XYear   : LongInt;
  YYear,
  YMonth,
  YDay    : Integer;
Begin {JulianDNToGregorian}
  Temp := ( ( (JulianDN - D2) ShL 2) - 1);
  XYear := (Temp Mod D1) Or 3;
  JulianDN := Temp Div D1;
  YYear := (XYear Div D0);
  Temp := ( ( ( (XYear Mod D0) + 4) ShR 2) * 5) - 3;
  YMonth := Temp Div 153;
  If YMonth >= 10 Then Begin
    YYear := YYear + 1;
    YMonth := YMonth - 12;
  End;
  YMonth := YMonth + 3;
  YDay := Temp Mod 153;
  YDay := (YDay + 5) Div 5;
  Year := YYear + (JulianDN * 100);
  Month := YMonth;
  Day := YDay;
End; {JulianDNToGregorian}

Function Z_ToUnixDate (fdate: LongInt): String;
Var
  dt: DateTime;
  secspast, datenum, dayspast: LongInt;
  s: String;
Begin
  UnpackTime (fdate, dt);
  GregorianToJulianDN (dt. Year, dt. Month, dt. Day, datenum);
  dayspast := datenum - c1970;
  secspast := dayspast * 86400;
  secspast := secspast + dt. Hour * 3600 + dt. Min * 60 + dt. Sec;
  s := '';
  While (secspast <> 0) And (Length (s) < 255) Do
  Begin
    s := Chr ( (secspast And 7) + $30) + s;
    secspast := (secspast ShR 3)
  End;
  s := '0' + s;
  Z_ToUnixDate := s
End;

Function Z_FromUnixDate (s: String): LongInt;
Var
  dt: DateTime;
  secspast, datenum: LongInt;
  n: Word;
Begin
  secspast := LongInt (0);
  For n := 1 To Length (s) Do
    secspast := (secspast ShL 3) + Ord (s [n] ) - $30;
  datenum := (secspast Div 86400) + c1970;
  JulianDNToGregorian (datenum, Integer (dt. Year), Integer (dt. Month), Integer (dt. Day) );
  secspast := secspast Mod 86400;
  dt. Hour := secspast Div 3600;
  secspast := secspast Mod 3600;
  dt. Min := secspast Div 60;
  dt. Sec := secspast Mod 60;
  PackTime (dt, secspast);
  Z_FromUnixDate := secspast
End;

End.
