Unit SeaLink;
(*$R-,V-,S-*)
Interface
Uses PibAsync, DOS, Crt;

Procedure ReceiveSLink (path: String; overdrive: Boolean);
Procedure SendSLink (pathname: String; overdrive: Boolean);

Implementation

Const
  progname : String  = ''; { the name of the main program - 14 chars max }
  seatalk: Boolean = True;  { display of messages toggle }
  rawblk: Integer = 0;
  ackless : Integer = 0;
  
Type
  zeros = Record
            flen,
            fstamp: LongInt;
            fnam: Array [0..16] Of Byte;
            prog: Array [0..14] Of Byte;
            noacks: Byte;
            Fill: Array [0..86] Of Byte
          End;
  secbuf = Array [0..127] Of Byte;
  
Var
  outblk, ackblk, blksnt, ackst, ackrep,
  numnak, chktec, toterr, slide, ackseen: Integer;
  starttime, endtime: LongInt;
  
Const
  crctab: Array [0..255] Of Word = (
  $0000,  $1021,  $2042,  $3063,  $4084,  $50a5,  $60c6,  $70e7,
  $8108,  $9129,  $a14a,  $b16b,  $c18c,  $D1ad,  $e1ce,  $f1ef,
  $1231,  $0210,  $3273,  $2252,  $52b5,  $4294,  $72f7,  $62D6,
  $9339,  $8318,  $b37b,  $a35a,  $D3bd,  $c39c,  $f3ff,  $e3de,
  $2462,  $3443,  $0420,  $1401,  $64e6,  $74c7,  $44a4,  $5485,
  $a56a,  $b54b,  $8528,  $9509,  $e5ee,  $f5cf,  $c5ac,  $D58D,
  $3653,  $2672,  $1611,  $0630,  $76D7,  $66f6,  $5695,  $46b4,
  $b75b,  $a77a,  $9719,  $8738,  $f7df,  $e7fe,  $D79D,  $c7bc,
  $48c4,  $58e5,  $6886,  $78a7,  $0840,  $1861,  $2802,  $3823,
  $c9cc,  $D9ed,  $e98e,  $f9af,  $8948,  $9969,  $a90a,  $b92b,
  $5af5,  $4ad4,  $7ab7,  $6a96,  $1a71,  $0a50,  $3a33,  $2a12,
  $dbfd,  $cbdc,  $fbbf,  $eb9e,  $9b79,  $8b58,  $bb3b,  $ab1a,
  $6ca6,  $7c87,  $4ce4,  $5cc5,  $2c22,  $3c03,  $0c60,  $1c41,
  $edae,  $fd8f,  $cdec,  $ddcd,  $ad2a,  $bd0b,  $8D68,  $9D49,
  $7e97,  $6eb6,  $5ed5,  $4ef4,  $3e13,  $2e32,  $1e51,  $0e70,
  $ff9f,  $efbe,  $dfdd,  $cffc,  $bf1b,  $af3a,  $9f59,  $8f78,
  $9188,  $81a9,  $b1ca,  $a1eb,  $D10c,  $c12D,  $f14e,  $e16f,
  $1080,  $00a1,  $30c2,  $20e3,  $5004,  $4025,  $7046,  $6067,
  $83b9,  $9398,  $a3fb,  $b3da,  $c33D,  $D31c,  $e37f,  $f35e,
  $02b1,  $1290,  $22f3,  $32D2,  $4235,  $5214,  $6277,  $7256,
  $b5ea,  $a5cb,  $95a8,  $8589,  $f56e,  $e54f,  $D52c,  $c50D,
  $34e2,  $24c3,  $14a0,  $0481,  $7466,  $6447,  $5424,  $4405,
  $a7db,  $b7fa,  $8799,  $97b8,  $e75f,  $f77e,  $c71D,  $D73c,
  $26D3,  $36f2,  $0691,  $16b0,  $6657,  $7676,  $4615,  $5634,
  $D94c,  $c96D,  $f90e,  $e92f,  $99c8,  $89e9,  $b98a,  $a9ab,
  $5844,  $4865,  $7806,  $6827,  $18c0,  $08e1,  $3882,  $28a3,
  $cb7D,  $db5c,  $eb3f,  $fb1e,  $8bf9,  $9bd8,  $abbb,  $bb9a,
  $4a75,  $5a54,  $6a37,  $7a16,  $0af1,  $1ad0,  $2ab3,  $3a92,
  $fd2e,  $ed0f,  $dd6c,  $cd4D,  $bdaa,  $ad8b,  $9de8,  $8dc9,
  $7c26,  $6c07,  $5c64,  $4c45,  $3ca2,  $2c83,  $1ce0,  $0cc1,
  $ef1f,  $ff3e,  $cf5D,  $df7c,  $af9b,  $bfba,  $8fd9,  $9ff8,
  $6e17,  $7e36,  $4e55,  $5e74,  $2e93,  $3eb2,  $0ed1,  $1ef0
  );
  
Function Com_GetC (tenths: Integer): Integer;

Var
  n: Integer;
  
Begin
  tenths := (tenths Div 10);
  Async_Receive_With_Timeout (tenths, n);
  If (n >= 256) Then
    Com_GetC := - 1
  Else
    Com_GetC := (n And $00FF)
End;

Procedure Com_PutC (b: Byte);

Begin
  Async_Send_Now (Chr (b) )
End;

Procedure Com_Flush;

Begin
  Async_Flush_Output_Buffer
End;

Function Com_Peek: Integer;

Begin
  Com_Peek := Ord (Async_Peek (0) )
End;

Function UpdCrc (cp: Byte; crc: Integer): Integer;
Begin
  UpdCrc := (crctab [ ( (crc ShR 8) And 255) ] XOr (crc ShL 8) XOr cp)
End;


Procedure Message (s: String; n: Integer);

Begin
  Write (#13, 'SeaLink - ', s: 25);
  If (n >= 0) Then
    Write (' [ ', n: 3, ' ] ')
  Else
    Write ('': 9)
End;

Function FromAsciiZ (Var a): String;

Var
  s: String;
  ar: Array [0..255] Of Char Absolute a;
  p: Word;
  
Begin
  p := 0;
  While (ar [p] <> #0) And (p <= 255) Do
  Begin
    s [p + 1] := ar [p];
    Inc (p)
  End;
  s [0] := Chr (p);
  FromAsciiZ := s
End;

Procedure ToAsciiZ (Var a; s: String; maxlen: Integer);

Var
  ar: Array [0..255] Of Char Absolute a;
  p:  Word;
  
Begin
  If (maxlen < 0) Then
    maxlen := 0;
  If (maxlen > 255) Then
    maxlen := 255;
  If (Length (s) > maxlen) Then
    s [0] := Chr (maxlen);
  FillChar (ar, maxlen, 0);
  Move (s [1], ar [0], Length (s) )
End;

Function TimerSet (tenths: Integer): LongInt;

Var
  h, m, s, hn: Word;
  
Begin
  GetTime (h, m, s, hn);
  TimerSet := (LongInt (h) * 36000) + (LongInt (m) * 600) + (LongInt (s) * 10) + (LongInt (tenths) ) + (LongInt (hn) Div 10)
End;

Function TimeUp (Time: LongInt): Boolean;

Begin
  TimeUp := (TimerSet (0) >= Time)
End;

Procedure AckChk;

Var
  c: Integer;
  
Begin
  ackrep := 0;
  c := Com_GetC (20);
  While (c >= 0) Do
  Begin
    If (KeyPressed) Then
      If (ReadKey In [^ [, ^X] ) Then
      Begin
        numnak := 50;
        Exit
      End;
    If (ackst = 3) Or (ackst = 4) Then
    Begin
      slide := 0;
      If (rawblk = (c XOr $FF) ) Then
      Begin
        rawblk := outblk - ( (outblk - rawblk) And $FF);
        If (rawblk >= 0) And (rawblk <= outblk) And (rawblk > outblk - 128) Then
        Begin
          If (ackst = 3) Then
          Begin
            If (ackblk <= rawblk) Then
              ackblk := rawblk;
            slide := 1;
            Inc (ackseen);
            If (ackless <> 0) And (ackseen > 10) Then
            Begin
              ackless := 0;
              Message ('Overdrive disengaged', 0)
            End;
            Message ('ACK', rawblk)
          End
          Else
          Begin
            If (rawblk < 0) Then
              outblk := 0
            Else
              outblk := rawblk;
            If (numnak < 4) Then
              slide := 1
            Else
              slide := 0;
            Message ('NAK', rawblk)
          End;
          ackrep := 1
        End
      End;
      ackst := 0;
      Exit
    End;
    If (ackst = 1) Or (ackst = 2) Then
    Begin
      rawblk := c;
      Inc (ackst, 2)
    End;
    If (ackst = 0) Or (slide = 0) Then
    Begin
      If (c = 6) Then
      Begin
        If (slide = 0) Then
        Begin
          Inc (ackblk);
          ackrep := 1;
          Message ('ACK', ackblk)
        End;
        ackst := 1;
        numnak := 0
      End
      Else If (c = Ord ('C') ) Or (c = 21) Then
      Begin
        If (chktec > 1) Then
          If (c = 21) Then
            chktec := 0
          Else
            chktec := 1;
        Com_Flush;
        Delay (6);
        If (slide = 0) Then
        Begin
          outblk := ackblk + 1;
          ackrep := 1;
          Message ('NAK', ackblk + 1)
        End;
        ackst := 2;
        Inc (numnak);
        If (blksnt <> 0) Then
          Inc (toterr)
      End
    End;
    If (ackst = 5) Then
      ackst := 0;
    c := Com_GetC (20)
  End
End;

Function GetBlock (Var buf: secbuf): String;

Var
  ourcrc, hiscrc, c, n, timeout: Integer;
  
Begin
  ourcrc := 0;
  If (ackless = 0) Then
    timeout := 1
  Else
    timeout := 20;
  For n := 0 To 127 Do
  Begin
    c := Com_GetC (10);
    If (c = - 1) Then
    Begin
      GetBlock := 'Short';
      Exit
    End;
    If (chktec <> 0) Then
      ourcrc := UpdCrc (c, ourcrc)
    Else
      ourcrc := ourcrc + c;
    buf [n] := Byte (c)
  End;
  If (chktec <> 0) Then
  Begin
    c := Com_GetC (10);
    ourcrc := UpdCrc (c, ourcrc);
    c := Com_GetC (10);
    ourcrc := UpdCrc (c, ourcrc);
    If (ourcrc = 0) Then
      GetBlock := ''
    Else
      GetBlock := 'CRC';
    Exit
  End;
  ourcrc := ourcrc And $FF;
  hiscrc := Com_GetC (1) And $FF;
  If (hiscrc = ourcrc) Then
    GetBlock := ''
  Else
    GetBlock := 'Check'
End;

Procedure SendAck (acknak, blknum: Integer);

Begin
  If (acknak <> 0) Then
    Com_PutC (6)
  Else If (chktec <> 0) Then
    Com_PutC (Ord ('C') )
  Else
    Com_PutC (21);
  Com_PutC (Byte (blknum) );
  Com_PutC (Byte (blknum XOr $FF) )
End;

Procedure ReceiveSLink (path: String; overdrive: Boolean);

Label
  nakblock, ackblock, nextblock, blockstart, endrcv, abort;

Var
  sr: SearchRec;
  c, tries, blknum, inblk, endblk, n: Integer;
  t1, Left: LongInt;
  f: File;
  zero: zeros;
  Name, pname, stat, why: String;
  buff: secbuf;
  
Begin
  If (path [Length (path) ] <> '\') Then
    path := path + '\';
  Assign (f, path + '-TMPFILE.$$$');
  {$I-} Rewrite (f, Word (1) ); {$I+}
  If (IOResult <> 0) Then
  Begin
    Message ('Cannot create ' + path + '-TMPFILE.$$$', - 1);
    Exit
  End;
  stat := 'Init';
  blknum := 0;
  tries := - 10;
  chktec := 1;
  toterr := 0;
  endblk := 0;
  ackless := 0;
  FillChar (zero, 128, 0);
  starttime := TimerSet (0);
  If (Com_Peek = 1) Then
    Goto nextblock;
  nakblock:
  If (blknum > 1) Then
    Inc (toterr);
  Inc (tries);
  If (tries > 10) Then
  Begin
    Message ('Too many errors', - 1);
    Goto abort
  End;
  If (tries = 0) Then
    chktec := 0;
  SendAck (0, blknum);
  Message ('NAK ' + stat, blknum);
  If (ackless <> 0) And (toterr > 20) Then
  Begin
    ackless := 0;
    Message ('Overdrive disengaged', - 1)
  End;
  Goto nextblock;
  ackblock:
  If (ackless = 0) Then
    Message ('ACK', blknum - 1)
  Else If ( (blknum Mod 10) = 0) Then
    Message ('Got block', blknum);
  nextblock:
  stat := '';
  If (Not (Async_Carrier_Detect) ) Then
  Begin
    Message ('Lost carrier', - 1);
    Goto abort
  End;
  If (KeyPressed) Then
    If (ReadKey In [^X, ^ [] ) Then
    Begin
      Message ('Aborted by operator', - 1);
      Goto abort
    End;
  t1 := timerset (30);
  While (Not (TimeUp (t1) ) ) Do
  Begin
    c := Com_GetC (0);
    If (c = 4) And ( (endblk = 0) Or (endblk = blknum) ) Then
      Goto endrcv;
    If (c = 1) Then
    Begin
      inblk := Com_GetC (5);
      If (Com_GetC (5) = (inblk XOr $FF) ) Then
        Goto blockstart
    End
  End;
  stat := 'Time';
  Goto nakblock;
  blockstart:
  c := blknum And $FF;
  If (inblk = 0) And (blknum <= 1) Then
  Begin
    why := GetBlock (buff);
    If (why = '') Then
    Begin
      SendAck (1, inblk);
      Move (buff, zero, 128);
      Left := zero. flen;
      Name := FromAsciiZ (zero. fnam);
      pname := FromAsciiZ (zero. prog);
      ackless := (zero. noacks) And (Byte (overdrive) );
      If (Left > 0) Then
        endblk := (Left + 127) Div 128 + 1;
      {         IF (noacks <> 0) THEN
      Message('Overdrive engaged',-1)
      ELSE
      Message('Overdrive engaged',-1);}
      If (endblk <> 0) And (seatalk) Then
      Begin
        WriteLn;
        WriteLn ('Receiving ', endblk - 1, ' blocks of ', Name, ' from ', pname);
      End;
      blknum := 1;
      Goto ackblock
    End
    Else
    Begin
      stat := why;
      Goto nakblock
    End
  End
  Else If (inblk = c) Then
  Begin
    why := GetBlock (buff);
    If (why = '') Then
    Begin
      If (ackless = 0) Then
        SendAck (1, inblk);
      {$I-} BlockWrite (f, buff, 128); {$I+}
      Left := Left - 128;
      If (IOResult <> 0) Then
      Begin
        Message ('Write error (disk full?)', - 1);
        Delay (1000);
        Goto abort
      End;
      tries := 0;
      Inc (blknum);
      Goto ackblock
    End
    Else
    Begin
      stat := why;
      Goto nakblock
    End
  End
  Else If (inblk < c) Or (inblk > c + 100) Then
  Begin
    why := GetBlock (buff);
    SendAck (1, inblk);
    stat := 'Dup';
    Goto ackblock
  End
  Else
    Goto nextblock;
  endrcv:
  SendAck (0, blknum);
  Message ('NAK EOT', - 1);
  If (Com_GetC (20) <> 4) Then
    Goto nakblock;
  SendAck (1, blknum);
  Message ('ACK EOT', - 1);
  endtime := zero. flen Div ( (TimerSet (0) - starttime) Div 10);
  abort:
  If (zero. fstamp > 0) Then
  Begin
    SetFTime (f, zero. fstamp);
    If (DosError <> 0) Then
      Message ('Unable to date file', - 1)
  End;
  {$I-} Close (f); {$I+}
  If (IOResult = 0) And (blknum > 1) Then
  Begin
    FindFirst (path + Name, AnyFile, sr);
    If (DosError = 0) Then
      Name [1] := '-';
    {$I-} Rename (f, Name); {$I+}
    If (IOResult <> 0) Then
      Message ('Unable to rename file', - 1)
  End;
  If (blknum = 0) Then
    Message ('No file received', - 1)
End;

Procedure ShipBlk (Var blk: secbuf; blknum: Integer);

Var
  n, crc: Integer;
  
Begin
  crc := 0;
  Com_PutC (1);
  Com_PutC (Byte (blknum) );
  Com_PutC (Byte (blknum) XOr $FF);
  For n := 0 To 127 Do
  Begin
    If (chktec <> 0) Then
      crc := UpdCrc (blk [n], crc)
    Else
      crc := crc + blk [n];
    Com_PutC (blk [n] )
  End;
  If (chktec <> 0) Then
  Begin
    crc := UpdCrc (0, crc);
    crc := UpdCrc (0, crc);
    Com_PutC (Byte (crc ShR 8) );
    Com_PutC (Byte (crc) And $FF)
  End
  Else
    Com_PutC (Byte (crc) )
End;

Procedure SendBlk (Var f: File; blknum: Integer);

Var
  buff: secbuf;
  blkloc: LongInt;
  
Begin
  If (blknum <> (blksnt + 1) ) Then
  Begin
    blkloc := LongInt (blknum - 1) * LongInt (128);
    {$I-} Seek (f, blkloc); {$I+}
    If (IOResult <> 0) Then
      Message ('Error seeking block', blknum - 1)
  End;
  blksnt := blknum;
  FillChar (buff, 128, 0);
  {$I-} BlockRead (f, buff, 128); {$I+}
  If (IOResult <> 0) Then
    Message ('Error reading block', blknum);
  ShipBlk (buff, blknum)
End;

Procedure SendSLink (pathname: String; overdrive: Boolean);

Label
  abort1;

Var
  f: File;
  t1: LongInt;
  endblk: Integer;
  sr: SearchRec;
  zero: zeros;
  buff: secbuf;
  
Begin
  If (pathname <> '') Then
  Begin
    FindFirst (pathname, Archive, sr);
    If (DosError <> 0) Then
    Begin
      Message ('No file found', - 1);
      Exit
    End;
    FillChar (zero, 128, 0);
    With sr, zero Do
    Begin
      flen := Size;
      fstamp := Time;
      If (overdrive) Then
        noacks := 1;
      Move (Name [1], fnam [0], Length (Name) );
      If (Length (progname) >= 14) Then
        Move (progname [1], prog [0], 14)
      Else
        Move (progname [1], prog [0], Length (progname) );
      Move (zero, buff, 128)
    End;
    Assign (f, pathname);
    {$I-} Reset (f, Word (1) ); {$I+}
    If (IOResult <> 0) Then
    Begin
      Message ('Unable to open file', - 1);
      Exit
    End;
    endblk := Integer ( (zero. flen + 127) Div 128) + 1;
    If (seatalk) Then
    Begin
      WriteLn;
      WriteLn ('Ready to send ', endblk - 1, ' blocks of ', sr. Name)
    End
  End
  Else
    endblk := 0;
  outblk := 1;
  ackblk := - 1;
  blksnt := 0;
  slide := 0;
  ackst := 0;
  numnak := 0;
  toterr := 0;
  ackrep := 0;
  ackseen := 0;
  chktec := 2;
  ackless := Byte (overdrive);
  t1 := TimerSet (300);
  Message ('Waiting', - 1);
  While (ackblk < endblk) Do
  Begin
    If (Not (Async_Carrier_Detect) ) Then
    Begin
      Message ('Lost carrier', - 1);
      Goto abort1
    End;
    If (KeyPressed) Then
      If (ReadKey In [^X, ^ [] ) Then
      Begin
        Message ('Aborted by operator', - 1);
        Goto abort1
      End;
    If (TimeUp (t1) ) Then
    Begin
      Message ('Fatal timeout', - 1);
      Goto abort1
    End;
    If ( (slide <> 0) And (outblk <= (ackblk + 6) ) ) Or
       ( (slide = 0) And (outblk <= (ackblk + 1) ) ) 
    Then
    Begin
      If (outblk < endblk) Then
      Begin
        If (outblk > 0) Then
          SendBlk (f, outblk)
        Else
          ShipBlk (buff, 0);
        If (ackrep <> 0) Then
          Message ('Sending block', outblk);
        If (ackless <> 0) And (slide <> 0) Then
        Begin
          If ( (outblk Mod 10) = 0) Then
            Message ('Passing block', outblk);
          ackblk := outblk
        End
      End
      Else If (outblk = endblk) Then
      Begin
        Com_PutC (4);
        If (ackrep <> 0) Then
          Message ('Sending EOT', - 1)
      End;
      Inc (outblk);
      t1 := TimerSet (30)
    End;
    ackchk;
    If (numnak > 10) Then
    Begin
      Message ('Too many errors', - 1);
      Goto abort1
    End
  End;
  Message ('End of file', - 1);
  abort1:
  If (endblk <> 0) Then
  Begin
    {$I-} Close (f); {$I+}
    If (IOResult <> 0) Then
      {null} ;
    endtime := zero. flen Div ( (TimerSet (0) - starttime) Div 10)
  End
  Else
  Begin
    For endblk := 1 To 5 Do
      Com_PutC (4);
    For endblk := 1 To 5 Do
      Com_PutC (24)
  End
End;

End.