(*
**  LastCall.Inc (FrontDoor)
**
**  Copyright 1991 Joaquim H. Homrighausen. All rights reserved.
**
**  LASTCALL.FD definitions for FrontDoor 2.00+
**
**  Last revision:  91-10-02
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*)

(*
**  Recent activity (statistics) definitions.
*)
TYPE
  StatRec     = RECORD
    Inbound,                                          (* Inbound mail calls *)
    Outbound,                                        (* Outbound mail calls *)
    Humans,                                          (* Inbound BBS callers *)
    FilesIn,                                               (* Inbound files *)
    FilesOut,                                             (* Outbound files *)
    GoodSess,                                              (* Good sessions *)
    BadSess,                                             (* Failed sessions *)
    Requests  : word;                              (* Inbound file requests *)
    Date,                                           (* UNIX-style timestamp *)
    BytesIn,                                        (* Inbound (rcvd) bytes *)
    BytesOut  : longint;                           (* Outbound (sent) bytes *)
  End;


  LastCallRec = RECORD
    SystemName: string[30];
    Location  : string[40];
    Zone,
    Net,
    Node,
    Point     : word;
    TimeStamp : longint;                            (* UNIX-style timestamp *)
  End;


(*
**  The LASTCALL.FD file contains four records, two StatRec and two
**  LastCallRec. Today's activity is moved to yesterday's activity
**  as soon as FD runs its 'past-midnight' internal event.
*)

  ActivityRec = RECORD
    LastIn,                                       (* Last inbound mail call *)
    LastOut   : LastCallRec;                     (* Last outbound mail call *)
    Today,                                              (* Today's activity *)
    Yesterday : StatRec;                            (* Yesterday's activity *)
  End;

(* end of file "LastCall.Inc" *)
