;
;        Activate sending of characters
;
          MOV    DX,[>Async_Uart_MCR]       ;Get modem control register
          IN     AL,DX
          OR     AL,$0B                     ;Turn on OUT2, DTR, and RTS
          OUT    DX,AL
;
          MOV    DX,[>Async_Uart_MSR]       ;Get modem status register address
;
;         Wait for DSR using Busy Wait
;
          TEST   BYTE [>Async_Do_DSR],1     ;See if doing DSR check
          JZ     SendNow2                   ;No -- skip check
;
          MOV    CX,$FFFF                   ;Large count for busy wait
;
SendNow1: IN     AL,DX                      ;Read modem status register
          TEST   AL,<Async_DSR              ;Check for DSR
          JNZ    SendNow2
          LOOP   SendNow1
          JMP    Exit                       ;Quit if we fall through
;
;         Wait for CTS using Busy Wait
;
SendNow2: TEST   BYTE [>Async_Do_CTS],1     ;See if doing CTS check
          JZ     SendNow4                   ;No -- skip check
;
          MOV    CX,$FFFF                   ;Restore count
;
SendNow3: IN     AL,DX                      ;Read modem status register
          TEST   AL,<Async_CTS              ;Check for CTS
          JNZ    SendNow4
          LOOP   SendNow3
          JMP    Exit                       ;Quit if we fall through
;
;         Wait for Transmit Hold Register Empty (THRE)
;
SendNow4: MOV    CX,$FFFF                   ;Restore count
          MOV    DX,[>Async_Uart_LSR]       ;Get line status register address
;
SendNow5: IN     AL,DX                      ;Read line status register
          TEST   AL,<Async_THRE             ;Check for THRE empty
          JNZ    SendNow6
          LOOP   SendNow5
          JMP    Exit                       ;Quit if we fall through
;
;         Send the character when port clear
;
SendNow6: MOV    AL,[BP+>C]                 ;Get character to transmit
          MOV    DX,[>Async_Uart_THR]       ;Get transmit hold register
          OUT    DX,AL                      ;Send the character
;
Exit: