(* SEARCH EXAMPLE by Animadei[T] 08-01-1996


   In this messy example, SEARCH.EXE (SEARCH.PAS), uses the location search at
   file position 0 to find "CLIT!"  If not the global BS_Found = false, then
   seek file position to 0 and use binary search method to find the string.

   Initialization instruction:

     You must call it BEFORE any search may be done or else something
     probably will go wrong!  Be sure to have enough memory for BSE; you
     probably will need to shrink the maximum heap size down by the memory
     blocksize.  BSE will give "BS_Error: ...whatever it is" whenever there's
     an error to help facilitate hours of debugging to find the problem.

     BS_Init(F,32768,True,False,'CLIT!');         {Initialize}
             |   |    |     |       |
             |   |    |     |       |- String to find; can be any hex value
             |   |    |     |          up to 255 bytes; read document for
             |   |    |     |          finding data over 255 bytes!  You can
             |   |    |     |          replace this with a string variable!
             |   |    |     |
             |   |    |     |- True if case sensitive.
             |   |    |
             |   |    |- True if exact search method; no wildcards; if using
             |   |       wildcard search method, then ALL "?" are considered
             |   |       to be any value ie. data is "CLIT" and search string
             |   |       is "CL?T"  BS_Found should return true and current
             |   |       file position is at the start of the found string.
             |   |
             |   |- Least memory block size is 256 and largest memory block
             |      size is 32,768 bytes; anything over 32,768 will be shrunk
             |      down to 32,768 bytes.  32,768 bytes (64 sectors) usually
             |      provides the maximum speed of most "modern" hard drives
             |      (highly recommended).
             |
             |- The file handle to search the data ie. var f: file;        *)



{$M $800,0,0}

uses Crt,BSEUV100;

var F: file;
    Ch: Char;
    X: Byte;

function Hex (N: LongInt; nPlaces: Byte): string;
const HexDigits: array[0..15] of Char = '0123456789ABCDEF';
var S: string[8];
    Digit: Byte;
begin
  S := '';
  if nPlaces < SizeOf(S) then begin
    S[0] := Chr(nPlaces);
    for Digit := nPlaces downto 1 do begin
      S[Digit] := HexDigits[N and $0000000F];
      N := N shr 4
    end
  end;
  Hex := S
end;


begin
  Writeln('Binary Search Engine (tm)  -  Turbo Pascal v7.0');
  Writeln('Example and engine by Animadei[T]  06-28-1996');
  Writeln;
  Writeln('-- Very slow due to the "programmer-friendly" interface overhead');
  Writeln('-- Try to bomb this engine ligitimately and please report all bugs!');
  Writeln;

  Assign(F,'TESTTHIS.SHT');
  Reset(F,1);

  {------------------------------------------------------------------------}

  Writeln('Location search at:  ',Hex(FilePos(F),8));

  BS_Init(F,32768,False,False,#$AD+'CLIT!');     {Initialize, $#AD = ''}
  BS_LSearch;                                    {Location search method}

  if BS_Found then Writeln('Found bytes at:      ',Hex(FilePos(F),8))
              else begin
                     Writeln('Bytes not found!');
                     Writeln('Trying binary search... ESC to quit!')
                   end;

  {------------------------------------------------------------------------}

  if not BS_Found then begin
    Write('Binary search:  ');
    X := WhereX;
    Write(Hex(FilePos(F),8));

    Ch := #0;
    Seek(f,0);                                    {Go back to the beginning}
    BS_Init(F,32768,True,False,'CLIT!');         {Initialize}
    while BS_Search and (Ch <> #27) do begin      {Binary search method;}
      GotoXY(X,WhereY);                           {notice where it's located;}
      Write(Hex(FilePos(F),8));                   {a sentinel value of while;}
      if Keypressed then Ch := Readkey            {wow, how convenient!  Yup.}
    end;

    Writeln;
    if Ch = #27 then Writeln('Error!:  ESC pressed!')
      else if BS_Found then Writeln('Found!:  ',Hex(FilePos(F),8))
                       else Writeln('Error!:  String not found!')
  end;

  {------------------------------------------------------------------------}

  Close(F)

end.