









                      Boosters Users Guide
                       by George F. Smith


                      609 Candlewick Lane
                       Lilburn, GA 30247
                        (404) 923-6879


                         November, 1985
                          Version 1.0













             (C) Copyright 1985 by George F. Smith
                      All Rights Reserved
.pa
.F1Boosters Users Guide                                Page #
                      BOOSTERS USERS GUIDE

                       Table of Contents

     Introduction 
        What is Boosters? .............................  3
        Speed Without Snow ............................  5

     Section 1  Getting Started
        What's On the Distribution Disk ...............  6
        What to Do First--BACKUP ......................  7

     Section 2  Ground Rules
        Some Notes On Video ...........................  8
        Heap I/O ...................................... 10
 
     Section 3 Descriptions of Boosters Routines ...... 12
        BoDecl declares ............................... 13
        BoxUL procedure ............................... 14
        Calendar procedure ............................ 16
        Center function ............................... 17
        Copies function ............................... 18
        CopyBlk procedure ............................. 19
        CopyStr function .............................. 21
        Cursor procedures ............................. 22
        Dows function ................................. 23
        Exec procedure ................................ 24
        FillHeap procedure ............................ 26
        FindStr procedure ............................. 27
        GetStr procedure .............................. 29
        Left function ................................. 30
        MoveBg procedure .............................. 31
        MoveBlk procedure ............................. 33
        NsOrbit procedure ............................. 34
        OverStr function .............................. 35
        PutStr procedure .............................. 36
        RemBlk procedure .............................. 37
        RestoreScreen procedure ....................... 40
        Right function ................................ 38
        Rword function ................................ 39
        SaveScreen procedure .......................... 40
        SetAtt procedure .............................. 41
        Space function ................................ 42
        Stime procedure ............................... 45
        Strip function ................................ 43
        Timer function ................................ 44
        TimeXY procedure .............................. 45
        Upper function ................................ 47
        Wait procedure ................................ 48
        Word function ................................. 49
        WordInd function .............................. 50
        Words function ................................ 51
.pa
                            INTRODUCTION



This book is a reference guide for Turbo Pascal (tm) programmers 
using the Boosters Utilities (C) in their work.  It provides 
formats, descriptions, and tested coding examples for each Booster 
routine.  

Boosters is intended for students, software developers, hobbyists, 
or consultants who have at least a working knowledge of Turbo 
Pascal and who are targeting their products for IBM PC/compatible 
systems that run under MS-DOS 2.0 or higher.  All Boosters 
routines will run under Turbo Pascal version 2.0 or 3.0, except 
the Exec procedure, which requires version 3.0.  



WHAT IS BOOSTERS?

Boosters is a family of Turbo Pascal utilities tuned for speed of 
execution and ease of use.  Their evolution is as follows: 

While developing a large program with Turbo Pascal, I found it 
convenient to write some string functions that had proved 
indispensible in my work with other languages.  These are 
functions familiar to most programmers--routines to center or 
justify text, for example.  Turbo Pascal's features made it 
extremely easy to write them in source code.  As an example, the 
function Copies, which generates a string of length N of character 
C, can be expressed as: 

          Function COPIES ( C : Char; 
                            N : LenType        (* 1..255  *)
                                ) : AnyString  (* string[255]  *)
          var
             S : AnyString;  
             L : Integer absolute S;
          begin
             L := N;
             FillChar ( S[1], N, C );
             Copies := Copy ( S, 1, N );
          end; 

With the function thus defined, you can wring a great deal of 
work from it, such as marking the length of a user input field 
with a particular character and attribute:

          GoToXY ( Xval, Yval );   (* Cursor at field beginning  *)
          TextColor ( Yellow );    (* Brighten field  *)
          Write ( Copies ( '_', Length(field) );  (* Mark field  *)
.pa
The preceding example works fine, but lacks the convenience and 
speed desired when used repeatedly.  Seeking to combine the 
operations of those three procedures into one, and add a few 
enhancements, I wrote a routine called PutStr ("Put String") which 
has the following declaration: 

          Procedure PUTSTR ( D : Char;         (* Direction  *) 
                             S : AnyString;    (* string[255]  *)
                             X : ColumnType;   (* 1..80  *)
                             Y : RowType;      (* 1..25  *)
                             A : Integer ); 

PutStr writes string S directly to video memory beginning at 
location X,Y for length Length(S) with display attribute A.  The 
value of 'D' tells PutStr whether to proceed horizontally or
vertically.

Since S is defined as a value parameter, it allows for the direct 
placement of function calls in the PutStr procedure statement.    

Applying PutStr to the last example, we get:

          PutStr ( h, Copie ('_', length(field), Xval, Yval, 14);

Because PutStr bypasses DOS and BIOS video I/O services and goes 
directly to screen memory, PutStr is faster than the standard 
procedure Write.  

Copies and PutStr became part of a growing collection of routines 
that performed frequently used string and video operations.  For 
casual use, they were more than adequate in their source-level 
form.  But for large programming efforts, especially ones that 
employed time-critical operations, I felt compelled to tighten 
every routine to its limit.  Using the existing collection as 
prototypes, I began rewriting them in 8088 assembly language.  

The finished product--a collection of about 12 routines--was the 
original Boosters.  
.pa
SPEED WITHOUT SNOW 

From long association with the winters of Buffalo, New York, I 
have concluded that snow has very limited appeal.  Unfortunately, 
on systems running with the IBM Color Graphics Adapter (tm), 
direct accesses to video memory will produce quick bursts of 
"snow."  The IBM Technical Reference Manual (2.02) describes it 
this way: 

        The processor and the display control unit have 
        equal access to the display buffer during all the 
        operating modes, except the high-resolution 
        alphanumeric mode.  During this mode, the processor 
        should access the display buffer during the vertical 
        retrace time.  If it does not, the display will be 
        affected with random patterns . . . (p 1-146) 

Programs that do direct video I/O only during vertical retrace 
will indeed avoid all snow affects.  They will also avoid much of 
the speed gained from using the direct I/O technique, unless the 
amount of text written is slight.  When reading or writing a full 
screen's worth of text, the loss of speed is painfully noticable 
if programs wait for vertical retrace before performing I/O 
operations.  

All is not grim, however.  Boosters makes it easy for Turbo 
Pascal programmers to build screens on the heap, then display 
them almost instantly, without snow, on a color display (or, of 
course, a monochrome display).  Please see the section on Heap I/O 
for details.  

The Boosters demo program, BoDemo, uses Heap I/O techniques to 
move large amounts of data to and from the screen.  


BOOSTERS PRODUCTION RELEASE

Heap I/O support is a major component of Boosters' Special-
Purpose section.  Other notable members of this group include 
Exec, which allows programs to call other programs as if they 
were procedures, and Timer, which can add time-controlled 
processing to your programs.  
 
The addition of the special-purpose routines to the original 
string and video group make up the production release of 
Boosters--43 routines in all.  

As a supplement to the technical descriptions of Section 3, 
please refer to the Boosters demo program, BoDemo, and to the 
individual example programs included on the distribution 
diskette.  
.pa 
                      SECTION 1 - GETTING STARTED



WHAT'S ON THE DISTRIBUTION DISKETTE

The diskette you received with your Boosters order contains 
files that are classified as follows:

     (A)  The complete collection of the Boosters routines, 
          contained in a file named Boosters.pas.

     (B)  The above collection split into files for each 
          Booster function and procedure.  The Exec 
          procedure, for example, resides on a file named
          Exec.pas; the Upper function can be found on
          Upper.pas--and so on.

     (C)  A file of variable, type, and constant declarations
          that Boosters needs to run--named BoDecl.pas.

     (D)  .COM files needed for the external procedures.

     (E)  A program that demonstrates Boosters, BoDemo.pas and
          BoDemo.com.  These programs perform the same except
          for the Exec procedure, which will only run from 
          BoDemo.com under Turbo Pascal Version 3.0.  (The Exec
          call is commented out in the .pas version.)

     (F)  Small programs illustrating how each Boosters routine
          works.  All were tested, saved, then copied directly
          to the appropriate example sections of this Users Guide
          to ensure reproduction integrity.

     (G)  Source files for the Boosters assembler routines.  
          Due to directory space limitations, the assembler
          source files are stored in a subdirectory named
          BoAsm.

There are over 115 files on the distribution diskette.
.pa
                      SECTION 1 - GETTING STARTED    


WHAT TO DO FIRST--BACKUP

The distribution diskette is not copy-protected, so either 
DiskCopy or Copy will work fine.  Copy the original diskette and 
put it safely away.  

You will probably find it most convenient to keep Boosters right 
with Turbo Pascal--on the same diskette or subdirectory.  At a 
minimum, copy Boosters.pas, BoDecl.pas, and the Boosters .com 
files.  If there is sufficient disk space for the individual 
routines (category B above), we recommend you transfer those as 
well.  


     Note: The Exec procedure requires that a copy of 
           Command.com (version 2.0 or higher) be present on 
           the default disk drive.  The Command processor 
           loads and passes control to the program you 
           choose to execute.  


Having backed up your distribution diskette and copied Boosters to 
a convenient working location, fire up the demo program, 
BoDemo.com, and let it run for awhile.  Working examples are a 
great benefit to understanding.  You may find it convenient to 
clone parts of BoDemo.pas for your own programs.  
.pa
                       SECTION 2 - GROUND RULES



SOME NOTES ON VIDEO

Since Boosters addresses video memory frequently, it might be 
helpful to cover a few basics about the display area.  

1.  Boosters video operations assumes a screen size of 80 columns 
by 25 rows (80x25).  In keeping with standard notational 
conventions, (1,1) refers to the upper left corner of the screen 
or current window, while (80,25) references the lower right.  The 
variable X refers to the column, Y to the row, so that for X = 30   
and Y = 10, for instance, we mean column 30, row 10 (30,10). 

2.  Boosters will run with the IBM Color/Graphics Adapter, the
the IBM Monochrome Adapter, the IBM Enhanced Graphics Adapter, and
on most compatibles.  It was developed on a 256K Compaq.

3.  Each character in video memory has an attribute byte, located 
at the next higher address, that controls how the character will 
be displayed.  For the Color/Graphics Adapter and compatibles, 
this attribute byte can blink, color, or intensify the character, 
and can color the character background.  

Blinking and intensity are available on the Monochrome Adapter, 
but color is interpreted as shown below:

        Attribute Byte Setting          Monochrome Shows
           white-on-black                  normal
           black-on-white                  reverse video
           blue-on-black                   underlining
           black-on-black                  nothing


The format of the attribute byte is presented below.  A bit value 
of 1 activates a feature, while 0 turns it off.

               Bit Number
                    7         Blinking foreground
                    6         Red background
                    5         Green background
                    4         Blue background
                    3         Intensity foreground
                    2         Red foreground
                    1         Green foreground
                    0         Blue foreground
.pa
A frequently used attribute setting is 14 (hex 0E), which 
produces an intensified yellow over a black background.  Turbo 
Pascal includes a set of 16 predefined constants for designating 
colors, which you may find helpful.  See page 161 of the version 
3.0 manual for details.  

Boosters' Set Attribute (SetAtt) procedure gives you easy control 
over the character attributes.  With SetAtt, you can set attributes 
in blocks as small as a single character or as large as the entire 
screen.  
.pa
                       SECTION 2 - GROUND RULES



HEAP I/O

Heap I/O describes a programming technique that consists of building 
or modifying screen displays on a page of the heap, then copying the 
page to video memory.  For programs targeted to both monochrome and 
color monitor systems, this technique provides a common approach to 
fast screen output.  The steps involved are:

        STEP                            TURBO/BOOSTERS EXAMPLE
                                             
        1.  Mark current top            Mark ( HeapTop );
  
        2.  Allocate pages              For i := 1 to Npage do
                                           New ( Page[i] );

        3.  Build screens               
            a.  Initially               FillHeap ( page[1], ... ); 
                                        BoxHeap  ( page[1], ... );
                                        (*  and so on  *)

            b.  Modify existing         SaveScreen ( page[1] );
                screen                  MblkHeap   ( page[1], ... );
                                        (*  perhaps more  *)

  
        4.  Display any page            RestoreScreen ( page[1] );
  
        5.  Release heap memory         Release ( HeapTop );
            when finished

Boosters has a number of routines that assist programmers in 
developing sophisticated screen displays on the heap.  With one 
exception, each heap routine is a clone of some other Boosters 
routine.  

For example, procedure Calendar, which generates and displays a 
calendar for any month and year, has a corresponding heap routine 
called CalHeap.  Both routines are identical except for the address of 
their output.  Calendar sends its results to video memory, while 
CalHeap places its output on a specified page of the heap.  
.pa
        NOTE: All heap routines have as their first argument
              the page of the heap to which output is sent. 
              The remaining arguments match those of their     
              corresponding video routine one-for-one.

              Thus, in the case of Calendar and CalHeap, their
              statements might appear as:

              Calendar ( 11, 1985, 30, 10 );
              CalHeap  ( page[1], 11, 1985, 30, 10 );

To view the results of CalHeap, of course, we must eventually copy 
page[1] to video memory, an operation which RestoreScreen performs 
almost instantly.

The one heap routine that has no Boosters clone is FillHeap, which is 
useful for initializing a page of heap memory quickly.  FillHeap is 
similar to Turbo Pascal's FillChar but differs in that it treats the 
heap as having the character/attribute nature of video memory.  Please
see section 3 for details on FillHeap.

The following table pairs Boosters video routines with their 
corresponding heap routines.  Please remember that heap memory must 
first be allocated (via New) before it can be used.

             Video              Heap            Purpose

             CopyBlk            CblkHeap        Copies a video block
             MoveBlk            MblkHeap        Moves  a video block
             SetAtt             HeapAt          Set block attributes
             PutStr             PutHeap         Writes a string
             GetStr             GetHeap         Reads a string
             Calendar           CalHeap         Creates a calendar
             Boxul              BoxHeap         Draws a box
             FindStr            FstrHeap        Finds a string
.pa

                               SECTION 3

                   DESCRIPTIONS OF BOOSTERS ROUTINES




The examples in this section can be found on the Boosters 
distribution diskette.  The file names begin with an X.  The 
routine for PutStr, for instance, is named XPutStr.  



A SUGGESTION

If you are new to Boosters, you might find it helpful to run 
the example programs as you read about them.  Make sure 
BoDecl.pas and all the Boosters .pas files (PutStr.pas, 
GetStr.pas, etc.) are on the default drive and directory when 
you run the examples.  Because the examples are generally 
simple, the routines they implement are easy to understand.  

Please pay particular attention to the uses of Heap I/O 
( XBoxUl.pas, XFillHep.pas ).  
.pa
                                 BODECL


Purpose:     Declarations for Boosters Utilities.

Const
   H  = 'H';                  (*  Code for horizontal PutStr & GetStr *)
   V  = 'V';                  (*  "    "   vertical   "      " "      *)
   StartElapsed : Boolean = FALSE;
                              (*  Initial value for timer function    *)
   Npage = 2;                 (*  Number of heap pages                *)

Type
   AnyString   =  string[255];
   HeapBuf     = ^AnyBuf;
   AnyBuf      =  Record
                     Screen : array[1..4000] of byte;
                  end;
   ColumnType  =  1..80;      (* With $R directive active, *)
   RowType     =  1..25;      (* keeps video routines in line *)
   result      =  Record
                     AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer;
                  end;

Var
   TimeElapsed,               (* Used by Timer . . . *)
   SaveElapsed,               (* "    "  "           *)
   Ecode,                     (* "    "  Exec for error return *)
   I                          (* the ubiquitous index variable  *)
                     : Integer;
   SaveX                      (*  handy for saving WhereX result *)
                     : ColumnType;
   SaveY                      (*  "     "   "      WhereY "      *)
                     : RowType;
   Xheap             : ColumnType;
   Yheap             : RowType;
   HeapTop           : ^Integer;  (*  for marking current top of heap *)

   Ch                         (*  as in read(Kbd,ch) after KeyPressed *)
                     : Char;
   Page                       (*  screens for Heap I/O                *)
                     : array[1..Npage] of HeapBuf;

   VideoStatus       : byte   absolute $0000:$0449;
   MonoBuffer        : AnyBuf absolute $B000:0000;
   GraphicsBuffer    : AnyBuf absolute $B800:0000;
   Regs              : Result;

   S,                         (*  general string array *)
   FileDesc,                  (*  File name and extension for EXEC *)
   ComLine                    (*  Command Line setting for EXEC    *)
                     : AnyString;
.pa
                                 BOXUL


Declaration: Procedure BoxUL ( X1 : ColumnType;
                               Y1 : RowType;
                               X2 : ColumnType;
                               Y2 : RowType; 
                               Style,
                               Attribute : Integer); 

Purpose:     Draws a box (rectangle) in a given style with sides
             in specified attribute.

             Notes:
             1.  X1,Y1 and X2,Y2 designate the coordinates of the 
                 upper left and lower right corners, 
                 respectively, of the box to be drawn.

             2.  Style is a value from 1 to 4 that controls   
                 which set of box drawing characters to use.
                    
                 Style = 1 for single lines on all sides.
                 Style = 2 for double lines on all sides.
                 Style = 3 for double-lined vertical sides
                           and single-lined horizontal sides.
                 Style = 4 for single-lined vertical sides
                           and double-lined horizontal sides.

             3.  The area enclosed by the box is not 
                 initialized.

             4.  A box must have at least 3 columns and 3 rows.

.pa
Example:     Draw concentric boxes with Boxul then with Heap I/O.

             (*$IBoDecl   *)
             (*$IPutStr   *)
             (*$ICopies   *)
             (*$IFillHeap *)
             (*$IPutHeap  *)
             (*$IRestores *)
             (*$IBoxHeap  *)
             (*$IBoxul    *)

             BEGIN

                ClrScr;
                PutStr ( h, 'USING BOXUL', 35, 12, 14 );
                for i := 0 to 8 do
                   boxul ( 5 + (3*i), 2+i, 75 - (3*i), 23-i ,
                           Random(4)+1, Yellow );
                ClrScr;
                Mark ( HeapTop );
                New ( Page[1] );
                FillHeap ( Page[1], 1,1,80,25,#32,14 );
                for i := 0 to 8 do
                   boxHeap ( page[1], 5 + (3*i), 2+i, 75 - (3*i), 23-i ,
                             Random(4)+1, Yellow );
                RestoreScreen ( page[1] );
                PutStr ( h, 'USED BOXHEAP', 35, 12, 14 );
                Release ( HeapTop );

             END (* XBoxul *) .

.pa
                                 CALENDAR


Declaration: Procedure Calendar ( MM, CCYY, X, Y : Integer ); 

Purpose:     Generates a calendar for month MM of year CCYY,
             then displays it with upper-left coordinates X,Y.

             Notes:
             1.  The calendar size is 22 columns, 15 rows.

             2.  The calendar display includes trailing days from 
                 the previous month and the first days of the 
                 following month.

             3.  CALHEAP generates calendars on a page of the 
                 heap.

Example:     Display the U.S.A. Bicentennial month.  


             (*$IBodecl   *)
             (*$IPutStr   *)
             (*$IStrip    *)
             (*$ICopies   *)
             (*$IBoxul    *)
             (*$IDows     *)
             (*$ICenter   *)
             (*$ICalendar *)

             BEGIN

               ClrScr;
               Calendar ( 7, 1976, 29, 5 );

             END (* XCalenda *) .
.pa
                                  CENTER


Declaration: Function Center ( S : AnyString; 
                               N : Integer;
                             Pad : Char ) : AnyString;

Purpose:     Returns a string of length N with S centered in it.
             Pad is added as necessary to fill out length.


             Notes:
             1.  AnyString is Type string[255].
                                                       
             2.  If length(S) > N, then the first N characters 
                 are returned.

Example:     Center numbers 1 through 8 within 10-byte fields 
             on first line of screen.

             (*$IBoDecl *)
             (*$ICenter *)
             (*$IPutStr *)

             BEGIN

                for i := 1 to 8 do
                begin
                   str ( i, S );
                   PutStr ( h, Center ( S, 10, ' '),
                               1 + (i-1) * 10, 1, 112 );
                end;
                read;

             END (* XCenter *) .

.pa
                                  COPIES


Declaration: Function Copies ( C : Char;
                               N : Integer ) : AnyString;

Purpose:     Returns N concatenated copies of C.

             Notes:
             1.  AnyString is Type string[255].
             2.  See CopyStr for concatenating strings.

Example:     Add vertical columns to the Center example.

             (*$IBoDecl *)
             (*$ICenter *)
             (*$IPutStr *)
             (*$ICopies *)

             BEGIN
                ClrScr;
                for i := 1 to 8 do
                begin
                   str ( i, S );
                   PutStr ( h, Center ( S, 10, ' '), 
                            1 + (i-1) * 10, 1, 112 );

                   PutStr ( v, Copies ( #179,24),
                            1 + (i-1) * 10, 2, 14 );
                end;
                read;

             END (* XCenter *) .
.pa
                                 COPYBLK


Declaration: Procedure CopyBlk ( X1 : ColumnType;
                                 Y1 : RowType;
                                 X2 : ColumnType;
                                 Y2 : RowType;
                                 X3 : ColumnType;
                                 Y3 : RowType ) ;

Purpose:     Copies block at screen location X1,Y1 (upper left)               
             and X2,Y2 (lower right) to screen location beginning
             at upper left coordinates X3,Y3.


Example:     Create a box and copy it, first with CopyBlk, then 
             with Heap I/O. 

             (*$IBoDecl   *)
             (*$IPutStr   *)
             (*$ICopies   *)
             (*$IBoxul    *)
             (*$ICopyBlk  *)
             (*$ICblkHeap *)
             (*$ISaves    *)
             (*$IRestores *)

             BEGIN

                Mark ( HeapTop );
                New ( page[1] );

                ClrScr;
                Boxul   ( 1, 1, 18, 10, 1, Yellow );
                CopyBlk ( 1, 1, 18, 10, 1, 12 );
                SaveScreen ( page[1] );
                read;
                for i := 1 to 3 do
                begin
                   CopyBlk ( 1, 1, 18, 10, 21+(i-1)*20, 1 );
                   CopyBlk ( 1, 1, 18, 10, 21+(i-1)*20, 12 );
                end;
                read;
                ClrScr;
                read;

                for i := 1 to 3 do
                begin
                   CblkHeap ( page[1], 1, 1, 18, 10, 21+(i-1)*20, 1 );
                   CblkHeap ( page[1], 1, 1, 18, 10, 21+(i-1)*20, 12 );
                end;
                RestoreScreen ( page[1] );
                Release ( HeapTop );
             END (* XCopyBlk *) .
                                 COPYSTR


Declaration: Function CopyStr ( S : AnyString;
                                N : Integer ) : AnyString;

Purpose:     Returns N concatenated copies of S.

             Notes:
             1.  AnyString is Type string[255]. 
             2.  See Copies for concatenating characters.

Example:     Section the screen.

             (*$IBoDecl  *)
             (*$IPutStr  *)
             (*$ICopies  *)
             (*$ICopyStr *)

             Procedure BoCells ( y : RowType );
             var
                Spacer : AnyString;
                N      : Integer;
             begin
                S := Copies(#196,9)+#197;
                PutStr ( h, CopyStr ( S,8 ), 1, y, 14 );
                Spacer :=   CopyStr ( '         '+#179, 8);
                for  n := 1 to 5 do
                   PutStr ( h, Spacer, 1, y+n, 14 );
             end;

             BEGIN

                ClrScr;
                BoCells ( 1 );
                BoCells ( 6 );
                BoCells ( 11 );
                BoCells ( 16 );
                BoCells ( 21 );
                Read;

             END (* XCopyStr *) .
.pa

                             CURSOR ROUTINES


Declaration: Procedure CursorOff;
             Procedure CursorOn;
                    

Purpose:     CursorOff hides the cursor, CursorOn makes it 
             visible.           

Example:     Turn the cursor off, then turn it on when user   
             strikes the Enter key.

             (*$IBoDecl *)
             (*$ICursor *)
             (*$IPutStr *)
             (*$ICopies *)
             (*$IBoxul  *)

             BEGIN

                ClrScr;
                CursorOff;
                Boxul (30,8,50,16,3,14);
                PutStr (h, 'Press RETURN',34,10,14);
                PutStr (h, 'to get cursor',33,12,14);
                PutStr (h, 'BACK',38,14,14);
                read;
                CursorOn;

             END (* XCursor *) .

.pa
                                   DOWS


Declaration: Function Dows ( MM, DD, CCYY : Integer) : AnyString;
                    

Purpose:     Returns day of the week (Sunday, Monday, etc.) for
             any valid date.    

             Notes:
             1.  MM and DD must be within usual ranges for month 
                 and day.  CCYY is 4-digit year (e.g., 1980, not 
                 80).

Example:     Compute day of the week for user input.  Pressing 
             return at the prompt ends session.

             (*$IBoDecl *)
             (*$IDows   *)
             (*$IPutStr *)
             (*$IStrip  *)

             var
                mm, dd, ccyy, len : integer;

             BEGIN

                ClrScr;
                Repeat
                   PutStr (h,'Enter the numeric value for any '+
                      'month, day and year',1,1,14);
                   PutStr (h,'separated by spaces: ',1,2,14);
                   ClrEol;
                   read ( s );
                   if length(s) > 0 then
                   begin
                      s   := strip ( S, ' ');
                      len := pos(' ',S) - 1;
                      val (copy (s,1,len),mm,ecode);
                      s := copy (s,len+2,50);
                      len := pos(' ',s) - 1 ;
                      val (copy (S,1,len),dd,ecode);
                      len := length(s) - pos(' ',s);
                      val (copy (S,length(s)-len+1,len),ccyy,ecode);
                      if ccyy < 100 then
                         ccyy := ccyy + 1900;
                      PutStr (h,'Day of the week is '+
                                 dows(mm,dd,ccyy),1,4,14); 
                   end;
                until length(s) = 0;

             END (* XDows *) .
.pa
                                   EXEC


Declaration: Procedure Exec ( FileDescription,
                              CommandLine : AnyString;
                              Ecode       : Integer); 

Purpose:     Loads another program into memory and executes it,
             then returns control to the invoking program.

             Notes:
             1.  This is only available when issued from
                 a .COM file under Turbo Pascal release 3.0.

             2.  FileDesc contains the drive, directory, file
                 name and extension of the program to
                 execute.

             3.  CommandLine specifies the DOS command line
                 that Exec will pass to the command processor
                 for execution.

             4.  Ecode = 0, execution was successful.
                 Ecode = 1, improper parameters.


Example 1:   Format a disk on the B: drive

             (*$IBoDecl *)
             (*$IExec   *)

             BEGIN
                FileDesc := 'COMMAND.COM';
                ComLine  := 'COMMAND /C FORMAT B:';

                Exec (FileDesc, CommandLine, Ecode);
             END.


Example 2:   Execute the Norton Utilities' DiskLook (C). 

             (*$IBoDecl *)
             (*$IExec   *)

             BEGIN
                Filedesc := 'command.com';
                ComLine := 'command /c DL B:';

                Exec (FileDesc, ComLine, Ecode);

                Write(' Hello from Boosters');
             END.
.pa
Example 3:   Execute Turbo Pascal (C).

             (*$IBoDecl *)
             (*$IExec   *)

             BEGIN

                Filedesc := 'B:TURBO.COM';
                Exec (FileDesc, ComLine, Ecode);
                Write(' Hello from Boosters');

             END (* XExec *) .
.pa
                              FILLHEAP



Declaration: Procedure FillHeap ( Page : HeapBuf;
                                    X1 : ColumnType;
                                    Y1 : RowType;
                                    X2 : ColumnType;
                                    Y2 : RowType;
                                     C : Char;
                                     A : Integer);

Purpose:     Generates characters C with video attribute A on Page 
             of the heap, from (X1,Y1) to (X2,Y2).

             Notes:
             1.  FillHeap is useful for initializing a page on the heap.

Example:     Generate and display alphabet screens A - Z.

             (*$IBoDecl   *)
             (*$IRestores *)
             (*$IFillHeap *)

             BEGIN

                Mark ( HeapTop );
                New ( Page[1] );
                for i := 1 to 26 do
                begin
                   FillHeap ( Page[1], 1, 1, 80, 25,
                              Chr(64+i), 7 );
                   RestoreScreen ( Page[1] );
                   delay(150);
                end;
                Release ( HeapTop );

             END (* XFillHep *) .
.pa
                               FINDSTR


Declaration: Procedure FindStr (  X : ColumnType;
                                  Y : RowType;
                              VAR S : AnyString;
                                  N ,
                              Ecode : Integer);  

Purpose:     Search for S in video memory, beginning at (X,Y).
             If S found, cursor is placed at offset N from S and 
             Ecode is set to zero.  Ecode is one when S is not 
             found.

             Notes:
             1.  For N > 0, offset is calculated from end of S.
                 Cursor will be positioned at length(S) + N.
                 For instance, for N = 1, the cursor will be 
                 placed at S[length(S)+1].

             2.  For N = 0, the cursor is placed at S[1].

             3.  For N < 0, offset is calculated from beginning
                 of S.  Cursor will be placed at S[1] + (-N).
                 Given N = -1, the cursor will be positioned at
                 the display coordinate immediately preceding 
                 S[1].

             4.  If the value of N is such that it would place the 
                 cursor offscreen, FindStr places the cursor at 
                 either the beginning of the display screen or at 
                 the end, whichever is closer to S.

             5.  FindStr's heap clone is FstrHeap.  
                 
                 Procedure FstrHeap ( Page : HeapBuf;
                                     VAR S : AnyString;
                                 VAR Xheap : ColumnType;
                                 VAR Yheap : RowType;
                                         N , 
                                     Ecode : Integer); 
                                     external 'FstrHeap.com';
                 
                 With FstrHeap, the search always begins at (1,1)
                 on the heap.  If S is found, Xheap and Yheap are
                 set and ecode = 0.  For S not found, ecode = 1.
                 See BoDemo.pas for uses of FstrHeap.
.pa
Example:     Demonstrate string find capability.


             (*$IBoDecl  *)
             (*$IFindStr *)
             (*$IGetStr  *)
             (*$IPutStr  *)

             BEGIN

                Randomize;
                ClrScr;
                PutStr (v,'I AM VERTICAL',Random(80)+1,1,7);
                FindStr (1,1,'I',0,Ecode);
                GetStr (v,S,0,0,13);
                read;                                          
                insert ('NO LONGER ',S,6);
                PutStr (h,S,1,15,14);

             END (* XFindStr *) . 
.pa

                                  GETSTR


Declaration: Procedure GetStr (  HV : Char;
                              VAR S : AnyString;
                                  X : ColumnType;
                                  Y : RowType;
                                LEN : Integer);

Purpose:     Loads contents of video memory into S, beginning 
             at coordinates X,Y for length LEN.

             Notes:
             1.  Direction of read operation is set by HV, which 
                 will be horizontal when HV = 'H', vertical when 
                 HV = 'V'.  Constants H and V are set in
                 Boosters Declaration File (BoDecl). 

             2.  If X and Y are both zero, read operation begins 
                 at current position.

             3.  GETHEAP is the Heap I/O clone of GetStr.  With
                 GetHeap, X and Y cannot be zero, nor is there any
                 positioning of the cursor.


Example:     Write and read a column of vertical text.

             (*$IBoDecl *)
             (*$IGetStr *)
             (*$IPutStr *)

             BEGIN

                ClrScr;
                PutStr (v,'I AM VERTICAL',1,1,7);
                GetStr (v,S,1,1,13);
                read;
                insert ('NO LONGER ',S,6);
                PutStr (h,S,1,15,14);

             END (* XGetStr *) .  
.pa
                               LEFT


Declaration: Function Left ( S : AnyString;
                           LEN : Integer;
                           PAD : Char) : AnyString;


Purpose:     Left-justifies and pads (if necessary) S in the
             result. 


Example:     Create a sample input form.

             (*$IBoDecl *)
             (*$ILeft   *)
             (*$IPutStr *)

             BEGIN

                ClrScr;
                PutStr (h,left('Name ',60,'_'),5,1,14);
                PutStr (h,left('Street ',60,'_'),5,2,14);
                PutStr (h,left('City, State, and Zip ',60,'_'),
                        5,3,14);
                read;

             END (* XLeft *) .
.pa
                              MOVEBG

Declaration: Procedure MoveBg (  Page  :  HeapBuf;
                                   X1  :  ColumnType;
                                   Y1  :  RowType;
                                   X2  :  ColumnType;
                                   Y2  :  RowType;
                                   X3  :  ColumnType;
                                   Y3  :  RowType);

Purpose:     Moves the block at X1,Y1 (upper left) and
             X2,Y2 (lower right) of the current screen
             to block beginning at X3,Y3 (upper left) o page.
                                      
             Notes:
             1.  When MoveBg is called, the block at X1,Y1,X2,Y2
                 is saved on the stack, the screen defined by 
                 page is copied to video memory, then the block 
                 on the stack is written to the screen.

Example:     Overlay some boxes, then move one from the other
             incrementally.

             (*$IBoDecl *)
             (*$IScreen *)
             (*$IPutStr *)
             (*$ICopies *)
             (*$IBoxul  *)
             (*$ISetAtt *)
             (*$IMoveBg *)

             BEGIN
                Mark ( HeapTop );
                New ( page[1] );
                ClrScr;
                Boxul ( 20, 8, 37, 16, 1, 14);
                for i := 9 to 15 do
                   PutStr ( h, Copies ( '',16),21, i, 14);
                SetAtt ( 38, 9, 40, 17, 30);
                SetAtt ( 21, 17, 40, 17, 30);
                Read;
                SaveScreen ( page[1] );
                Boxul ( 20, 8, 37, 16, 1, 14);
                for i := 9 to 15 do
                   PutStr ( h, Copies('',16),21, i, 7);
                Read;
                for i := 1 to 16 do
                begin
                   Movebg ( page[1], 20+(i-1)*2, 8, 40+(i-1)*2, 17, 
                            22+(i-1)*2, 8 );
                   delay(04);
                end;
                Release( HeapTop );
             END (* XMoveBg *) .
                               MOVEBLK


Declaration: Procedure MoveBlk ( X1  :  ColumnType;
                                 Y1  :  RowType;
                                 X2  :  ColumnType;
                                 Y2  :  RowType;
                                 X3  :  ColumnType;
                                 Y3  :  RowType);


Purpose:     Moves the block defined by X1,Y1,X2,Y2 (upper-
             left and lower-right coordinates) to location
             X3,Y3 (upper-left).

             
             Notes:
             1.  The original block (X1,Y1,X2,Y2) is saved on
                 the stack, erased from video memory, then copied 
                 to (X3,Y3).  By contrast, see CopyBlk description. 
             2.  To move blocks on the heap, use MblkHeap.

Example:     Relocate three boxes.

             (*$IBoDecl  *)
             (*$IMoveBlk *)
             (*$IPutStr  *)
             (*$ICopies  *)
             (*$IBoxul   *)

             BEGIN

                ClrScr;
                BoxUl ( 1,1, 8, 7,3,14);
                BoxUl ( 10,1,17, 7,3,14);
                BoxUl ( 19,1,26, 7,3,14);
                PutStr (h,'Press enter to move boxes',1,9,14);
                read;
                MoveBlk (1,1,26,7,1,12);

             END (* XMoveBlk *) .
.pa
.fi boref2.pas
