{ ----------------------------
  WORDIND returns the position
  of WordNumber in S.
  ---------------------------- }
Function WordInd (          S : AnyString;
                   WordNumber : Integer ) : Integer;

{ Example: if S = 'I like Turbo Pascal' then
              WordInd ( S, 3 ) = 8.  }

var
   NumWords,  CurrentAddress, Len, Index
             : integer;
   NonBlank :  Boolean;

begin
   Len := Length(S);
   if Len = 0 then
      WordInd := 0
   else
   begin
      Index := 0;
      NumWords := 0;
      CurrentAddress := 0;
      NonBlank := false;
      repeat
         CurrentAddress := CurrentAddress + 1;
         if NonBlank then
         begin
            if S[CurrentAddress] = #32 then
               NonBlank := false;
         end
         else
         if S[CurrentAddress] <> #32 then
         begin
            NumWords := NumWords + 1;
            if NumWords = WordNumber then
               Index := CurrentAddress;
            NonBlank := true;
         end;
      until (CurrentAddress = Len) or (Index > 0);
      WordInd := Index;
   end;
end { WordInd };