{ ------------------------------------------
  WORD returns a string that is word N of S.
  ------------------------------------------ }
Function Word  ( S : AnyString;
                 N : Integer ) : AnyString;

var
   NumWords, start, stop, CurrentAddress, len
             : integer;
   Ts
             : AnyString;
   BlankFound
             : Boolean;


begin
   if Length(S) = 0 then
      Word := ''
   else
   begin
      NumWords := 0;
      start := 1;
      len := length(S);
      stop := len;
      BlankFound := True;
      CurrentAddress := 0;

      repeat
         CurrentAddress := CurrentAddress + 1;
         if BlankFound then
         begin
            if S[CurrentAddress] <> #32 then
            begin
               BlankFound := false;
               NumWords := NumWords + 1;
               if NumWords = N then
                  start := CurrentAddress;
            end;
         end
         else
         if S[CurrentAddress] = #32 then
         begin
            BlankFound := true;
            if NumWords = N then
               stop := CurrentAddress;
         end;
      until (stop < len) or (CurrentAddress = len);

      if N > NumWords then
         Word := ''
      else
      begin
         if S[stop] <> #32 then
            stop := succ(stop);
         Word := copy ( S, start, stop - start );
      end;
   end;
end { Word };