{ ----------------------
  TIMER Boolean Function
  ---------------------- }
Function Timer ( Limit : integer) : Boolean;

{ Note: Globals are:
                 Type
                    Result  = record
                                AX, BX, CX, DX, BP,
                                SI, DI, DS, ES, Flags : Integer;
                              end;
                 var
                    regs : result;
                    TimeElapsed,
                    SaveElapsed   : Integer;
                    StartElapsed  : Boolean = FALSE;
}
var
   SecondsReading : Integer;

begin
   with regs do
   begin
      if Limit <= 0 then
         Timer := TRUE
      else
      begin
         Timer := FALSE;
         ax := $2C00;
         intr($21,regs);

         if StartElapsed = FALSE then
         begin
            SaveElapsed  := hi(dx);
            TimeElapsed  := 0;
            StartElapsed := TRUE;
            ax := $2D00;                { Set time . . .            }
            dx := Swap(SaveElapsed);    { With hundredths = 0 . . . }
            intr($21,regs);             { so that we start from 0   }
            delay(70);                  { Helps DOS 3.1 work right  }
         end
         else
         if SaveElapsed <> hi(dx) then
         begin
            SecondsReading := hi(dx);
            if SaveElapsed > SecondsReading then
               SecondsReading := SecondsReading + 60;
            TimeElapsed := TimeElapsed + SecondsReading - SaveElapsed;
            SaveElapsed := hi(dx);

            if TimeElapsed >= Limit then
            begin
               Timer := TRUE;
               StartElapsed := FALSE;
            end;
         end;
      end;
   end;
end { Timer };