;**********************************************
;
;       Type
;          AnyString = string[255];
;
;       Function Strip ( S : AnyString;
;                        C : Char) : AnyString;
;
;       Returns a string equal to S with leading
;       and trailing characters C removed.
;
;**********************************************
STRIP	proc	near
	push	bp
	mov	bp,sp
	push	ds
;
;*** Scan left-side of string for 1st
;*** character <> arg C
;
	lea	di,[bp+7]	; 1st char of S
	mov	cl,[bp+6]	; len of S
	xor	ch,ch
	mov	ax,ss
	mov	es,ax
	mov	ax,[bp+4]	; C in AX
	cmp	cx,1
	ja	s001
;
        mov     bl,[bp+7]
	xor	bh,bh
	cmp	ax,bx
	je	null_s
	mov	dx,di
	jmp	s002

S001:	cld
repe	scasb		; find mismatch
	jcxz	null_s
	dec	di
	mov	dx,di		; save offset
;
;*** Scan right-side of string for 1st
;*** character <> arg C
;
	mov	cl,[bp+6]	; len of S
	xor	ch,ch
	lea	di,[bp+7]
	add	di,cx
	dec	di
	std
repe	scasb
	inc	di
;
;*** Move stripped-S into result
;
	mov	cx,di
	sub	cx,dx
	inc	cx		; len of stripped S
S002:	mov	[bp+262],cl	; set len in result
	mov	si,dx
	lea	di,[bp+263]
	mov	ax,ss
	mov	ds,ax
	cld
rep	movsb
	jmp	return
;
NULL_S: mov	[bp+262],0
;
RETURN: pop	ds
	mov	sp,bp
	pop	bp
	ret	258
STRIP	endp
