;*************************************************
;
;       Procedure SaveScreen (Var PAGE : HeapBuf);
;
;       Saves contents of screen
;       at heap location PAGE
;
;*************************************************
SaveS   proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;*** Determine Video address
;
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al,[bx]
	cmp	al,7
	jne	graphx
	mov	dx,0B000h
	jmp	c001
graphx:
	mov	dx,0B800h
c001:   mov     ds,dx
;
;*** Copy video memory to heap
;
	mov	di,[bp+4]
	mov	es,[bp+6]
	xor	si,si
	cld
	cmp	dx,0B800h
	je	cga
        mov     cx,2000
rep	movsw
	jmp	done
;
;***    Modified move for color monitor
;
CGA:	mov	bx,10
	mov	dx,03DAh
DO10:	mov	cx,200
VR2:	in	al,dx		; we must do this
	and	al,1000b	; so we won't see
	jz	vr2		; snow.
rep	movsw
	dec	bx
	jnz	do10
;
DONE:   pop     ds
        mov     sp,bp
        pop     bp
	ret	4
SaveS   endp
;
