{ ------------------------------
  RWORD returns a string with ST
  replacing word N of S.
  ------------------------------ }
Function RWord  ( S : AnyString;
                  N : Integer;
                 ST : AnyString ) : AnyString;

{   A word is any blank-delimited character sequence,
    or a string of non-blanks.  There are 7 words in
    this sentence. }

var
   NumWords, start, stop, CurrentAddress, len
             : integer;
   Ts, Ats, Tail
             : AnyString;
   BlankFound
             : Boolean;

begin
   if Length(S) = 0 then
      Rword := ''
   else
   begin
      len := Length(S);
      NumWords := 0;
      start := 1;
      stop := len;
      BlankFound := True;
      CurrentAddress := 0;
      repeat
        CurrentAddress := CurrentAddress + 1;
        if BlankFound then
        begin
           if S[CurrentAddress] <> #32 then
           begin
              BlankFound := false;
              NumWords := succ(NumWords);
              if NumWords = N then
                 start := CurrentAddress;
           end;
        end
        else
        if S[CurrentAddress] = #32 then
        begin
           BlankFound := true;
           if NumWords = N then
              stop := CurrentAddress;
        end;
     until (CurrentAddress = len ) or ( stop < len );
     if N > NumWords then
        Rword := S
     else
     begin
        Tail := copy ( S, stop, Length(S)-stop+1 );
        Ts := copy ( S, 1, start-1 );
        Ats := St;
        if (length(Ts) + length(St) + length(Tail)) > 255 then
           Ats := copy ( St, 1, 255 - length(Ts) - length(tail) );
        if S[stop] = #32 then
           Rword := Ts + Ats + Tail
        else
           Rword := Ts + Ats;
     end;
   end;
end { Rword };