;*************************************************
;
;       Procedure RestoreScreen (Var PAGE : HeapBuf);
;
;       Restores screen from heap location PAGE
;
;*************************************************
RestoreS proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;*** Determine Video address
;
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al,[bx]	 ; fetch video type
	cmp	al,7		; monochrome = 7
	jne	graphx
	mov	dx,0B000h
	jmp	c001
graphx:
	mov	dx,0B800h
c001:   mov     es,dx
;
;*** Copy PAGE from heap to video memory
;
	mov	si,[bp+4]
	mov	ds,[bp+6]
	xor	di,di
	mov	cx,2000	 ; length of move
	cld
	cmp	dx,0B800h	; CGA?
	je	cga		; yes
rep	movsw			; monochrome move
	jmp	done
;
;***    Modified move for color monitor
;
CGA:
	mov	dx,03DAh
RT_OFF: in	al,dx		; Wait for retrace
	and	al,1000b	; to begin . . .
	jz	rt_off
	dec	dx
	dec	dx
	mov	al,21h
	out	dx,al		; disable video
rep	movsw			; move page to screen
;
	mov	al,29h
	out	dx,al		; enable video
;
DONE:   pop     ds
        mov     sp,bp
        pop     bp
	ret	4
RestoreS endp
;
