;**********************************************************************
;
;       Procedure REMBLK (X1,Y1,X2,Y2 : Integer);
;                 offset  10,08,06,04  from BP
;
;       Blanks area of screen at X1,Y1 (upper left)
;                                X2,Y2 (lower right)
;**********************************************************************
REMBLK  proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;
;*** Compute number of lines to move
;
	mov	ax,[bp+08]	; value of Y1 into AX
	mov	dx,[bp+04]	; value of Y2 into CX
        sub     dx,ax           ; DX = Y2 - Y1
	inc	dx		; DX = Number of lines
	push	dx
;
;
;*** Compute length of each move
;
	mov	ax,[bp+10]	;  X1
	mov	cx,[bp+06]	;  X2
	sub	cx,ax		;  CX = X2 - X1
	inc	cx		;  CX = num WORDS/line
	push	cx
;
;*** Determine Video Address
;
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al, [bx]
	cmp	al,7
	jne	graphx
	mov	dx,0B000h
	jmp	m001
graphx:
	mov	dx,03DAh	; for IBM CGA,
VR:	in	al,dx		; we must do this
	and	al,1000b	; so we won't see
	jz	vr		; snow . . . and
	mov	dx,0B800h	; so long, speed
m001:	mov	es,dx
;
;*** Compute upper left offset of block
;
	mov	di,[bp+08]	;  Y1 into BX
        dec     di              ;  (Y1-1)
	mov	dx,di		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y1-1) * 128
	mov	cl,5
	shl	di,cl		;  (Y1-1) *  32
	add	di,dx		;  (Y1-1) * 160
	mov	ax,[bp+10]	;  X1 into AX
	dec	ax		;  (X1-1)
	shl	ax,1		;  2 * (X1-1)
	add	di,ax		;  offset
;
	pop	cx		; Num words/line
	pop	dx		; Num lines to blank
;
;*** Blank area on screen
;
	mov	ax,0E20h
	cld
AGAIN:	push	cx
rep	stosw
;
	pop	cx
	dec	dx
	jz	DONE2
	add	di,160
	sub	di,cx
	sub	di,cx
	jmp	AGAIN
;
DONE2:	mov	sp,bp
	sub	sp,2
        pop     ds
        mov     sp,bp
        pop     bp
	ret	8
REMBLK  endp
