;*******************************************************
;       type
;           AnyString  = string[255];
;           ColumnType = 0..80;
;           RowType    = 0..25;
;
;       Procedure PUTSTR (     HV : Char;
;                               S : AnyString;
;                               X : ColumnType;
;                               Y : RowType;
;                       Attribute : byte);
;*******************************************************
PutStr  proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;*** Determine Video address
;
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al,[bx]
	cmp	al,7
	jne	graphx
	mov	dx,0B000h
	jmp	c001
graphx:
	mov	dx,03DAh	; for IBM CGA,
VR:	in	al,dx		; we must do this
	and	al,1000b	; so we won't see
	jz	vr		; snow . . . and
	mov	dx,0B800h	; so long, speed
c001:	mov	es,dx
;
	mov	bx,[bp+8]	; X
	or	bx,bx		; X=0?
	jz	p001
;
;       set DH, DL
;
	dec	bx
	mov	ax,[bp+6]	; Y
	dec	ax
	mov	dh,al		; DH=Y
	mov	dl,bl		; DL=X
	jmp	P002
;
;       Get Current Cursor Position
;
P001:	mov	ah,3
	int	10h
;
;       Compute DI offset
;
P002:	mov	bl,dh		; Row (Y-1)
	xor	bh,bh
	mov	ax,bx
	mov	cl,7
	shl	ax,cl		; (Y-1) * 128
	mov	cl,5
	shl	bx,cl		; (y-1) *  32
	add	bx,ax		; (y-1) * 160
	mov	al,dl		; Column (X-1)
	xor	ah,ah
	shl	ax,1		; 2 * (X-1)
	add	bx,ax		; BX = offset
	mov	di,bx		; DI = offset
;
	mov	cl,[bp+10]	; length of string
	xor	ch,ch
	or	cx,cx		; if length is 0,
	jz	return		; leave PutStr
	lea	si,[bp+11]	; string offset
	push	ss
	pop	ds
	mov	ah,[bp+4]	; attribute byte
	mov	dx,[bp+266]	; direction (H or V)
	cmp	dl,'v'
	je	P003
	cmp	dl,'V'
	je	P003
	xor	dx,dx
	jmp	P003a
P003:	mov	dx,158
P003A:	cld
;
DO	mov	al,[si]	 ; get character
        stosw                    ; store on screen
	add	di,dx
	inc	si
	loop	DO
;
;       Set Cursor for exit
;
	or	dx,dx
	jz	P004
	sub	di,158
P004:	mov	ax,di
	xor	dx,dx
	mov	bx,160
	div	bx
	shr	dl,1
	mov	dh,al
	mov	ah,2
	int	10h
;
Return: pop	ds
        mov     sp,bp
        pop     bp
	ret	264
PutStr  endp
