;************************************************
;       type
;           AnyString  = string[255];
;           ColumnType = 0..80;
;           RowType    = 0..25;
;
;       Procedure PutHeap(   PAGE : HeapBuf;
;                              HV : Char;
;                               S : AnyString;
;                               X : ColumnType;
;                               Y : RowType;
;                       Attribute : byte);
;************************************************
PutHeap proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;*** Get Heap Address
;
	mov	di,[bp+268]
	mov	ax,[bp+270]
	mov	es,ax
;
	mov	dl,[bp+8]	; X
	dec	dl
	mov	dh,[bp+6]	; Y
	dec	dh
;
;       Compute DI offset
;
P002:	mov	bl,dh		; Row (Y-1)
	xor	bh,bh
	mov	ax,bx
	mov	cl,7
	shl	ax,cl		; (Y-1) * 128
	mov	cl,5
	shl	bx,cl		; (y-1) *  32
	add	bx,ax		; (y-1) * 160
	mov	al,dl		; Column (X-1)
	xor	ah,ah
	shl	ax,1		; 2 * (X-1)
	add	bx,ax		; BX = offset
	add	di,bx		; DI = offset
;
	mov	cl,[bp+10]	; length of string
	xor	ch,ch
	or	cx,cx		; if length is 0,
	jz	return		; leave PutHeap
	lea	si,[bp+11]	; string offset
	push	ss
	pop	ds
	mov	ah,[bp+4]	; attribute byte
	mov	dx,[bp+266]	; direction (H or V)
	cmp	dl,'v'
	je	P003
	cmp	dl,'V'
	je	P003
	xor	dx,dx
	jmp	P003a
P003:	mov	dx,158
P003A:	cld
;
DO	mov	al,[si] ;
        stosw                    ; store on screen
	add	di,dx
	inc	si
	loop	DO
;
Return: pop	ds
        mov     sp,bp
        pop     bp
	ret	268
PutHeap endp
