;***********************************************
;
;       FUNCTION OVERSTR   (NEW,
;                           TARGET : AnyString;
;                           N,LEN  : Integer;
;                           PAD    : Char)
;                                  : AnyString;
;
;       Description:
;               Returns a string with NEW
;               overlayed on TARGET,
;               beginning at position N of
;               TARGET, for length LEN.
;               If N > Length(Target), or if
;               LEN > Length(New), the result
;               is padded accordingly.
;
;       Examples:
;               OverStr('123','ABCD',2,2,' ')
;               would return 'A12D'.
;
;               OverStr('123',ABCD',6,6,'_')
;               would return 'ABCD_123___'.
;***********************************************
OVERSTR Proc
	push	bp
	mov	bp,sp
	push	ds
;
;***    set registers for string moves on the stack
;
	mov	ax,ss
	mov	es,ax
	mov	ds,ax
;
;***    move target string to result
;
	mov	cl,[bp+10]	; l'target
	xor	ch,ch
	lea	si,[bp+11]	; A(target)
	lea	di,[bp+523]	; A(result)
	cld
rep	movsb			; target to result
;
;***    if N or LEN <= 0, result = target
;
	mov	bl,[bp+10]	; l' target
	xor	bh,bh
	mov	cx,[bp+6]	; LEN
	cmp	cx,0
	jl	e020
	mov	dx,[bp+8]	; N
	cmp	dx,0
	jl	e020
;
;***    If N > Length(Target) + 1 then
;***    compute amount of PAD to insert
;
	lea	di,[bp+523]	; A(l'result)
	cmp	dx,bx		; N> l'target?
	jna	e010
;
;***    if N > 255, then N = 255
;
	cmp	dx,0FFh
	jbe	e005
	mov	dx,100h
;
e005:	mov	cx,dx
	sub	cx,bx		; N-l'target
	dec	cx
	mov	ax,[bp+4]	; pad
	add	di,bx		; point past target
rep	stosb
	lea	di,[bp+523]
;
;***    Adjust CX to point to address of
;***    result where NEW will appear
;
	mov	cx,[bp+6]	; LEN
	add	cx,dx		; LEN+N
	cmp	cx,0FFh
	ja	e007
	mov	cx,[bp+6]
	jmp	e010
;
e007:	mov	cx,0FFh
	sub	cx,dx
	inc	cx		; adj LEN
;
;***    Copy NEW to result
;
e010:	mov	al,[bp+266]	; l'new
	xor	ah,ah
	push	cx
	cmp	cx,ax		; LEN > l'new?
	jb	e015
        mov     cx,ax
e015:	lea	si,[bp+267]	; A(new)
	add	di,dx		; begin at N
	dec	di
rep	movsb			; move NEW
;
;***    If LEN > length(NEW) then PAD
;
	pop	cx		; LEN
	cmp	cx,ax		; LEN > l'new?
	jbe	e020
	add	ax,dx		; N + l'new
	cmp	ax,0FFh
	jnb	e020
	push	cx
	mov	al,[bp+266]	; l'new
	xor	ah,ah
	sub	cx,ax		; LEN-l'new
	mov	ax,[bp+4]	; pad byte
rep	stosb
	pop	cx
;
;***    Set the length of the result string
;
e020:	lea	cx,[bp+523]
	sub	di,cx
	cmp	di,bx
	ja	e025
	mov	di,bx
e025:	mov	ax,di
	mov	[bp+522],al	; l'result
;
	pop	ds
	mov	sp,bp
	pop	bp
	ret	518
OVERSTR endp