{ --------------------------------
  NSORBIT - Nancy's Orbiting Light
  -------------------------------- }
Procedure NsOrbit ( StartCol   , StartRow,
                    EndCol     , EndRow,
                    Style      , NumberOfSeconds : Integer);
Var
   NumberCols, NumberRows, I,
   RowDelay, ColDelay : Integer;
begin

   RowDelay := 3;
   ColDelay := 1;
   NumberCols := EndCol - StartCol + 1;
   NumberRows := EndRow - StartRow + 1;

   BoxUL (StartCol, StartRow, EndCol, EndRow, Style, 14);

   repeat
      for i := 0 to NumberCols - 1  do
      begin
         SetAtt ( StartCol+i, StartRow, StartCol+i, StartRow, 14);
         delay(ColDelay);
         SetAtt ( StartCol+i, StartRow, StartCol+i, StartRow,  0);
         delay(ColDelay);
         SetAtt ( EndCol-i, EndRow, EndCol-i, EndRow,  14);
         delay(ColDelay);
         SetAtt ( EndCol-i, EndRow, EndCol-i, EndRow,  0);
         delay(ColDelay);
      end;

      for i := 0 to NumberRows - 1  do
      begin
         SetAtt ( EndCol, StartRow+i, EndCol, StartRow+i, 14);
         delay(RowDelay);
         SetAtt ( EndCol, StartRow+i, EndCol, StartRow+i,  0);
         delay(RowDelay);
         SetAtt ( StartCol, EndRow-i, StartCol, EndRow-i, 14);
         delay(RowDelay);
         SetAtt ( StartCol, EndRow-i, StartCol, EndRow-i,  0);
         delay(RowDelay);
      end;

      for i := 0 to NumberCols - 1  do
      begin
         SetAtt ( StartCol+i, StartRow, StartCol+i, StartRow, 14);
         delay(ColDelay);
         SetAtt ( StartCol+i, StartRow, StartCol+i, StartRow,  0);
         delay(ColDelay);
         SetAtt ( EndCol-i, EndRow, EndCol-i, EndRow, 14);
         delay(ColDelay);
         SetAtt ( EndCol-i, EndRow, EndCol-i, EndRow,  0);
         delay(ColDelay);
      end;

      for i := 0 to NumberRows - 1  do
      begin
         SetAtt ( StartCol, EndRow-i, StartCol, EndRow-i, 14);
         delay(RowDelay);
         SetAtt ( StartCol, EndRow-i, StartCol, EndRow-i,  0);
         delay(RowDelay);
         SetAtt ( EndCol, StartRow+i, EndCol, StartRow+i, 14);
         delay(RowDelay);
         SetAtt ( EndCol, StartRow+i, EndCol, StartRow+i,  0);
         delay(RowDelay);
      end;
   until Timer(NumberOfSeconds) or KeyPressed;
   if KeyPressed then
   begin
      read(Kbd,ch);
      StartElapsed := FALSE;
   end;
   BoxUL (StartCol, StartRow, EndCol, EndRow, Style, 14);
end { NsOrbit };