;*****************************************************
;
;       Procedure MOVEBLK(X1,Y1,X2,Y2,X3,Y3: Integer);
;                 offset  14,12,10,08,06,04  from BP
;
;       Moves block from screen at X1,Y1,X2,Y2
;                               to X3,Y3
;*****************************************************
MoveBlk proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;
;*** Compute number of lines to move
;
	mov	ax,[bp+12]	; Y1
	mov	cx,[bp+08]	; Y2
        sub     cx,ax           ; CX = Y2 - Y1
	inc	cx		; Number of lines
;
;
;*** Compute length of each move
;
	mov	ax,[bp+14]	;  X1
	mov	dx,[bp+10]	;  X2
	sub	dx,ax		;  DX = X2 - X1
	inc	dx		;  num WORDS/line
	shl	dx,1		;  num bytes/line
	mov	bx,cx
;
;*** Compute workspace needed on stack
;
wksp:	sub	sp,dx
	loop	wksp
;
	mov	ax,ss
	mov	es,ax
	mov	di,sp		;  ES:DI has stack address
	push	dx
	push	bx

;
;*** Determine Video Address
;
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al, [bx]
	cmp	al,7
	jne	graphx
	mov	dx,0B000h
	jmp	m001
graphx:
	mov	dx,03DAh	; for IBM CGA,
VR:	in	al,dx		; we must do this
	and	al,1000b	; so we won't see
	jz	vr		; snow
	mov	dx,0B800h
m001:	mov	ds,dx
;
;*** Compute source address for move to stack
;
	mov	si,[bp+12]	;  Y1
        dec     si              ;  (Y1-1)
	mov	dx,si		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y1-1) * 128
	mov	cl,5
	shl	si,cl		;  (Y1-1) *  32
	add	si,dx		;  (Y1-1) * 160
	mov	ax,[bp+14]	;  X1
	dec	ax		;  (X1-1)
	shl	ax,1		;  2 * (X1-1)
	add	si,ax		;  SI = up left off
;
	pop	dx		; Number of lines
	pop	cx		; Bytes/line
	shr	cx,1		; Words/line
	push	ds
	push	si
;
	push	dx
	push	cx
;
;*** Move block from screen to stack
;
	mov	ax,160
	sub	ax,cx
	sub	ax,cx
	cld
MOVE1:  push    cx
rep	movsw
;
	pop	cx
	dec	dx
	jz	DONE1
	add	si,ax
	jmp	MOVE1
;
;*** Blank object on screen
;
DONE1:  pop     cx
	pop	dx
	pop	di
	pop	es
	push	dx
	push	cx
	mov	bx,160
	sub	bx,cx
	sub	bx,cx
        mov     ax,0E20h
	cld
AGAIN:	push	cx
rep	stosw
;
	pop	cx
	dec	dx
	jz	DONE2
	add	di,bx
	jmp	AGAIN
;
;*** Move saved object from stack workspace
;*** to new location on screen
;
DONE2:	mov	di,[bp+04]	;  Y3
        dec     di              ;  (Y3-1)
	mov	dx,di		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y3-1) * 128
	mov	cl,5
	shl	di,cl		;  (Y3-1) *  32
	add	di,dx		;  (Y3-1) * 160
	mov	ax,[bp+06]	;  X3 into AX
	dec	ax		;  (X3-1)
	shl	ax,1		;  2 * (X3-1)
	add	di,ax		;  DI=up left of new loc
;
;*** Move block
;
	pop	cx
	pop	dx
        mov     si,sp
	mov	ax,ss
	mov	ds,ax
;
	mov	ax,160
	sub	ax,cx
	sub	ax,cx
	cld
MOVER:  push    cx
rep	movsw
;
	pop	cx
	dec	dx
	jz	DONE3
	add	di,ax
        jmp     MOVER
;
DONE3:	mov	sp,bp
	sub	sp,2
        pop     ds
        mov     sp,bp
        pop     bp
	ret	12
MoveBlk endp
