;**************************************************
;
;       Procedure MOVEBG(Var PAGE : AnyBuf;
;                              X1 : ColumnType;
;                              Y1 : RowType;
;                              X2 : ColumnType;
;                              Y2 : RowType;
;                              X3 : ColumnType;
;                              Y3 : RowType ) ;
;
;       1. Captures block at (X1,Y1) and (X2,Y2)
;       2. Refreshes screen with PAGE
;       3. Moves saved block from stack to (X3,Y3)
;
;**************************************************
MoveBg  proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;
;*** Compute number of lines to move
;
	mov	ax,[bp+12]	; value of Y1 into AX
	mov	cx,[bp+08]	; value of Y2 into CX
        sub     cx,ax           ; CX = Y2 - Y1
	inc	cx		; CX = Number of lines
;
;
;*** Compute length of each move
;
	mov	ax,[bp+14]	;  X1 into AX
	mov	dx,[bp+10]	;  X2 into DX
	sub	dx,ax		;  DX = X2 - X1
	inc	dx		;  DX = num WORDS/line
	shl	dx,1		;  DX = num bytes/line
;
;*** Compute workspace needed on stack
;
wksp:	sub	sp,dx
	loop	wksp
	mov	ax,ss
	mov	es,ax
	mov	di,sp		;  ES:DI has stack address
;
;*** Determine Video address
;
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al,[bx]
	cmp	al,7
	jne	graphx
	mov	dx,0B000h
	jmp	c001
graphx:
	mov	dx,03DAh	; for IBM CGA,
VR:	in	al,dx		; we must do this
	and	al,1000b	; so we won't see
	jz	vr		; snow
	dec	dx
	dec	dx
	mov	al,21h
	out	dx,al		; disable video
	mov	dx,0B800h
c001:	push	dx

;
;*** Compute source address for move to stack
;
	mov	bx,[bp+12]	;  Y1 into BX
        dec     bx              ;  (Y1-1)
	mov	dx,bx		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y1-1) * 128
	mov	cl,5
	shl	bx,cl		;  (Y1-1) *  32
	add	bx,dx		;  (Y1-1) * 160
	mov	ax,[bp+14]	;  X1 into AX
	dec	ax		;  (X1-1)
	shl	ax,1		;  2 * (X1-1)
	add	bx,ax		;  BX = (Y1-1) * 160 + 2 * (X1-1) - 2
	mov	si,bx		;  Source string offset in SI
	pop	ds		;  DS:SI has starting address
;
	mov	ax,[bp+12]	;  value of Y1 into AX
	mov	dx,[bp+08]	;  value of Y2 into DX
        sub     dx,ax           ;  DX = Y2 - Y1
	inc	dx		;  DX = Number of lines
	push	dx
;
	mov	ax,[bp+14]	;  X1 into AX
	mov	cx,[bp+10]	;  X2 into CX
	sub	cx,ax		;  CX = X2 - X1
	inc	cx		;  CX = number of WORDS/line
	push	cx
	push	ds
;
;*** Move block from screen to stack
;
	mov	bx,cx
	shl	bx,1
	mov	ax,160
	sub	ax,bx		;  AX has SI increment
	cld
MOVE1:	push	cx
rep	movsw
;
	pop	cx
	dec	dx
	jz	DONE1
	add	si,ax
	jmp	MOVE1
;
;*** Copy screen image passed as parameter to video display
;
DONE1:  mov     di,0
	pop	es
	mov	cx,2000
	mov	si,[bp+16]
	mov	ds,[bp+18]
	cld
rep	movsw
;
;*** Move saved object from stack workspace to new location on screen
;
DONE2:	mov	bx,[bp+04]	;  Y3 into BX
        dec     bx              ;  (Y3-1)
	mov	dx,bx		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y3-1) * 128
	mov	cl,5
	shl	bx,cl		;  (Y3-1) *  32
	add	bx,dx		;  (Y3-1) * 160
	mov	ax,[bp+06]	;  X3 into AX
	dec	ax		;  (X3-1)
	shl	ax,1		;  2 * (X3-1)
	add	bx,ax		;  BX = (Y3-1) * 160 + 2 * (X3-1) - 2
	mov	di,bx		;  Destination string offset in DI
;
;*** Move block
;
	pop	cx
	pop	dx
        mov     si,sp
	mov	ax,ss
	mov	ds,ax
	mov	ax,160
	sub	ax,cx
	sub	ax,cx		;  AX = DI adjust
;
MOVER:	push	cx
        cld
rep	movsw
;
	pop	cx
	dec	dx
	jz	DONE3
	add	di,ax
        jmp     MOVER
;
DONE3:	mov	dx,es
	cmp	dx,0B800h
	jnz	return
	mov	dx,03D8h
	mov	al,29h
	out	dx,al
return: mov	sp,bp
	sub	sp,2
        pop     ds
        mov     sp,bp
        pop     bp
	ret	16
MoveBg  endp
