;**********************************************
;
;       Procedure MBLKHEAP ( Page : HeapBuf;
;                              X1 : ColumnType;
;                              Y1 : RowType;
;                              X2 : ColumnType;
;                              Y2 : RowType;
;                              X3 : ColumnType;
;                              Y3 : RowType);
;       offset 18,16,14,12,10,08,06,04  from BP
;
;       Moves block on Page at X1,Y1,X2,Y2
;                           to X3,Y3
;**********************************************
MBLKHEAP proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;
;*** Compute number of lines to move
;
	mov	ax,[bp+12]	; Y1
	mov	cx,[bp+08]	; Y2
        sub     cx,ax           ; CX = Y2 - Y1
	inc	cx		; Number of lines
;
;
;*** Compute length of each move
;
	mov	ax,[bp+14]	;  X1
	mov	dx,[bp+10]	;  X2
	sub	dx,ax		;  DX = X2 - X1
	inc	dx		;  num WORDS/line
	shl	dx,1		;  num bytes/line
	mov	bx,cx
;
;*** Compute workspace needed on stack
;
wksp:	sub	sp,dx
	loop	wksp
;
	mov	ax,ss
	mov	es,ax
	mov	di,sp		;  ES:DI has stack address
	push	dx
	push	bx

;
;*** Determine Page segment and offset addresses
;
	mov	si,[bp+16]
	mov	ax,[bp+18]
	mov	ds,ax
;
;*** Compute X,Y offset with page
;
	add	si,[bp+12]	;  Y1
        dec     si              ;  (Y1-1)
	mov	dx,si		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y1-1) * 128
	mov	cl,5
	shl	si,cl		;  (Y1-1) *  32
	add	si,dx		;  (Y1-1) * 160
	mov	ax,[bp+14]	;  X1
	dec	ax		;  (X1-1)
	shl	ax,1		;  2 * (X1-1)
	add	si,ax		;  SI = up left off
;
	pop	dx		; Number of lines
	pop	cx		; Bytes/line
	shr	cx,1		; Words/line
	push	ds
	push	si
;
	push	dx
	push	cx
;
;*** Move block from page to stack
;
	mov	ax,160
	sub	ax,cx
	sub	ax,cx
	cld
MOVE1:  push    cx
rep	movsw
;
	pop	cx
	dec	dx
	jz	DONE1
	add	si,ax
	jmp	MOVE1
;
;*** Blank object on page
;
DONE1:  pop     cx
	pop	dx
	pop	di
	pop	es
	push	dx
	push	cx
	mov	bx,160
	sub	bx,cx
	sub	bx,cx
        mov     ax,0E20h
	cld
AGAIN:	push	cx
rep	stosw
;
	pop	cx
	dec	dx
	jz	DONE2
	add	di,bx
	jmp	AGAIN
;
;*** Move saved object from stack workspace
;*** to new location on page
;
DONE2:	mov	di,[bp+16]	;  page offset
	add	di,[bp+04]	;  add Y3 offset
        dec     di              ;  (Y3-1)
	mov	dx,di		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y3-1) * 128
	mov	cl,5
	shl	di,cl		;  (Y3-1) *  32
	add	di,dx		;  (Y3-1) * 160
	mov	ax,[bp+06]	;  X3 into AX
	dec	ax		;  (X3-1)
	shl	ax,1		;  2 * (X3-1)
	add	di,ax		;  DI=up left of new loc
;
;*** Move block
;
	pop	cx
	pop	dx
        mov     si,sp
	mov	ax,ss
	mov	ds,ax
;
	mov	ax,160
	sub	ax,cx
	sub	ax,cx
	cld
MOVER:  push    cx
rep	movsw
;
	pop	cx
	dec	dx
	jz	DONE3
	add	di,ax
        jmp     MOVER
;
DONE3:	mov	sp,bp
	sub	sp,2
        pop     ds
        mov     sp,bp
        pop     bp
	ret	16
MBLKHEAP endp
