;**************************************************
;
;       Type
;          AnyString  =  string[255];
;          ColumnType =  0..80;
;          RowType    =  0..25;
;
;       Const
;          H  = 'H';
;          V  = 'V';
;
;       Procedure GetStr(    HV : Char;
;                         VAR S : AnyString;
;                             X : ColumnType;
;                             Y : RowType;
;                           LEN : Integer);
;
;       Reads string at X,Y into S for length LEN.
;       HV is either 'H' or 'V', indicating
;       a horizontal (right to left) get or a
;       vertical (top to bottom) get, respectively.
;       If X=Y=0, then read begins at current
;       cursor position.  Otherwise, read begins
;       at (X,Y).  On exit, cursor points to last
;       byte read plus one.
;
;**************************************************
GETSTR	proc	near
	push	bp
	mov	bp,sp
	push	ds
;
	mov	ax,[bp+8]	; get X
	or	ax,ax
	jz	g001
;
;       ***  Set DH,DL
;
	dec	al
	mov	dx,[bp+6]	; get Y
	dec	dl
	mov	dh,al
	xchg	dh,dl
	jmp	G002
;
;       ***  Get Cursor
;
G001:	xor	bh,bh
	mov	ah,3
	int	10h		; get cursor
;
;       ***  Set length of S
;
G002:	mov	es,[bp+12]	; segment of S
	mov	di,[bp+10]	; offset of S
	mov	cx,[bp+4]	; LEN
	mov	es:[di],cl	; set length
	inc	di
	push	cx
;
;       ***  Convert X,Y to offset
;
	mov	bl,dh		; row
	xor	bh,bh
	mov	ax,bx
	mov	cl,7
	shl	ax,cl		; row * 128
	mov	cl,5
	shl	bx,cl		; row * 32
	add	bx,ax		; row * 160
	mov	al,dl		; column
	xor	ah,ah
	shl	ax,1		; col * 2
	add	bx,ax		; cursor offset
;
;       ***  Move string to S
;
	pop	cx
	mov	si,bx
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al,[bx]	; video mode byte
	cmp	al,7
	jne	graphx
	mov	dx,0B000h
	jmp	c001
graphx:
	mov	dx,03DAh	; for IBM CGA,
VR:	in	al,dx		; we must do this
	and	al,1000b	; so we won't see
	jz	vr		; snow . . .
	mov	dx,0B800h
c001:	mov	ds,dx
;
	mov	dx,[bp+14]
	cmp	dl,'v'
	je	g002a
	cmp	dl,'V'
	je	g002a
	mov	dx,2		; Set H incr
	jmp	g003
G002a:	mov	dx,160		; Set V incr
;
G003:	mov	al,ds:[si]	; get screen char
	stosb			; store it in str
	add	si,dx		; next screen char
	loop	g003		; loop until done
	cmp	dl,2
	je	g004
	sub	si,158
;
;       ***  Set Cursor
;            for exit
;
G004:	mov	ax,si
	xor	dx,dx
	mov	bx,160
	div	bx
	shr	dl,1
	mov	dh,al
	mov	ah,2
	int	10h
;
	pop	ds
	mov	sp,bp
	pop	bp
	ret	12
GETSTR	endp


