;**************************************************
;
;       Type
;          AnyString  =  string[255];
;          ColumnType =  0..80;
;          RowType    =  0..25;
;
;       Const
;          H  = 'H';
;          V  = 'V';
;
;       Procedure GetHeap( Page : HeapBuf;
;                            HV : Char;
;                         VAR S : AnyString;
;                             X : ColumnType;
;                             Y : RowType;
;                           LEN : Integer);
;
;       Reads string at X,Y into S for length LEN.
;       HV is either 'H' or 'V', indicating
;       a horizontal (right to left) get or a
;       vertical (top to bottom) get, respectively.
;
;       HeapBuf is a pointer to a 4000-byte page
;       on the heap.
;
;**************************************************
GETHEAP proc	near
	push	bp
	mov	bp,sp
	push	ds
;
;       ***  Set length of S
;
G002:	mov	es,[bp+12]	; segment of S
	mov	di,[bp+10]	; offset of S
	mov	cx,[bp+4]	; LEN
	mov	es:[di],cl	; set length
	inc	di
	push	cx
;
;       ***  Convert X,Y to offset
;
	mov	bx,[bp+6]	; get Y
	dec	bx
	mov	ax,bx
	mov	cl,7
	shl	ax,cl		; row * 128
	mov	cl,5
	shl	bx,cl		; row * 32
	add	bx,ax		; row * 160
	mov	ax,[bp+8]	; get X
	dec	ax
	shl	ax,1		; col * 2
	add	bx,ax		; Heap offset
;
;       ***  Move string to S
;
	pop	cx
	mov	si,[bp+16]	; Heap offset
	add	si,bx		; X,Y offset
	mov	ax,[bp+18]	; Heap Segment
	mov	ds,ax
;
	mov	dx,[bp+14]
	cmp	dl,'v'
	je	g002a
	cmp	dl,'V'
	je	g002a
	mov	dx,2		; Set H incr
	jmp	g003
G002a:	mov	dx,160		; Set V incr
;
G003:	mov	al,ds:[si]	; get Heap char
	stosb			; store it in str
	add	si,dx		; next Heap char
	loop	g003		; loop until done
	cmp	dl,2
	je	g004
	sub	si,158
;
G004:
	pop	ds
	mov	sp,bp
	pop	bp
	ret	16
GETHEAP endp


