;**********************************************
;
;      Procedure FStrHeap ( Page : HeapBuf;
;                              S : AnyString;
;                         var  X : ColumnType;
;                         var  Y : RowType );
;
;      Searches Page of heap for S.  If found,
;      FstrHeap sets X,Y to location of S[1].
;      If not found, sets X = 0.
;
;**********************************************
FSTRHEAP proc	near
	push	bp
	mov	bp,sp
	push	ds

	mov	bx,[bp+8]	;  X offset
	mov	[bx],0		;  init to zero
;
;*** Determine starting address of Page
;
	mov	di,[bp+268]
	push	di
	mov	ax,[bp+270]
	mov	es,ax
;
;***  Find string S on page
;
	mov	cx,4000
	xor	dh,dh
	xor	ah,ah
;
INIT:	lea	bx,[bp+13]
	mov	al,ss:[bx]	; 1st char of S
	mov	dl,[bp+12]	; len of S
COMPARE: cmp	al,es:[di]
	je	match
	add	di,2
	sub	cx,2
	jna	notfound
	jmp	compare
;
MATCH:  sub     dl,1
	jz	found
NEXT1:	add	di,2
	inc	bx
	mov	al,ss:[bx]
	cmp	al,es:[di]
	jne	Init
	sub	dl,1
	jz	found
	sub	cx,2
	jna	notfound
	jmp	next1
;
;***  Set X,Y Coordinates
;
FOUND:  mov     ax,di
	pop	di
	sub	ax,di
	mov	dl,[bp+12]	; len of S
	dec	dl
	shl	dl,1
	sub	ax,dl		; s[1] addr
	mov	bl,160
	div	bl		; divide AH:AL by BL
	shr	ah,1
	inc	ah		; X value
	inc	al		; Y value
	mov	bx,[bp+10]
	mov	ds,bx		; data seg of X,Y
	mov	bx,[bp+08]	; X offset from DS
	mov	[bx],ah
	mov	byte ptr [bx+1],0
	mov	bx,[bp+04]	; Y offset from DS
	mov	[bx],al
	mov	byte ptr [bx+1],0
	jmp	return
;
;***   Not Found - pop di off stack
;
NotFound: pop   di
;
;***  Return
;
RETURN:
	pop	ds
	mov	sp,bp
	pop	bp
	ret	268
FSTRHEAP endp