;*****************************************************
;
;        Procedure FindStr (X : ColumnType;
;                           Y : RowType;
;                           S : AnyString;
;                           O : Integer;
;                       var E : Integer);
;
;               Places the cursor at offset O from S.
;               Search begins in video memory at X,Y.
;
;               E = 0, S found
;               E = 1, S not found
;
;               O = zero, cursor at S[1]
;               O < zero, cursor to left of S
;               O > zero, cursor to right of S
;
;*****************************************************
FINDSTR proc	near
	push	bp
	mov	bp,sp
	push	ds

	mov	bx,[bp+4]	;  address of error flag
	mov	[bx],0		;  init to zero
;
;*** Determine Video address
;
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al,[bx]
	cmp	al,7
	jne	graphx
	mov	dx,0B000h
	jmp	c001
graphx:
	mov	dx,03DAh	; for IBM CGA,
VR:	in	al,dx		; we must do this
	and	al,1000b	; so we won't see
	jz	vr		; snow . . .
	dec	dx
	dec	dx
	mov	al,21h
	out	dx,al		; disable video
	mov	dx,0B800h
C001:	mov	es,dx
;
;***  Compute X,Y offset
;
	mov	di,[bp+266]	;  Y
        dec     di              ;  (Y-1)
	mov	dx,di		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y-1) * 128
	mov	cl,5
	shl	di,cl		;  (Y-1) *  32
	add	di,dx		;  (Y-1) * 160
	mov	ax,[bp+268]	;  X into AX
	dec	ax		;  (X-1)
	shl	ax,1		;  2 * (X-1)
	add	di,ax		;  byte offset
;
;***  Find string S on screen
;
	mov	cx,4000
	sub	cx,di
	shl	cx,1		; length of search
;
INIT:	lea	bx,[bp+11]
	mov	al,ss:[bx]	; 1st char of S
	mov	dl,[bp+10]	; len of S
SCAN:
	cmp	al,es:[di]
	je	got1
	inc	di
	inc	di
	dec	cx
	jcxz	enable		; S not found
	jmp	scan		; keep looking
;
GOT1:   sub     dl,1
	jz	enable
NEXT1:	inc	di
	inc	di
	inc	bx
	mov	al,ss:[bx]
	cmp	al,es:[di]
	jne	Init
	sub	dl,1
	jz	enable
	dec	cx
	jcxz	enable
	jmp	next1
;
;***  enable video signal
;
ENABLE:
	mov	dx,es
	cmp	dx,0B800h
	jne	skip
	mov	dx,03D8h
	mov	al,29h
	out	dx,al		; enable video
	or	cx,cx
	jz	not_found
;
;***  adjust DI according to offset value, O
;
SKIP:	add	di,2
        mov     ax,[bp+8]       ; O
	sub	ax,0		; O:0
	jg	gt_zero
	mov	dl,[bp+10]	; len of S
	shl	dl,1
	xor	dh,dh
	sub	di,dx		; di -> S[1]
	sub	ax,0		; O=0?
	jz	m_cursor
	neg	ax		; O < 0
	shl	ax,1		; compute offset
	sub	di,ax		; adjust di
	jmp	m_cursor
GT_ZERO:
	dec	ax
	shl	ax,1
	add	di,ax		; cursor address

;
;***  Set Cursor
;
M_CURSOR:
	cmp	di,0
	jge	max_chk
	xor	di,di
	jmp	end_chks
max_chk:
	cmp	di,3998
	jbe	end_chks
	mov	di,3998
end_chks:
        mov     ax,di
	mov	bx,160
	div	bl
	shr	ah,1		; remainder is col
	mov	dl,ah
	mov	dh,al		; quotient is row
	mov	ah,2		; set cursor routine
	int	10h		; call BIOS
	jmp	return
;
;*** Set error flag to 1
;
NOT_FOUND:
	mov	bx,[bp+4]
	mov	ax,[bp+6]
	mov	ds,ax
	mov	[bx],1
;
;***  Return
;
RETURN:
	pop	ds
	mov	sp,bp
	pop	bp
	ret	266
FINDSTR endp