;*************************************************
;
;       Procedure FILLHEAP ( Page : HeapBuf;
;                            X1,Y1,X2,Y2 : Integer;
;                            C : Char;
;                          Att : Byte);
;
;       Fills Page of heap with C characters,
;       of attribute Att,
;       in screen-image format, beginning at
;          X1,Y1 (upper left)
;       through and including
;          X2,Y2 (lower right).
;
;*************************************************
FILLHEAP proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;
;*** Compute number of lines to fill
;
	mov	ax,[bp+12]	; value of Y1 into AX
	mov	dx,[bp+08]	; value of Y2 into CX
        sub     dx,ax           ; DX = Y2 - Y1
	inc	dx		; DX = Number of lines
	push	dx
;
;
;*** Compute length of each line
;
	mov	ax,[bp+14]	;  X1
	mov	cx,[bp+10]	;  X2
	sub	cx,ax		;  CX = X2 - X1
	inc	cx		;  CX = num WORDS/line
	push	cx
;
;*** Determine Page of heap to fill
;
	mov	di,[bp+16]
	mov	ax,[bp+18]
	mov	es,ax
;
;*** Compute upper left offset of page
;
	mov	bx,[bp+12]	;  Y1
        dec     bx              ;  (Y1-1)
	mov	dx,bx		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y1-1) * 128
	mov	cl,5
	shl	bx,cl		;  (Y1-1) *  32
	add	bx,dx		;  (Y1-1) * 160
	mov	ax,[bp+14]	;  X1 into AX
	dec	ax		;  (X1-1)
	shl	ax,1		;  2 * (X1-1)
	add	bx,ax		;  rel offset
	add	di,bx		;  page offset
;
	pop	cx		; Num words/line
	pop	dx		; Num lines to blank
;
;*** Fill page in heap
;
	mov	ax,[bp+6]	; get char
	mov	bx,[bp+4]	; get attribute
	mov	ah,bl
	mov	bx,160
	sub	bx,cx
	sub	bx,cx
	cld
AGAIN:	push	cx
rep	stosw
;
	pop	cx
	dec	dx
	jz	DONE2
	add	di,bx
	jmp	AGAIN
;
DONE2:
        pop     ds
        mov     sp,bp
        pop     bp
	ret	16
FILLHEAP  endp
